/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.common.DefinitionOptionsBase;
import cl.mc3d.as4p.common.DefinitionOptionsUse;
import cl.mc3d.as4p.ui.InputText;
import cl.mc3d.crossover.soa.common.Schema;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class CommandButton
extends JButton
implements ActionListener {
    private String id = null;
    private String latitud = null;
    private String longitud = null;
    static final long serialVersionUID = -3681654295856629607L;
    private Schema temporalSpace = new Schema();
    private DefinitionOptionsUse use;
    private DefinitionOptionsBase base;
    private String theme = null;
    private InputText selectionFile = null;

    public Schema getTemporalSpace() {
        return this.temporalSpace;
    }

    public void setTemporalSpace(Schema temporalSpace) {
        this.temporalSpace = temporalSpace;
    }

    public String getLatitud() {
        return this.latitud;
    }

    public void setLatitud(String latitud) {
        this.latitud = latitud;
    }

    public String getLongitud() {
        return this.longitud;
    }

    public void setLongitud(String longitud) {
        this.longitud = longitud;
    }

    public CommandButton() {
        super.addActionListener(this);
    }

    public CommandButton(String text) {
        this.setText(text);
        super.addActionListener(this);
        super.setRolloverEnabled(true);
        super.setRolloverEnabled(true);
        super.setToolTipText(text);
        this.initDefaults();
    }

    private void initDefaults() {
        this.setFont(new Font("Segoe UI", 0, 14));
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public DefinitionOptionsUse getUse() {
        return this.use;
    }

    public void setUse(DefinitionOptionsUse use) {
        this.use = use;
        if (use.equals((Object)DefinitionOptionsUse.PROHIBITED)) {
            // empty if block
        }
    }

    public DefinitionOptionsBase getBase() {
        return this.base;
    }

    public void setBase(DefinitionOptionsBase base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme, boolean header) {
        this.theme = theme;
        if (theme == null) {
            return;
        }
        String t = theme.toLowerCase();
        Color bg = new Color(230, 230, 230);
        Color fg = Color.BLACK;
        Color hover = new Color(200, 200, 200);
        switch (t) {
            case "eggplant": {
                bg = new Color(222, 220, 224);
                fg = new Color(102, 88, 116);
                hover = new Color(200, 190, 215);
                break;
            }
            case "le-frog": {
                bg = new Color(167, 230, 103);
                fg = Color.BLACK;
                hover = new Color(145, 209, 64);
                break;
            }
            case "bluesky": {
                bg = new Color(198, 222, 255);
                break;
            }
            case "humanity": {
                bg = new Color(241, 235, 223);
                break;
            }
            case "midnight": {
                bg = new Color(38, 38, 45);
                fg = Color.WHITE;
                hover = new Color(60, 60, 70);
                break;
            }
            case "redmond": {
                bg = new Color(234, 244, 253);
                fg = new Color(46, 110, 158);
            }
        }
        if (header) {
            this.setFont(this.getFont().deriveFont(1, 18.0f));
        }
        this.setBackground(bg);
        this.setForeground(fg);
        final Color finalBg = bg;
        final Color finalHover = hover;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CommandButton.this.setBackground(finalHover);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CommandButton.this.setBackground(finalBg);
            }
        });
    }

    public InputText getSelectionFile() {
        return this.selectionFile;
    }

    public void setSelectionFile(InputText selectionFile) {
        this.selectionFile = selectionFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser jf;
        if (this.selectionFile != null && (jf = new JFileChooser()).showOpenDialog(this) == 0) {
            this.selectionFile.setText(jf.getSelectedFile().toString());
        }
    }
}

