/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.syncjars;

import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLPermission;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SandboxPolicy
extends Policy {
    private final Permissions sandboxPermissions = new Permissions();
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public SandboxPolicy(String appletURL) {
        this.sandboxPermissions.add(new RuntimePermission("exitVM"));
        this.sandboxPermissions.add(new PropertyPermission("os.arch", "read"));
        this.sandboxPermissions.add(new PropertyPermission("os.name", "read"));
        this.sandboxPermissions.add(new PropertyPermission("os.version", "read"));
        this.sandboxPermissions.add(new PropertyPermission("file.separator", "read"));
        this.sandboxPermissions.add(new PropertyPermission("java.vendor", "read"));
        this.sandboxPermissions.add(new PropertyPermission("java.vendor.url", "read"));
        this.sandboxPermissions.add(new PropertyPermission("java.version", "read"));
        this.sandboxPermissions.add(new PropertyPermission("java.class.version", "read"));
        try {
            URL url = new URL(appletURL);
            URI uri = url.toURI();
            String host = uri.getHost();
            if (host != null && !host.isEmpty()) {
                this.logger.info("Granting network permissions to host: " + host);
                this.sandboxPermissions.add(new SocketPermission(host + ":*", "connect,resolve"));
                this.sandboxPermissions.add(new URLPermission("http://" + host + "/*", "*"));
                this.sandboxPermissions.add(new URLPermission("https://" + host + "/*", "*"));
                this.logger.info("URLPermissions for jar resources on host " + host + " granted.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error assigning sandbox network permissions", e);
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        try {
            URL location = codesource.getLocation();
            if (location != null) {
                this.logger.info("getPermissions() called for: " + location);
                String proto = location.getProtocol();
                if ("jar".equalsIgnoreCase(proto)) {
                    String s = location.toString();
                    int bang = s.indexOf("!/");
                    if (bang > 4) {
                        String outer = s.substring(4, bang);
                        URL outerUrl = new URL(outer);
                        SandboxPolicy.grantHostUrlPerms(this.sandboxPermissions, outerUrl.getProtocol(), outerUrl.getHost());
                        if ("raw.githubusercontent.com".equalsIgnoreCase(outerUrl.getHost())) {
                            SandboxPolicy.grantHostUrlPerms(this.sandboxPermissions, "https", "codeload.github.com");
                        }
                    }
                } else if ("http".equalsIgnoreCase(proto) || "https".equalsIgnoreCase(proto)) {
                    SandboxPolicy.grantHostUrlPerms(this.sandboxPermissions, proto, location.getHost());
                    if ("raw.githubusercontent.com".equalsIgnoreCase(location.getHost())) {
                        SandboxPolicy.grantHostUrlPerms(this.sandboxPermissions, "https", "codeload.github.com");
                    }
                } else if (location.toString().startsWith("jrt:/javafx.") || location.toString().startsWith("jrt:/java.")) {
                    this.sandboxPermissions.add(new AllPermission());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error resolving dynamic permissions from CodeSource", e);
        }
        return this.sandboxPermissions;
    }

    private static void grantHostUrlPerms(Permissions perms, String scheme, String host) {
        if (scheme == null || host == null || host.length() == 0) {
            return;
        }
        perms.add(new SocketPermission(host + ":*", "connect,resolve"));
        String urlPattern = scheme + "://" + host + "/-";
        try {
            perms.add(new URLPermission(urlPattern, "*:*"));
        }
        catch (IllegalArgumentException ex) {
            perms.add(new URLPermission(scheme + "://" + host + "/*", "*:*"));
        }
    }
}

