/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.syncjars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class SSLCertificateInstaller {
    public void connectToHttps(String httpsUrl) {
        try {
            URL url = new URL(httpsUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            conn.disconnect();
        }
        catch (SSLHandshakeException sslEx) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "SSL Error: " + sslEx.getMessage());
            X509Certificate serverCert = SSLCertificateInstaller.getServerCertificate(httpsUrl);
            if (serverCert != null) {
                boolean accept = SSLCertificateInstaller.showCertificateDialog(serverCert, sslEx.getMessage());
                if (accept) {
                    try {
                        String certPath = this.downloadCertificate(serverCert, httpsUrl);
                        this.installCertificate(certPath, httpsUrl);
                        SSLCertificateInstaller.showMessage("Success", "Certificate successfully installed into cacerts.\nPlease try connecting again.", "Information");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SSLCertificateInstaller.showMessage("Error", "Error installing the certificate:\n" + e.getMessage(), "Error");
                    }
                } else {
                    SSLCertificateInstaller.showMessage("Rejected", "Certificate rejected by the user.", "Warning");
                }
            } else {
                SSLCertificateInstaller.showMessage("Error", "Could not retrieve the certificate from the server.", "Error");
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            SSLCertificateInstaller.showMessage("Error", "Error de I/O al conectar:\n" + ioEx.getMessage(), "Error");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getServerCertificate(String httpsUrl) {
        try {
            URL url = new URL(httpsUrl);
            String host = url.getHost();
            int port = url.getPort() != -1 ? url.getPort() : 443;
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            SSLSocketFactory factory = sc.getSocketFactory();
            try (SSLSocket socket = (SSLSocket)factory.createSocket(host, port);){
                socket.setSoTimeout(10000);
                socket.startHandshake();
                SSLSession session = socket.getSession();
                Certificate[] certs = session.getPeerCertificates();
                if (certs == null) return null;
                if (certs.length <= 0) return null;
                if (!(certs[0] instanceof X509Certificate)) return null;
                X509Certificate x509Certificate = (X509Certificate)certs[0];
                return x509Certificate;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean showCertificateDialog(X509Certificate cert, String errorMsg) {
        String certDetails = "An SSL error occurred:\n" + errorMsg + "\n\nUntrusted Certificate Details:\nIssuer: " + cert.getIssuerDN().getName() + "\nSubject: " + cert.getSubjectDN().getName() + "\nValid from: " + cert.getNotBefore() + "\nValid until: " + cert.getNotAfter() + "\nSerial Number: " + cert.getSerialNumber().toString(16) + "\n\nDo you want to trust this certificate and continue?";
        int response = JOptionPane.showConfirmDialog(null, certDetails, "SSL Certificate not trusted", 0, 2);
        return response == 0;
    }

    public String downloadCertificate(X509Certificate cert, String httpsUrl) throws Exception {
        String alias = SSLCertificateInstaller.generateAlias(cert, httpsUrl);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Alias for the .cer file: " + alias);
        String fileName = alias + ".cer";
        File certFile = new File(fileName);
        try (FileOutputStream fos = new FileOutputStream(certFile);){
            fos.write(cert.getEncoded());
        }
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Certificate saved at: " + certFile.getAbsolutePath());
        return certFile.getAbsolutePath();
    }

    public void installCertificate(String certPath, String httpsUrl) throws Exception {
        String javaHome = System.getProperty("java.home");
        String cacertsPath = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        String alias = SSLCertificateInstaller.generateAlias(null, httpsUrl);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "javaHome: " + javaHome);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "cacertsPath: " + cacertsPath);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "alias: " + alias);
        String keytoolCmd = "keytool -import -trustcacerts -alias " + alias + " -file \"" + certPath + "\" -keystore \"" + cacertsPath + "\" -storepass changeit -noprompt";
        Process process = Runtime.getRuntime().exec(keytoolCmd);
        process.waitFor();
        if (process.exitValue() != 0) {
            String line;
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder errorMsg = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                errorMsg.append(line).append("\n");
            }
            throw new Exception("Certificate import error: " + errorMsg.toString());
        }
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Certificate " + alias + " successfully imported into cacerts.");
    }

    public static String generateAlias(X509Certificate cert, String httpsUrl) {
        String issuer = cert != null ? cert.getIssuerDN().getName().replaceAll(",", "_").replaceAll("=", "_") : "issuer_unknown";
        String subject = cert != null ? cert.getSubjectDN().getName().replaceAll(",", "_").replaceAll("=", "_") : "subject_unknown";
        String alias = httpsUrl.substring(httpsUrl.indexOf("://") + 3, httpsUrl.length());
        if (alias.contains("/")) {
            alias = alias.substring(0, alias.indexOf("/"));
        }
        if (alias.contains(":")) {
            alias = alias.substring(0, alias.indexOf(":"));
        }
        return alias;
    }

    public static void showMessage(String title, String message, String type) {
        int messageType;
        switch (type.toLowerCase()) {
            case "error": {
                messageType = 0;
                break;
            }
            case "information": {
                messageType = 1;
                break;
            }
            case "warning": {
                messageType = 2;
                break;
            }
            default: {
                messageType = -1;
            }
        }
        JOptionPane.showMessageDialog(null, message, title, messageType);
    }
}

