/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.syncjars;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MemoryClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classData = new HashMap<String, byte[]>();

    public MemoryClassLoader(URL zipUrl, ClassLoader parent) throws IOException {
        super(parent);
        this.loadClassesFromZip(zipUrl);
    }

    private void loadClassesFromZip(URL zipUrl) throws IOException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\ud83d\udce6 Cargando clases desde ZIP en memoria: " + zipUrl);
        byte[] zipBytes = this.downloadZipToMemory(zipUrl);
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                String className = entry.getName().replace("/", ".").replace(".class", "");
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\ud83d\udd39 Cargando clase en memoria: " + className);
                byte[] classBytes = this.readZipEntryToMemory(zis);
                this.classData.put(className, classBytes);
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.classData.get(name);
        if (classBytes == null) {
            throw new ClassNotFoundException("Clase no encontrada en ZIP: " + name);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    /*
     * Exception decompiling
     */
    private byte[] downloadZipToMemory(URL zipUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] readZipEntryToMemory(ZipInputStream zis) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = zis.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

