/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.ui.CommandButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Div
extends JPanel {
    private String theme = null;
    private CommandButton cbTitle = new CommandButton();
    private boolean header = false;

    public Div() {
    }

    public Div(String textLocal, URL sIcon, LayoutManager layout) {
        super(layout);
        if (textLocal != null && textLocal.contains("<html><body><h2><html>")) {
            textLocal = textLocal.replaceAll("<html><body><h2><html>", "<html>");
            textLocal = textLocal.replaceAll("</html></h2></body></html>", "</html>");
        }
        this.cbTitle = new CommandButton(textLocal);
        this.cbTitle.setSelected(false);
        this.cbTitle.setFocusable(false);
        if (sIcon != null) {
            try {
                Dimension dimension = this.getToolkit().getScreenSize();
                ImageIcon imageIcon = new ImageIcon(sIcon);
                this.cbTitle.setIcon(imageIcon);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (textLocal != null) {
            if (layout instanceof FlowLayout) {
                this.cbTitle.setVerticalTextPosition(1);
                this.add(this.cbTitle);
            } else if (layout instanceof BorderLayout) {
                this.cbTitle.setVerticalAlignment(1);
                this.cbTitle.setVerticalTextPosition(3);
                this.cbTitle.setHorizontalTextPosition(0);
                this.add("North", this.cbTitle);
            }
        }
    }

    public void setJlTitle(String text) {
        this.cbTitle.setText(text);
    }

    public String getJlTitle() {
        return this.cbTitle.getText();
    }

    public CommandButton getCbTitle() {
        return this.cbTitle;
    }

    public void setCbTitle(CommandButton cbTitle) {
        this.cbTitle = cbTitle;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme, boolean header) {
        this.theme = theme;
        this.header = header;
        this.cbTitle.setTheme(theme, true);
        if (header) {
            this.cbTitle.setFont(new Font("Segoe UI", 1, 26));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.theme != null) {
            GradientPaint gp = null;
            switch (this.theme.toLowerCase()) {
                case "eggplant": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(92, 86, 98), 0.0f, this.getHeight(), new Color(61, 54, 68));
                    break;
                }
                case "humanity": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(208, 144, 66), 0.0f, this.getHeight(), new Color(203, 142, 47));
                    break;
                }
                case "le-frog": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(114, 191, 68), 0.0f, this.getHeight(), new Color(77, 130, 33));
                    break;
                }
                case "midnight": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(48, 48, 58), 0.0f, this.getHeight(), new Color(30, 30, 40));
                    break;
                }
                case "ui-darkness": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(76, 76, 76), 0.0f, this.getHeight(), new Color(57, 57, 57));
                    break;
                }
                case "redmond": {
                    gp = new GradientPaint(0.0f, 0.0f, new Color(136, 182, 217), 0.0f, this.getHeight(), new Color(102, 162, 207));
                }
            }
            if (gp != null) {
                g2.setPaint(gp);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        g2.dispose();
    }
}

