/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.syncjars;

import cl.mc3d.as4p.ui.Body;
import cl.mc3d.as4p.ui.CommandButton;
import cl.mc3d.as4p.ui.Div;
import cl.mc3d.as4p.ui.InputText;
import cl.mc3d.as4p.ui.OutputLabel;
import cl.mc3d.syncjars.MemoryClassLoader;
import cl.mc3d.syncjars.SSLCertificateInstaller;
import cl.mc3d.syncjars.SandboxPolicy;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.GeneralSecurityException;
import java.security.Policy;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SyncJars {
    private Thread thread = null;
    JDesktopPane jd = new JDesktopPane();
    private String theme = "midnight";
    private Map params = new HashMap();
    private Map jars = new HashMap();
    private JTextArea jtConsole = new JTextArea();
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("/resources/mc3d-icon.png"));
    private static JFrame ventana = new JFrame();
    private JTabbedPane jTab = new JTabbedPane();
    static String host = "";
    private String javaHome = System.getProperty("java.home");
    private boolean jnlp = false;
    private static String jsessionid = null;

    public SyncJars(String arg) {
        SyncJars.redirectSystemOutToTextArea(this.jtConsole);
        ventana.setIconImage(this.icon.getImage());
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                SwingUtilities.updateComponentTreeUI(ventana);
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error manejado" + ex.toString());
        }
        ventana.setTitle("Phoenix Applet & WebStart Revival by MC3D.CL.");
        String version = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        String osName = System.getProperty("os.name");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "osName: " + osName);
        String osArch = System.getProperty("os.arch");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "osArch: " + osArch);
        String osVersion = System.getProperty("os.version");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "osVersion: " + osVersion);
        String osJavaHome = System.getProperty("java.home");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "JavaHome: " + osJavaHome);
        Body commandPanel = new Body(new BorderLayout(5, 5));
        commandPanel.setTheme(this.theme);
        ImageIcon mc3dIcon = new ImageIcon();
        CommandButton jbMc3dLogo = new CommandButton("<html><body><h2>Click here for access to documentation</h2><h1 bgcolor=#334877><font color=\"white\">Running on Java <font color=\"orange\">" + version + "</h1><hr/>java vendor: " + vendor + "</body></html>");
        jbMc3dLogo.setTheme(this.theme, true);
        jbMc3dLogo.setVerticalTextPosition(3);
        jbMc3dLogo.setHorizontalTextPosition(0);
        try {
            mc3dIcon.setImage(new ImageIcon(this.getClass().getResource("/resources/phoenix_logo2.png")).getImage());
            jbMc3dLogo.setIcon(mc3dIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jbMc3dLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "https://www.mc3d.cl/web/guest/phoenix-applet-webstart-revival";
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(new URI(url));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Web browser navigation call not supported.");
                }
            }
        });
        JPanel consolePanel = new JPanel(new BorderLayout(5, 5));
        Body aboutPanel = new Body(new BorderLayout(5, 5));
        aboutPanel.setTheme(this.theme);
        commandPanel.add("North", jbMc3dLogo);
        CommandButton jbDonate = new CommandButton("<html><body><h2>Support Phoenix AWR</h2></body></html>");
        jbDonate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon qrIcon = new ImageIcon(this.getClass().getResource("/resources/donate-qr.png"));
                Div jpQR = new Div();
                jpQR.setTheme(SyncJars.this.theme, false);
                CommandButton jbMc3dQR = new CommandButton("It is our paypal link: ");
                jbMc3dQR.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String url = "https://www.paypal.com/donate/?hosted_button_id=Q5NNEKTEVTFV4";
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(new URI(url));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Web browser navigation call not supported.");
                        }
                    }
                });
                jbMc3dQR.setVerticalTextPosition(3);
                jbMc3dQR.setHorizontalTextPosition(0);
                jbMc3dQR.setTheme(SyncJars.this.theme, true);
                jbMc3dQR.setIcon(qrIcon);
                jpQR.add("Center", jbMc3dQR);
                JOptionPane.showMessageDialog(null, jpQR);
            }
        });
        jbDonate.setTheme("le-frog", true);
        commandPanel.add("South", jbDonate);
        aboutPanel.add("North", commandPanel);
        consolePanel.add("West", aboutPanel);
        JPanel jpManualRunningPanel = new JPanel(new FlowLayout());
        OutputLabel olManualRunning = new OutputLabel("Applet/JApplet/JNLP/JFX URL");
        jpManualRunningPanel.add(olManualRunning);
        final InputText itManualRunning = new InputText("", 12);
        jpManualRunningPanel.add(itManualRunning);
        CommandButton cbManualRunning = new CommandButton("Run");
        cbManualRunning.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker sw = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        SyncJars.this.findApplet(itManualRunning.getText());
                        return null;
                    }
                };
                sw.execute();
            }
        });
        jpManualRunningPanel.add(cbManualRunning);
        aboutPanel.add("Center", jpManualRunningPanel);
        consolePanel.setLocation(0, 0);
        consolePanel.setSize(consolePanel.getMaximumSize());
        this.jd.add(consolePanel);
        JScrollPane jsConsole = new JScrollPane(this.jtConsole);
        JInternalFrame jf = new JInternalFrame("Phoenix AWR Console");
        jf.setMaximizable(true);
        jf.setResizable(true);
        jf.add(jsConsole);
        jf.setLocation(410, 0);
        jf.setSize(400, 560);
        this.jd.add(jf);
        jf.setVisible(true);
        ventana.add("Center", this.jd);
        ventana.validate();
        if (host == null || host == "") {
            host = this.detectarUrlDesdeNombreJar();
            itManualRunning.setText(host);
            if (host != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Jar name: {0}", host);
            }
        }
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                SyncJars.this.findApplet(host);
                return null;
            }
        };
        sw.execute();
    }

    public void findApplet(String arg) {
        if (arg.length() > 0) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Scanning URL: " + arg);
            if (arg.startsWith("{url:")) {
                arg = arg.substring(arg.indexOf("{url:") + 5, arg.length());
            }
            if (arg.endsWith("}")) {
                arg = arg.substring(0, arg.lastIndexOf("}"));
            }
            String sCodeBase = "";
            if (arg.length() >= 0) {
                if (!arg.toLowerCase().startsWith("http") && arg.toLowerCase().endsWith(".jnlp")) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "JNLP URL: " + arg);
                    this.jnlp = true;
                }
                try {
                    String sEndObject;
                    int endObject;
                    String sObject;
                    if (arg.toLowerCase().contains("https://github.com/") && (arg = arg.replace("https://github.com/", "https://raw.githubusercontent.com/")).toLowerCase().contains("/blob/")) {
                        arg = arg.replace("/blob/", "/refs/heads/");
                    }
                    if (arg.toLowerCase().startsWith("https://")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Validate Cert for URL: {0}", arg);
                        SSLCertificateInstaller sSLCertificateInstaller = new SSLCertificateInstaller();
                        sSLCertificateInstaller.connectToHttps(arg);
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Valid URL");
                    StringBuilder sb = new StringBuilder();
                    if (arg.toLowerCase().startsWith("http")) {
                        int inputLine;
                        URL sourceURL = new URL(arg);
                        HttpURLConnection urlc = (HttpURLConnection)sourceURL.openConnection();
                        urlc.setAllowUserInteraction(true);
                        urlc.setInstanceFollowRedirects(true);
                        urlc.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.6261.94 Safari/537.36");
                        urlc.setRequestProperty("Content-Type", "text/plain;charset=UTF-8");
                        urlc.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7");
                        urlc.setRequestProperty("Accept-Language", "es-MX,es;q=0.9,es-419;q=0.8,en;q=0.7");
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Server response: " + urlc.getHeaderField("jsessionid"));
                        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Server response:");
                        while ((inputLine = in.read()) != -1) {
                            sb.append((char)inputLine);
                            System.out.print((char)inputLine);
                        }
                        in.close();
                        urlc.disconnect();
                    } else {
                        int inputLine;
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "File protocol:" + arg);
                        FileInputStream in = new FileInputStream(arg);
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "File response:");
                        while ((inputLine = in.read()) != -1) {
                            sb.append((char)inputLine);
                            System.out.print((char)inputLine);
                        }
                        in.close();
                    }
                    String sHtml = sb.toString();
                    sHtml = sHtml.replaceAll("\r", " ");
                    sHtml = sHtml.replaceAll("\n", " ");
                    sHtml = sHtml.replaceAll("\t", " ");
                    while (sHtml.contains("  ")) {
                        sHtml = sHtml.replaceAll("  ", " ");
                    }
                    sHtml = sHtml.replaceAll(" =", "=");
                    if ((sHtml = sHtml.replaceAll("= ", "=")).toLowerCase().contains("<jnlp")) {
                        int startObject;
                        String sBlockTemp;
                        String archAttr;
                        String osAttr;
                        boolean includeBlock;
                        String resBlock;
                        int endRes;
                        int startRes;
                        String jarsConcat = "";
                        String os = System.getProperty("os.name").toLowerCase();
                        String arch = System.getProperty("os.arch").toLowerCase();
                        if (os.contains("win")) {
                            os = "windows";
                        } else if (os.contains("mac")) {
                            os = "mac os x";
                        } else if (os.contains("linux")) {
                            os = "linux";
                        } else if (os.contains("sunos")) {
                            os = "sunos";
                        }
                        String sHtmlTemp = sHtml;
                        while (sHtmlTemp.toLowerCase().contains("<resources")) {
                            startRes = sHtmlTemp.toLowerCase().indexOf("<resources");
                            endRes = sHtmlTemp.toLowerCase().indexOf("</resources>") + 11;
                            if (endRes < 11) break;
                            resBlock = sHtmlTemp.substring(startRes, endRes);
                            includeBlock = true;
                            if (resBlock.toLowerCase().contains("os=")) {
                                osAttr = resBlock.substring(resBlock.toLowerCase().indexOf("os=") + 3);
                                if (osAttr.startsWith("\"") || osAttr.startsWith("'")) {
                                    osAttr = osAttr.substring(1);
                                    osAttr = osAttr.substring(0, osAttr.indexOf("\""));
                                }
                                if (!osAttr.toLowerCase().contains(os)) {
                                    includeBlock = false;
                                }
                            }
                            if (resBlock.toLowerCase().contains("arch=")) {
                                archAttr = resBlock.substring(resBlock.toLowerCase().indexOf("arch=") + 5);
                                if (archAttr.startsWith("\"") || archAttr.startsWith("'")) {
                                    archAttr = archAttr.substring(1);
                                    archAttr = archAttr.substring(0, archAttr.indexOf("\""));
                                }
                                if (!archAttr.toLowerCase().contains(arch)) {
                                    includeBlock = false;
                                }
                            }
                            if (includeBlock) {
                                sBlockTemp = resBlock;
                                while (sBlockTemp.toLowerCase().contains("<jar")) {
                                    int startJar = sBlockTemp.toLowerCase().indexOf("<jar");
                                    String jarTag = sBlockTemp.substring(startJar);
                                    jarTag = jarTag.substring(0, jarTag.indexOf(">") + 1);
                                    String jarHref = "";
                                    if (jarTag.toLowerCase().contains("href=")) {
                                        jarHref = jarTag.substring(jarTag.toLowerCase().indexOf("href=") + 5);
                                        if (jarHref.startsWith("\"") || jarHref.startsWith("'")) {
                                            jarHref = jarHref.substring(1);
                                            jarHref = jarHref.substring(0, jarHref.indexOf("\""));
                                        } else if (jarHref.contains(" ")) {
                                            jarHref = jarHref.substring(0, jarHref.indexOf(" "));
                                        }
                                        jarsConcat = jarsConcat.equals("") ? jarHref : jarsConcat + "," + jarHref;
                                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] JAR agregado: " + jarHref);
                                    }
                                    sBlockTemp = sBlockTemp.substring(startJar + jarTag.length());
                                }
                            }
                            sHtmlTemp = sHtmlTemp.substring(endRes);
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] JAR concat:" + jarsConcat);
                        if (sHtml.toLowerCase().contains("<extension")) {
                            sHtmlTemp = sHtml;
                            if (os.contains("win")) {
                                os = "windows";
                            } else if (os.contains("mac")) {
                                os = "mac os x";
                            } else if (os.contains("linux")) {
                                os = "linux";
                            } else if (os.contains("sunos")) {
                                os = "sunos";
                            }
                            while (sHtmlTemp.toLowerCase().contains("<resources")) {
                                startRes = sHtmlTemp.toLowerCase().indexOf("<resources");
                                endRes = sHtmlTemp.toLowerCase().indexOf("</resources>") + 11;
                                if (endRes < 11) break;
                                resBlock = sHtmlTemp.substring(startRes, endRes);
                                includeBlock = true;
                                if (resBlock.toLowerCase().contains("os=")) {
                                    osAttr = resBlock.substring(resBlock.toLowerCase().indexOf("os=") + 3);
                                    if (osAttr.startsWith("\"") || osAttr.startsWith("'")) {
                                        osAttr = osAttr.substring(1);
                                        osAttr = osAttr.substring(0, osAttr.indexOf("\""));
                                    }
                                    if (!osAttr.toLowerCase().contains(os)) {
                                        includeBlock = false;
                                    }
                                }
                                if (resBlock.toLowerCase().contains("arch=")) {
                                    archAttr = resBlock.substring(resBlock.toLowerCase().indexOf("arch=") + 5);
                                    if (archAttr.startsWith("\"") || archAttr.startsWith("'")) {
                                        archAttr = archAttr.substring(1);
                                        archAttr = archAttr.substring(0, archAttr.indexOf("\""));
                                    }
                                    if (!archAttr.toLowerCase().contains(arch)) {
                                        includeBlock = false;
                                    }
                                }
                                if (includeBlock && resBlock.toLowerCase().contains("<extension")) {
                                    sBlockTemp = resBlock;
                                    while (sBlockTemp.toLowerCase().contains("<extension")) {
                                        int startExt = sBlockTemp.toLowerCase().indexOf("<extension");
                                        String extTag = sBlockTemp.substring(startExt);
                                        extTag = extTag.substring(0, extTag.indexOf(">") + 1);
                                        String extHref = "";
                                        if (extTag.toLowerCase().contains("href=")) {
                                            extHref = extTag.substring(extTag.toLowerCase().indexOf("href=") + 5);
                                            if (extHref.startsWith("\"") || extHref.startsWith("'")) {
                                                extHref = extHref.substring(1);
                                                extHref = extHref.substring(0, extHref.indexOf("\""));
                                            } else if (extHref.contains(" ")) {
                                                extHref = extHref.substring(0, extHref.indexOf(" "));
                                            }
                                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Extension JNLP v\u00e1lido para el sistema: " + extHref);
                                            try {
                                                String childJnlp;
                                                int inputLine;
                                                URL baseUrl = new URL(arg);
                                                String extUrlStr = extHref;
                                                if (!extHref.toLowerCase().startsWith("http")) {
                                                    extUrlStr = baseUrl.getProtocol() + "://" + baseUrl.getHost() + (baseUrl.getPort() > 0 ? ":" + baseUrl.getPort() : "") + (extHref.startsWith("/") ? extHref : "/" + extHref);
                                                }
                                                URL extUrl = new URL(extUrlStr);
                                                HttpURLConnection conn = (HttpURLConnection)extUrl.openConnection();
                                                conn.setInstanceFollowRedirects(true);
                                                conn.setAllowUserInteraction(true);
                                                conn.setRequestProperty("User-Agent", "Mozilla/5.0");
                                                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                                StringBuilder jnlpContent = new StringBuilder();
                                                while ((inputLine = in.read()) != -1) {
                                                    jnlpContent.append((char)inputLine);
                                                }
                                                in.close();
                                                conn.disconnect();
                                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] JNLP hijo: " + jnlpContent.toString());
                                                String sTemp = childJnlp = jnlpContent.toString().replaceAll("<!--.*?-->", "");
                                                while (sTemp.toLowerCase().contains("<jar")) {
                                                    int startJar = sTemp.toLowerCase().indexOf("<jar");
                                                    String jarTag = sTemp.substring(startJar);
                                                    jarTag = jarTag.substring(0, jarTag.indexOf(">") + 1);
                                                    String jarHref = "";
                                                    if (jarTag.toLowerCase().contains("href=")) {
                                                        jarHref = jarTag.substring(jarTag.toLowerCase().indexOf("href=") + 5);
                                                        if (jarHref.startsWith("\"") || jarHref.startsWith("'")) {
                                                            jarHref = jarHref.substring(1);
                                                            jarHref = jarHref.substring(0, jarHref.indexOf("\""));
                                                        } else if (jarHref.contains(" ")) {
                                                            jarHref = jarHref.substring(0, jarHref.indexOf(" "));
                                                        }
                                                        if (!jarsConcat.contains(jarHref)) {
                                                            jarsConcat = jarsConcat + "," + jarHref;
                                                        }
                                                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] JAR hijo agregado: " + jarHref);
                                                    }
                                                    sTemp = sTemp.substring(startJar + jarTag.length());
                                                }
                                            }
                                            catch (Exception e) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[ERROR] No se pudo leer JNLP hijo: " + e.getMessage());
                                            }
                                        }
                                        sBlockTemp = sBlockTemp.substring(startExt + extTag.length());
                                    }
                                }
                                sHtmlTemp = sHtmlTemp.substring(endRes);
                            }
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] JAR concat final: " + jarsConcat);
                        }
                        if (sHtml.toLowerCase().contains("<applet-desc")) {
                            startObject = sHtml.toLowerCase().indexOf("<applet-desc");
                            String sObject2 = "<applet " + sHtml.substring(startObject + 12, sHtml.length());
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "sObject: " + sObject2);
                            sHtml = sObject2 = sObject2.replace(">", " archive=\"" + jarsConcat + "\">");
                            int endObject2 = sHtml.toLowerCase().indexOf("</applet-desc");
                            String sEndObject2 = sHtml.substring(0, endObject2);
                            sHtml = sEndObject2 = sEndObject2 + "</applet>";
                        }
                        if (sHtml.toLowerCase().contains("<application-desc")) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "<application-desc: encontrado: " + sHtml);
                            startObject = sHtml.toLowerCase().indexOf("<application-desc");
                            String sObject3 = sHtml.substring(0, startObject);
                            sHtml = sObject3 = sObject3 + "<applet codebase=\"" + sCodeBase + "\" archive=\"" + jarsConcat + "\" " + sHtml.substring(startObject + 17, sHtml.length());
                            if (sHtml.contains("</application-desc")) {
                                int endObject3 = sHtml.toLowerCase().indexOf("</application-desc");
                                String sEndObject3 = sHtml.substring(0, endObject3);
                                sHtml = sEndObject3 = sEndObject3 + "</applet>";
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "<application-desc:" + sHtml);
                            } else {
                                sHtml = sHtml + "</applet>";
                            }
                        }
                        if (sHtml.toLowerCase().contains("main-class=")) {
                            startObject = sHtml.toLowerCase().indexOf("main-class=");
                            String sObject4 = sHtml.substring(0, startObject);
                            sHtml = sObject4 = sObject4 + "code=" + sHtml.substring(startObject + 11, sHtml.length());
                        }
                    }
                    if (sHtml.toLowerCase().contains("<object")) {
                        int startObject = sHtml.toLowerCase().indexOf("<object");
                        sObject = sHtml.substring(0, startObject);
                        sHtml = sObject = sObject + "<applet" + sHtml.substring(startObject + 7, sHtml.length());
                        endObject = sHtml.toLowerCase().indexOf("</object");
                        sEndObject = sHtml.substring(0, endObject);
                        sHtml = sEndObject = sEndObject + "</applet" + sHtml.substring(endObject + 8, sHtml.length());
                        sHtml = sHtml.substring(sHtml.toLowerCase().indexOf("<applet"), sHtml.length());
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Object encontrado: " + sHtml);
                    }
                    if (sHtml.toLowerCase().contains("<embed")) {
                        int startObject = sHtml.toLowerCase().indexOf("<embed");
                        sObject = sHtml.substring(0, startObject);
                        sHtml = sObject = sObject + "<applet" + sHtml.substring(startObject + 6, sHtml.length());
                        endObject = sHtml.toLowerCase().indexOf("</embed");
                        sEndObject = sHtml.substring(0, endObject);
                        sHtml = sEndObject = sEndObject + "</applet" + sHtml.substring(endObject + 7, sHtml.length());
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Embed encontrado...");
                    }
                    if (sHtml.toLowerCase().contains("<cheerpj-applet")) {
                        int startObject = sHtml.toLowerCase().indexOf("<cheerpj-applet");
                        sObject = sHtml.substring(0, startObject);
                        sHtml = sObject = sObject + "<applet" + sHtml.substring(startObject + 15, sHtml.length());
                        endObject = sHtml.toLowerCase().indexOf("</cheerpj-applet");
                        sEndObject = sHtml.substring(0, endObject);
                        sHtml = sEndObject = sEndObject + "</applet" + sHtml.substring(endObject + 16, sHtml.length());
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "cheerpj-applet encontrado...");
                    }
                    String sCode = "";
                    if (sHtml.toLowerCase().contains("<applet ")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Applet encontrado...");
                        sHtml = sHtml.substring(sHtml.toLowerCase().indexOf("<applet"), sHtml.length());
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Applet filtrado:" + sHtml);
                        if (sHtml.toLowerCase().contains("</applet>")) {
                            sHtml = sHtml.substring(0, sHtml.toLowerCase().indexOf("</applet>") + 9);
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Applet cerrado primero:" + sHtml);
                            if (sHtml.toLowerCase().contains("code=")) {
                                sCode = sHtml.substring(sHtml.toLowerCase().indexOf("code=") + 5, sHtml.length());
                                if ((sCode = sCode.substring(0, sCode.toLowerCase().indexOf(" "))).startsWith("\"")) {
                                    sCode = sCode.substring(sCode.indexOf("\"") + 1, sCode.length());
                                    sCode = sCode.substring(0, sCode.toLowerCase().indexOf("\""));
                                } else if (sCode.startsWith("'")) {
                                    sCode = sCode.substring(sCode.indexOf("'") + 1, sCode.length());
                                    sCode = sCode.substring(0, sCode.toLowerCase().indexOf("'"));
                                }
                                if (!sCode.toLowerCase().endsWith(".class")) {
                                    sCode = sCode + ".class";
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Code: " + sCode);
                            }
                            String sName = "";
                            if (sHtml.toLowerCase().contains("name=") && sHtml.toLowerCase().indexOf("<applet") < sHtml.toLowerCase().indexOf("name=") && sHtml.toLowerCase().indexOf("name=") < sHtml.toLowerCase().indexOf(">")) {
                                sName = sHtml.substring(sHtml.toLowerCase().indexOf("name=") + 5, sHtml.length());
                                if (sName.startsWith("\"")) {
                                    sName = sName.substring(sName.indexOf("\"") + 1, sName.length());
                                    sName = sName.substring(0, sName.toLowerCase().indexOf("\""));
                                } else if (sName.startsWith("'")) {
                                    sName = sName.substring(sName.indexOf("'") + 1, sName.length());
                                    sName = sName.substring(0, sName.toLowerCase().indexOf("'"));
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Name: " + sName);
                            }
                            if (sHtml.toLowerCase().contains("codebase=") && sHtml.toLowerCase().indexOf("codebase=") < sHtml.toLowerCase().indexOf(">")) {
                                sCodeBase = sHtml.substring(sHtml.toLowerCase().indexOf("codebase=") + 9, sHtml.length());
                                if (sCodeBase.startsWith("\"")) {
                                    sCodeBase = sCodeBase.substring(sCodeBase.indexOf("\"") + 1, sCodeBase.length());
                                    sCodeBase = sCodeBase.substring(0, sCodeBase.toLowerCase().indexOf("\""));
                                } else if (sCodeBase.startsWith("'")) {
                                    sCodeBase = sCodeBase.substring(sCodeBase.indexOf("'") + 1, sCodeBase.length());
                                    sCodeBase = sCodeBase.substring(0, sCodeBase.toLowerCase().indexOf("'"));
                                } else if (sCodeBase.contains(" ")) {
                                    sCodeBase = sCodeBase.substring(0, sCodeBase.indexOf(" "));
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "CodeBase: " + sCodeBase);
                            }
                            String width = "";
                            if (sHtml.toLowerCase().contains("width=") && sHtml.toLowerCase().indexOf("width=") < sHtml.toLowerCase().indexOf(">")) {
                                width = sHtml.substring(sHtml.toLowerCase().indexOf("width=") + 6, sHtml.length());
                                if (width.startsWith("\"")) {
                                    width = width.substring(width.indexOf("\"") + 1, width.length());
                                    width = width.substring(0, width.toLowerCase().indexOf("\""));
                                } else if (width.startsWith("'")) {
                                    width = width.substring(width.indexOf("'") + 1, width.length());
                                    width = width.substring(0, width.toLowerCase().indexOf("'"));
                                } else if (width.contains(" ")) {
                                    width = width.substring(0, width.indexOf(" "));
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "width: " + width);
                            }
                            String height = "";
                            if (sHtml.toLowerCase().contains("height=") && sHtml.toLowerCase().indexOf("height=") < sHtml.toLowerCase().indexOf(">")) {
                                height = sHtml.substring(sHtml.toLowerCase().indexOf("height=") + 7, sHtml.length());
                                if (height.startsWith("\"")) {
                                    height = height.substring(height.indexOf("\"") + 1, height.length());
                                    height = height.substring(0, height.toLowerCase().indexOf("\""));
                                } else if (height.startsWith("'")) {
                                    height = height.substring(height.indexOf("'") + 1, height.length());
                                    height = height.substring(0, height.toLowerCase().indexOf("'"));
                                } else if (height.contains(" ")) {
                                    height = height.substring(0, height.indexOf(" "));
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "height: " + height);
                            }
                            String sArchive = "";
                            if (sHtml.toLowerCase().contains("archive=")) {
                                sArchive = sHtml.substring(sHtml.toLowerCase().indexOf("archive=") + 8, sHtml.length());
                                if (sArchive.startsWith("\"")) {
                                    sArchive = sArchive.substring(1, sArchive.length());
                                    sArchive = sArchive.substring(0, sArchive.toLowerCase().indexOf("\""));
                                } else if (sArchive.startsWith("'")) {
                                    sArchive = sArchive.substring(sArchive.indexOf("'") + 1, sArchive.length());
                                    sArchive = sArchive.substring(0, sArchive.toLowerCase().indexOf("'"));
                                } else if (sArchive.contains(" ")) {
                                    sArchive = sArchive.substring(0, sArchive.indexOf(" "));
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Archive: " + sArchive);
                                if (sArchive.contains(",")) {
                                    sArchive = sArchive.replaceAll(",", " ");
                                }
                            }
                            if (sHtml.toLowerCase().contains("<param")) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Contiene param:" + sHtml);
                                String paramBase = sHtml.substring(sHtml.toLowerCase().indexOf("<param"), sHtml.length());
                                while (paramBase.toLowerCase().contains("<param")) {
                                    String param1 = paramBase.substring(paramBase.toLowerCase().indexOf("<param"), paramBase.length());
                                    param1 = param1.substring(0, param1.indexOf(">"));
                                    String name = "";
                                    if (param1.toLowerCase().contains("name=")) {
                                        name = param1.substring(param1.toLowerCase().indexOf("name=") + 5, param1.length());
                                    }
                                    if (name.toLowerCase().contains(" ")) {
                                        name = name.substring(0, name.toLowerCase().indexOf(" "));
                                    }
                                    if (name.startsWith("\"")) {
                                        name = name.substring(name.indexOf("\"") + 1, name.length());
                                        name = name.substring(0, name.toLowerCase().indexOf("\""));
                                    } else if (name.startsWith("'")) {
                                        name = name.substring(name.indexOf("'") + 1, name.length());
                                        name = name.substring(0, name.toLowerCase().indexOf("'"));
                                    }
                                    String value = "";
                                    if (param1.toLowerCase().contains("value=")) {
                                        value = param1.substring(param1.toLowerCase().indexOf("value=") + 6, param1.length());
                                    }
                                    if (value.startsWith("\"")) {
                                        value = value.substring(value.indexOf("\"") + 1, value.length());
                                        value = value.substring(0, value.toLowerCase().indexOf("\""));
                                    } else if (value.startsWith("'")) {
                                        value = value.substring(value.indexOf("'") + 1, value.length());
                                        value = value.substring(0, value.toLowerCase().indexOf("'"));
                                    } else if (value.contains(" ")) {
                                        value = value.substring(0, value.toLowerCase().indexOf(" "));
                                    }
                                    if (name.toLowerCase().equals("code")) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "encontre code");
                                        sCode = value;
                                    }
                                    if (name.toLowerCase().equals("archive")) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "encontre archive");
                                        sArchive = value;
                                    }
                                    if (name.toLowerCase().equals("codebase")) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "encontre codebase");
                                        sCodeBase = value;
                                    }
                                    System.out.print("Param name: " + name);
                                    this.params.put(name, value);
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ", value: " + value);
                                    paramBase = paramBase.substring(paramBase.indexOf(">") + 1, paramBase.length());
                                }
                            }
                            String sUrl = arg;
                            this.startApp(sUrl, sName, sCodeBase, sArchive, sCode, this.params);
                        }
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "No applet detectected!!");
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Exception: " + ex.toString());
                }
            }
        }
    }

    public void startApp(String sURL, String sName, String sCodeBase, String sArchive, String sCode, Map<String, String> parameters) {
        block36: {
            try {
                String codeBaseUrl;
                if (sCode.contains("/")) {
                    sCode = sCode.replaceAll("/", ".");
                }
                long inicio = System.currentTimeMillis();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Connecting with: " + sURL);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "CodeBase: " + sCodeBase);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Files: " + sArchive);
                String[] archives = sArchive != null && !sArchive.trim().isEmpty() ? sArchive.split(" ") : new String[]{};
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Total files: " + archives.length);
                int iArchives = archives.length;
                ClassLoader finalClassLoader = this.getClass().getClassLoader();
                boolean enableSandbox = false;
                ButtonGroup group = new ButtonGroup();
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                panel.add(new JLabel("<html>Please select how you want to run this Java applet.<br><br><b>Note:</b> If you click Cancel, the applet will not be executed.</html>"));
                JRadioButton sandboxOption = new JRadioButton("<html><b>Sandbox Mode (Recommended)</b><br>Runs the applet in a restricted environment.<br>Prevents access to files, devices, or system APIs.<br>Ideal for safety, especially when running untrusted applets.</html>");
                boolean verifyJar = false;
                JRadioButton fullAccessIfJarSignedOption = new JRadioButton("<html><b>Full Access Mode (If Jars are Signed)</b><br>Allows the applet to access local files, hardware, or external systems.<br>Use only if you trust in a signed applet and it requires full privileges.</html>");
                if (SyncJars.isSecurityManagerSupported()) {
                    group.add(sandboxOption);
                    panel.add(Box.createVerticalStrut(10));
                    panel.add(sandboxOption);
                    sandboxOption.setSelected(true);
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Java <=21 detected. Classic Sandbox enabled.");
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Java 22+ detected. Classic Sandbox disabled.");
                    fullAccessIfJarSignedOption.setSelected(true);
                }
                JRadioButton fullAccessOption = new JRadioButton("<html><b>Full Access Mode</b><br>Allows the applet to access local files, hardware, or external systems.<br>Use only if you trust the applet and it requires full privileges.</html>");
                if (iArchives > 0) {
                    group.add(fullAccessIfJarSignedOption);
                    panel.add(Box.createVerticalStrut(10));
                    panel.add(fullAccessIfJarSignedOption);
                } else if (!SyncJars.isSecurityManagerSupported()) {
                    fullAccessOption.setSelected(true);
                }
                group.add(fullAccessOption);
                panel.add(Box.createVerticalStrut(10));
                panel.add(fullAccessOption);
                int result = JOptionPane.showConfirmDialog(null, panel, "Applet Execution Mode", 2, 3);
                if (result == 0) {
                    enableSandbox = sandboxOption.isSelected();
                    verifyJar = fullAccessIfJarSignedOption.isSelected();
                } else {
                    JOptionPane.showMessageDialog(null, "Applet execution has been cancelled by the user.", "Cancelled", 1);
                    System.exit(0);
                }
                if (this.jnlp && !sURL.toLowerCase().startsWith("http") && sCodeBase.toLowerCase().startsWith("http")) {
                    sURL = sCodeBase;
                }
                int validatedJars = 0;
                URL[] urlList = new URL[archives.length];
                for (int i = 0; i < iArchives; ++i) {
                    String string = archives[i];
                    String fileUrl = this.generateDownloadURL(sURL, sCodeBase, string);
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Procesando archivo: " + fileUrl);
                    if (!this.urlExists(fileUrl)) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "No existe archivo: " + fileUrl);
                    }
                    URL archiveUrl = new URL(fileUrl);
                    if (string.toLowerCase().endsWith(".zip")) {
                        finalClassLoader = new MemoryClassLoader(archiveUrl, finalClassLoader);
                        continue;
                    }
                    if (string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith("-jar")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "archive en classloader: " + string);
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "archiveUrl en classloader: " + archiveUrl);
                        urlList[i] = archiveUrl;
                        if (!verifyJar || this.isJarSigned(archiveUrl) == 0) continue;
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "El JAR NO est\u00e1 firmado: " + string);
                        ++validatedJars;
                        continue;
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, " Archivo no soportado: " + string);
                }
                if (verifyJar && iArchives != validatedJars) {
                    int opcion = JOptionPane.showConfirmDialog(null, "Jar signature is insecure, run the Applet?", "Security problem", 0);
                    if (opcion == 0) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Opcion:" + opcion);
                    } else {
                        throw new SecurityException("Bloqueo de ejecuci\u00f3n por JAR no firmado: ");
                    }
                }
                finalClassLoader = new URLClassLoader(urlList, finalClassLoader);
                if (archives.length == 0 && (codeBaseUrl = this.generateDownloadURL(sURL, sCodeBase, "")) != null) {
                    final URL uRL = new URL(codeBaseUrl);
                    finalClassLoader = new URLClassLoader(new URL[]{uRL}, finalClassLoader){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        protected Class<?> findClass(String name) throws ClassNotFoundException {
                            try {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "name: " + name);
                                String classPath = name.replace('.', '/') + ".class";
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "codeBaseDir: " + uRL);
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "classPath: " + classPath);
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "codeBaseDir + classPath: " + uRL + classPath);
                                URL classUrl = new URL(uRL + classPath);
                                try (InputStream input = classUrl.openStream();){
                                    int bytesRead;
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[1024];
                                    while ((bytesRead = input.read(buffer)) != -1) {
                                        baos.write(buffer, 0, bytesRead);
                                    }
                                    byte[] classBytes = baos.toByteArray();
                                    String version = SyncJars.detectJavaVersion(classBytes);
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Version of compilation:" + version);
                                    Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                                    return clazz;
                                }
                            }
                            catch (IOException e) {
                                return super.findClass(name);
                            }
                        }
                    };
                }
                URLClassLoader urlClassLoader = (URLClassLoader)finalClassLoader;
                for (URL url : urlClassLoader.getURLs()) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "JAR en ClassLoader: " + this.urlExists(url.toString()) + ", " + url);
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Paso classloader");
                Thread.currentThread().setContextClassLoader(urlClassLoader);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "sCode: " + sCode);
                if (sCode.endsWith(".class")) {
                    sCode = sCode.substring(0, sCode.length() - 6);
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "sCode  paso 2: " + sCode);
                if (enableSandbox) {
                    try {
                        Policy.setPolicy(new SandboxPolicy(sURL));
                        System.setSecurityManager(new SecurityManager());
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Sandbox enabled for code: " + sCode);
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Sandbox enabled for URL: " + sURL);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[ADVERTENCIA] No se pudo activar el sandbox: " + unsupportedOperationException.getMessage());
                    }
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] urlClassLoader sCode: " + sCode);
                Class<?> clazz = urlClassLoader.loadClass(sCode);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Clase cargada: " + clazz.getName());
                sName = enableSandbox ? "Security: Limited in SandBox. Working on: " + sURL + ". " + sName : "Security: All permisions. Working on: " + sURL + ". " + sName;
                if (JApplet.class.isAssignableFrom(clazz)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, " La clase cargada es un JApplet.");
                    for (Map.Entry<String, String> entry : parameters.entrySet()) {
                        try {
                            Field field = this.getClass().getDeclaredField(entry.getKey());
                            field.setAccessible(true);
                            if (field.getType() == Integer.TYPE) {
                                field.set(this, Integer.parseInt(entry.getValue()));
                                continue;
                            }
                            field.set(this, entry.getValue());
                        }
                        catch (Exception ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "No se pudo asignar el campo: " + entry.getKey());
                        }
                    }
                    JApplet applet = (JApplet)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.configurarAppletGenerico(applet, sName, sURL, inicio);
                    break block36;
                }
                if (Applet.class.isAssignableFrom(clazz)) {
                    Applet applet = (Applet)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.configurarAppletGenerico(applet, sName, sURL, inicio);
                    break block36;
                }
                if (JFrame.class.isAssignableFrom(clazz)) {
                    JFrame applet = (JFrame)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break block36;
                }
                URLClassLoader fxCl = urlClassLoader;
                Class<?> appClass = SyncJars.tryLoad("javafx.application.Application", fxCl);
                Class<?> jfxPanelClass = SyncJars.tryLoad("javafx.embed.swing.JFXPanel", fxCl);
                Class<?> platformClass = SyncJars.tryLoad("javafx.application.Platform", fxCl);
                Class<?> stageClass = SyncJars.tryLoad("javafx.stage.Stage", fxCl);
                Class<?> sceneClass = SyncJars.tryLoad("javafx.scene.Scene", fxCl);
                Class<?> parentClass = SyncJars.tryLoad("javafx.scene.Parent", fxCl);
                Class<?> stackPaneClass = SyncJars.tryLoad("javafx.scene.layout.StackPane", fxCl);
                if (appClass != null && jfxPanelClass != null && appClass.isAssignableFrom(clazz)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "JavaFX Application detected (reflection).");
                    JInternalFrame ifx = new JInternalFrame(sName, true, true, true, true);
                    ifx.getContentPane().setLayout(new BorderLayout());
                    Object fxPanel = SyncJars.newInstance(jfxPanelClass, null, null);
                    ifx.getContentPane().add((Component)fxPanel, "Center");
                    ifx.setSize(800, 600);
                    ifx.setVisible(true);
                    this.jd.add(ifx);
                    ifx.toFront();
                    Thread.currentThread().setContextClassLoader(fxCl);
                    Object app = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    try {
                        SyncJars.invoke(app, "init", null, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        SyncJars.invoke(platformClass, "setImplicitExit", new Class[]{Boolean.TYPE}, new Object[]{Boolean.FALSE});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    SyncJars.invoke(platformClass, "runLater", new Class[]{Runnable.class}, new Object[]{() -> {
                        try {
                            Thread.currentThread().setContextClassLoader(fxCl);
                            Object stage = SyncJars.newInstance(stageClass, null, null);
                            SyncJars.invoke(app, "start", new Class[]{stageClass}, new Object[]{stage});
                            Object scene = SyncJars.invoke(stage, "getScene", null, null);
                            if (scene == null && sceneClass != null && stackPaneClass != null) {
                                Object root = SyncJars.newInstance(stackPaneClass, null, null);
                                scene = SyncJars.newInstance(sceneClass, new Class[]{parentClass}, new Object[]{root});
                            }
                            if (scene != null) {
                                SyncJars.invoke(fxPanel, "setScene", new Class[]{sceneClass}, new Object[]{scene});
                            }
                            try {
                                SyncJars.invoke(stage, "hide", null, null);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ifx.addInternalFrameListener(new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosed(InternalFrameEvent e) {
                                    try {
                                        SyncJars.invoke(platformClass, "runLater", new Class[]{Runnable.class}, new Object[]{() -> {
                                            try {
                                                SyncJars.invoke(app, "stop", null, null);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            try {
                                                SyncJars.invoke(fxPanel, "setScene", new Class[]{sceneClass}, new Object[]{null});
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }});
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            });
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "JavaFX Application embedded into JInternalFrame (reflection).");
                        }
                        catch (Throwable ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error starting JavaFX Application via reflection", ex);
                        }
                    }});
                    break block36;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "La clase cargada no es un Applet, JApplet, JFrame: " + clazz.getTypeName());
                Method mainMethod = clazz.getMethod("main", String[].class);
                SwingUtilities.invokeLater(() -> {
                    try {
                        if (mainMethod != null) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Ejecutando main() de la clase: " + appletClass.getName());
                            String[] args = new String[]{};
                            mainMethod.invoke(null, new Object[]{args});
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "ERROR ejecutando main(): " + e.getMessage());
                        e.printStackTrace();
                    }
                });
                throw new ClassCastException(" La clase cargada no es un Applet ni un JApplet.");
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, " Error al iniciar el applet: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public String generateDownloadURL(String sURL, String sCodeBase, String file) {
        try {
            String finalBaseURLString;
            int lastSlashIndex;
            if (file.toLowerCase().startsWith("http://") || file.toLowerCase().startsWith("https://") || file.toLowerCase().startsWith("file://")) {
                URL finalURL = new URL(file);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Generada URL final: " + finalURL);
                return finalURL.toString();
            }
            if (sURL.endsWith("/")) {
                sURL = sURL.substring(0, sURL.length() - 1);
            }
            URL baseURL = new URL(sURL);
            if (file.startsWith("/")) {
                return new URL(baseURL.getProtocol() + "://" + baseURL.getHost() + (baseURL.getPort() != -1 ? ":" + baseURL.getPort() : "") + file).toString();
            }
            String basePath = baseURL.getPath();
            if (basePath.contains(".") && (lastSlashIndex = basePath.lastIndexOf(47)) != -1) {
                basePath = basePath.substring(0, lastSlashIndex + 1);
            }
            if (sCodeBase != null && !sCodeBase.isEmpty()) {
                if (sCodeBase.startsWith("http://") || sCodeBase.startsWith("https://")) {
                    finalBaseURLString = sCodeBase;
                } else if (sCodeBase.startsWith("/")) {
                    finalBaseURLString = baseURL.getProtocol() + "://" + baseURL.getHost() + (baseURL.getPort() != -1 ? ":" + baseURL.getPort() : "") + sCodeBase;
                } else {
                    if (basePath.endsWith("/") && sCodeBase.startsWith("/")) {
                        sCodeBase = sCodeBase.substring(1);
                    }
                    finalBaseURLString = baseURL.getProtocol() + "://" + baseURL.getHost() + (baseURL.getPort() != -1 ? ":" + baseURL.getPort() : "") + basePath + sCodeBase;
                }
            } else {
                finalBaseURLString = baseURL.getProtocol() + "://" + baseURL.getHost() + (baseURL.getPort() != -1 ? ":" + baseURL.getPort() : "") + basePath;
            }
            if (!finalBaseURLString.endsWith("/")) {
                finalBaseURLString = finalBaseURLString + "/";
            }
            URL finalURL = new URL(finalBaseURLString + file);
            String urlStr = finalURL.toString();
            if (jsessionid != null && !urlStr.contains("jsessionid=")) {
                int qIdx = urlStr.indexOf("?");
                urlStr = qIdx >= 0 ? urlStr.substring(0, qIdx) + jsessionid + urlStr.substring(qIdx) : urlStr + jsessionid;
            }
            return urlStr;
        }
        catch (MalformedURLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error generando la URL de descarga para el archivo: " + file);
            e.printStackTrace();
            return null;
        }
    }

    private void configurarAppletGenerico(Applet applet, String sName, String sURL, long inicio) {
        try {
            SwingUtilities.invokeLater(() -> {
                AppletStub stub = SyncJars.crearAppletStub(sURL, this.params);
                applet.setStub(stub);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Locale: " + Locale.getDefault());
                String os = System.getProperty("os.name");
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "os name: " + os);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Applet size: " + applet.getSize());
                if (!this.javaHome.toLowerCase().contains("coobbi")) {
                    JInternalFrame jf = new JInternalFrame(sName);
                    jf.setName(sURL);
                    jf.setMaximizable(true);
                    jf.setResizable(true);
                    jf.add(applet);
                    jf.setSize(800, 800);
                    this.jd.add(jf);
                    if (applet instanceof ComponentListener) {
                        try {
                            applet.addComponentListener((ComponentListener)((Object)applet));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    SwingUtilities.invokeLater(() -> {
                        try {
                            applet.init();
                            jf.setMaximum(true);
                            jf.setSelected(true);
                        }
                        catch (Throwable t) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "init() failed", t);
                        }
                        jf.setVisible(true);
                        applet.dispatchEvent(new ComponentEvent(applet, 102));
                        try {
                            applet.start();
                        }
                        catch (Throwable t) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "start() failed", t);
                        }
                    });
                } else {
                    JFrame jf = new JFrame(sName);
                    jf.setName(sURL);
                    jf.setResizable(true);
                    jf.add(applet);
                    jf.setSize(800, 800);
                    jf.setDefaultCloseOperation(3);
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    Rectangle usableBounds = ge.getMaximumWindowBounds();
                    jf.setSize(usableBounds.width, usableBounds.height);
                    SwingUtilities.invokeLater(() -> {
                        applet.init();
                        applet.start();
                        applet.validate();
                    });
                    jf.setVisible(true);
                }
                applet.requestFocusInWindow();
                ventana.setLayout(new BorderLayout());
            });
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, (applet instanceof JApplet ? "JApplet" : "Applet") + " iniciado, tiempo total: " + (System.currentTimeMillis() - inicio) + " ms");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error al configurar el " + (applet instanceof JApplet ? "JApplet" : "Applet") + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static AppletStub crearAppletStub(final String sURL, final Map params) {
        return new AppletStub(){

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public URL getDocumentBase() {
                try {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "getDocumentBase: starting");
                    URL documentBase = new URL(sURL);
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "getDocumentBase: " + documentBase);
                    return documentBase;
                }
                catch (MalformedURLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Invalid URL for DocumentBase: " + sURL);
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public URL getCodeBase() {
                try {
                    return new URL(sURL);
                }
                catch (MalformedURLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Invalid URL for CodeBase: " + sURL);
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public String getParameter(String name) {
                String result = "" + params.get(name);
                if ("width".equalsIgnoreCase(name) && result.equals("null")) {
                    return "800";
                }
                if ("height".equalsIgnoreCase(name) && result.equals("null")) {
                    return "600";
                }
                URL url = this.getCodeBase();
                if ("serverPort".equalsIgnoreCase(name) && result.equals("null")) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "serverPort getCodeBase port: " + url.getPort());
                    if (url.getProtocol().equals("http") && url.getPort() == -1) {
                        return "80";
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "serverPort getCodeBase es https: " + url.getPort());
                    if (url.getPort() == -1) {
                        return "443";
                    }
                    return "" + url.getPort();
                }
                if ("serverURL".equalsIgnoreCase(name)) {
                    if ((result = result.replaceAll("&#38;", "&").replaceAll("&amp;", "&")).startsWith("/")) {
                        result = url.getProtocol() + "://" + url.getHost() + result;
                    }
                    return result;
                }
                if ("proxyPort".equalsIgnoreCase(name) && result.equals("null")) {
                    return "-1";
                }
                if ("imageBase".equalsIgnoreCase(name) && result.equals("codebase")) {
                    return url.toString();
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Searching parameter: " + name + ", value: " + result);
                return result;
            }

            @Override
            public AppletContext getAppletContext() {
                return new AppletContext(){

                    @Override
                    public AudioClip getAudioClip(URL url) {
                        try {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Llamado getAudioClip: " + url);
                            return Applet.newAudioClip(url);
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error al cargar el AudioClip desde: " + url);
                            e.printStackTrace();
                            return null;
                        }
                    }

                    private Image getBrokenImage(int width, int height) {
                        BufferedImage img = new BufferedImage(width, height, 2);
                        Graphics2D g2 = img.createGraphics();
                        g2.setColor(Color.LIGHT_GRAY);
                        g2.fillRect(0, 0, width, height);
                        g2.setColor(Color.RED);
                        g2.setStroke(new BasicStroke(2.0f));
                        g2.drawLine(0, 0, width, height);
                        g2.drawLine(width, 0, 0, height);
                        g2.setColor(Color.BLACK);
                        g2.setFont(new Font("SansSerif", 0, 10));
                        g2.drawString("404", 5, height - 5);
                        g2.dispose();
                        return img;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Image getImage(URL url) {
                        try {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "getImage call: " + url);
                            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "getImage JAR protocol detected: " + url);
                                String urlStr = url.toString();
                                int sepIndex = urlStr.indexOf("!/");
                                if (sepIndex != -1) {
                                    String jarPath = urlStr.substring(4, sepIndex);
                                    String entryPath = urlStr.substring(sepIndex + 2);
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] External JAR: " + jarPath);
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Internal resource: " + entryPath);
                                    try (JarInputStream jarStream = new JarInputStream(new URL(jarPath).openStream());){
                                        JarEntry entry;
                                        while ((entry = jarStream.getNextJarEntry()) != null) {
                                            int bytesRead;
                                            if (entry.isDirectory() || !entry.getName().equals(entryPath)) continue;
                                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Image found inside JAR: " + entryPath);
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[8192];
                                            while ((bytesRead = jarStream.read(buffer)) != -1) {
                                                baos.write(buffer, 0, bytesRead);
                                            }
                                            byte[] imageBytes = baos.toByteArray();
                                            Image image = Toolkit.getDefaultToolkit().createImage(imageBytes);
                                            MediaTracker tracker = new MediaTracker(new Panel());
                                            tracker.addImage(image, 0);
                                            tracker.waitForAll();
                                            if (tracker.isErrorAny()) {
                                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error loading image from JAR: " + entryPath);
                                                Image image2 = this.getBrokenImage(80, 80);
                                                return image2;
                                            }
                                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Image loaded from JAR with size: " + image.getWidth(null) + "x" + image.getHeight(null));
                                            Image image3 = image;
                                            return image3;
                                        }
                                    }
                                }
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[WARN] Image not found inside JAR.");
                                return this.getBrokenImage(80, 80);
                            }
                            Image image = Toolkit.getDefaultToolkit().createImage(url);
                            MediaTracker tracker = new MediaTracker(new Panel());
                            tracker.addImage(image, 0);
                            tracker.waitForAll();
                            if (tracker.isErrorAny()) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error loading image from: " + url);
                                return this.getBrokenImage(80, 80);
                            }
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "[INFO] Image loaded with size: " + image.getWidth(null) + "x" + image.getHeight(null));
                            return image;
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error retrieving image from: " + url);
                            e.printStackTrace();
                            return this.getBrokenImage(80, 80);
                        }
                    }

                    @Override
                    public Applet getApplet(String name) {
                        return null;
                    }

                    @Override
                    public Enumeration<Applet> getApplets() {
                        return Collections.emptyEnumeration();
                    }

                    @Override
                    public void showDocument(URL url) {
                        try {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Intentando mostrar documento: " + url);
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error al abrir URL: " + url);
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void showDocument(URL url, String target) {
                        try {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Intentando mostrar documento: " + url + " con target: " + target);
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error al abrir URL con target: " + url);
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void showStatus(String status) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Estado: " + status);
                    }

                    @Override
                    public void setStream(String key, InputStream stream) throws IOException {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Stream: " + key);
                    }

                    @Override
                    public InputStream getStream(String key) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Stream: " + key);
                        return null;
                    }

                    @Override
                    public Iterator<String> getStreamKeys() {
                        return Collections.emptyIterator();
                    }
                };
            }

            @Override
            public void appletResize(int width, int height) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Calling resize");
            }
        };
    }

    private static void redirectSystemOutToTextArea(final JTextArea textArea) {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) {
                textArea.append(String.valueOf((char)b));
                textArea.setCaretPosition(textArea.getDocument().getLength());
            }

            @Override
            public void write(byte[] b, int off, int len) {
                textArea.append(new String(b, off, len));
                textArea.setCaretPosition(textArea.getDocument().getLength());
            }
        };
        PrintStream printStream = new PrintStream(outputStream, true);
        System.setOut(printStream);
        System.setErr(printStream);
    }

    /*
     * Exception decompiling
     */
    public int isJarSigned(URL jarUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isSelfSigned(X509Certificate cert) throws GeneralSecurityException {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSecurityManagerSupported() {
        boolean result = false;
        String version = System.getProperty("java.version");
        int major = SyncJars.parseMajorJavaVersion(version);
        result = major >= 8 && major <= 21;
        return result;
    }

    private static int parseMajorJavaVersion(String version) {
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf("-"));
        }
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        return Integer.parseInt(version.split("\\.")[0]);
    }

    public boolean urlExists(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            return responseCode >= 200 && responseCode < 400;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String detectarUrlDesdeNombreJar() {
        try {
            String encoded;
            String[] partes;
            String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File jarFile = new File(path);
            String nombreJar = jarFile.getName();
            if (nombreJar.contains("-") && (nombreJar.toLowerCase().endsWith(".jar") || nombreJar.toLowerCase().endsWith("-jar")) && (partes = (encoded = nombreJar.substring(nombreJar.indexOf(45) + 1, nombreJar.length() - 4)).split("_", 4)).length >= 3) {
                String protocolo = partes[0];
                String host = partes[1];
                String puerto = partes[2];
                String pathUrl = partes.length > 3 ? partes[3].replace('_', '/') : "";
                String url = protocolo + "://" + host;
                if (!puerto.equals("80") && !puerto.equals("443")) {
                    url = url + ":" + puerto;
                } else if (protocolo.equals("http") && !puerto.equals("80")) {
                    url = url + ":" + puerto;
                } else if (protocolo.equals("https") && !puerto.equals("443")) {
                    url = url + ":" + puerto;
                }
                if (!pathUrl.isEmpty()) {
                    url = url + "/" + pathUrl;
                }
                if (url.contains("(")) {
                    url = url.substring(0, url.indexOf("("));
                }
                if (url.contains(" ")) {
                    url = url.replaceAll(" ", "");
                }
                return url;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String detectJavaVersion(byte[] classBytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(classBytes));
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid .class file");
        }
        in.readUnsignedShort();
        int major = in.readUnsignedShort();
        in.close();
        switch (major) {
            case 45: {
                return "Java 1.1";
            }
            case 46: {
                return "Java 1.2";
            }
            case 47: {
                return "Java 1.3";
            }
            case 48: {
                return "Java 1.4";
            }
            case 49: {
                return "Java 5";
            }
            case 50: {
                return "Java 6";
            }
            case 51: {
                return "Java 7";
            }
            case 52: {
                return "Java 8";
            }
            case 53: {
                return "Java 9";
            }
            case 54: {
                return "Java 10";
            }
            case 55: {
                return "Java 11";
            }
            case 56: {
                return "Java 12";
            }
            case 57: {
                return "Java 13";
            }
            case 58: {
                return "Java 14";
            }
            case 59: {
                return "Java 15";
            }
            case 60: {
                return "Java 16";
            }
            case 61: {
                return "Java 17";
            }
            case 62: {
                return "Java 18";
            }
            case 63: {
                return "Java 19";
            }
            case 64: {
                return "Java 20";
            }
            case 65: {
                return "Java 21";
            }
            case 66: {
                return "Java 22";
            }
            case 67: {
                return "Java 23";
            }
            case 68: {
                return "Java 24";
            }
            case 69: {
                return "Java 25";
            }
        }
        return "Unknown (major=" + major + ")";
    }

    private static Class<?> tryLoad(String fqcn, ClassLoader cl) {
        try {
            return Class.forName(fqcn, false, cl);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object newInstance(Class<?> c, Class<?>[] ptypes, Object[] args) throws Exception {
        return ptypes == null ? c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : c.getDeclaredConstructor(ptypes).newInstance(args);
    }

    private static Object invoke(Object targetOrClass, String method, Class<?>[] ptypes, Object[] args) throws Exception {
        Class<?> cls = targetOrClass instanceof Class ? (Class<?>)targetOrClass : targetOrClass.getClass();
        Method m = cls.getMethod(method, ptypes == null ? new Class[]{} : ptypes);
        return m.invoke(targetOrClass instanceof Class ? null : targetOrClass, args == null ? new Object[]{} : args);
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                host = args[0];
            }
            boolean i = false;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle usableBounds = ge.getMaximumWindowBounds();
            ventana.setSize(usableBounds.width, usableBounds.height);
            SwingUtilities.invokeLater(() -> {
                SyncJars syncJars = new SyncJars(host);
            });
            ventana.validate();
            ventana.setVisible(true);
            ventana.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

