/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.gpt4all;

import cl.mc3d.gpt4all.LLModelLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.ffi.LibraryLoader;
import jnr.ffi.LibraryOption;

public class Util {
    private static final CharsetDecoder cs = StandardCharsets.UTF_8.newDecoder();

    public static LLModelLibrary loadSharedLibrary(String librarySearchPath) {
        String libraryName = "llmodel";
        HashMap<LibraryOption, Boolean> libraryOptions = new HashMap<LibraryOption, Boolean>();
        libraryOptions.put(LibraryOption.LoadNow, true);
        libraryOptions.put(LibraryOption.IgnoreError, false);
        if (librarySearchPath != null) {
            HashMap searchPaths = new HashMap();
            ArrayList<String> lSearchPaths = new ArrayList<String>();
            lSearchPaths.add(librarySearchPath);
            searchPaths.put(libraryName, lSearchPaths);
            return (LLModelLibrary)LibraryLoader.loadLibrary(LLModelLibrary.class, libraryOptions, searchPaths, (String[])new String[]{libraryName});
        }
        return (LLModelLibrary)LibraryLoader.loadLibrary(LLModelLibrary.class, libraryOptions, (String[])new String[]{libraryName});
    }

    public static Path copySharedLibraries() {
        try {
            String[] libraryNames;
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isWindows = osName.startsWith("windows");
            boolean isMac = osName.startsWith("mac os x");
            boolean isLinux = osName.startsWith("linux");
            if (isWindows) {
                osName = "windows";
            }
            if (isMac) {
                osName = "macos";
            }
            if (isLinux) {
                osName = "linux";
            }
            Path tempDirectory = Files.createTempDirectory("nativeLibraries", new FileAttribute[0]);
            tempDirectory.toFile().deleteOnExit();
            for (String libraryName : libraryNames = new String[]{"gptj-default", "gptj-avxonly", "llmodel", "mpt-default", "llamamodel-230511-default", "llamamodel-230519-default", "llamamodel-mainline-default", "llamamodel-mainline-metal", "replit-mainline-default", "replit-mainline-metal", "ggml-metal.metal", "falcon-default"}) {
                if (!isMac && (libraryName.equals("replit-mainline-metal") || libraryName.equals("llamamodel-mainline-metal") || libraryName.equals("ggml-metal.metal"))) continue;
                if (isWindows) {
                    libraryName = libraryName + ".dll";
                } else if (isMac) {
                    if (!libraryName.equals("ggml-metal.metal")) {
                        libraryName = "lib" + libraryName + ".dylib";
                    }
                } else if (isLinux) {
                    libraryName = "lib" + libraryName + ".so";
                }
                String nativeLibraryPath = "/native/" + osName + "/" + libraryName;
                InputStream in = Util.class.getResourceAsStream(nativeLibraryPath);
                if (in == null) {
                    throw new RuntimeException("Unable to find native library: " + nativeLibraryPath);
                }
                Path tempLibraryPath = tempDirectory.resolve(libraryName);
                Files.copy(in, tempLibraryPath, StandardCopyOption.REPLACE_EXISTING);
                in.close();
            }
            if (!isWindows) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Files.walk(tempDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                            try {
                                Files.delete(file.toPath());
                            }
                            catch (IOException e) {
                                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, "Deleting temp library file", e);
                            }
                        });
                    }
                    catch (IOException e) {
                        Logger.getLogger(Util.class.getName()).log(Level.SEVERE, "Deleting temp directory for libraries", e);
                    }
                }));
            }
            return tempDirectory;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load native libraries", e);
        }
    }

    public static String getValidUtf8(byte[] bytes) {
        try {
            return cs.decode(ByteBuffer.wrap(bytes)).toString();
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }
}

