/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.ui.CommandButton;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.plaf.UIResource;

public class JTab
extends JPanel
implements UIResource {
    private String id;
    private JTab jTab = this;
    private JPanel inputPanel = new JPanel(new BorderLayout());
    private JTextArea messageArea = new JTextArea();
    private String saveFileName;

    public JTextArea getMessageArea() {
        return this.messageArea;
    }

    public void setSaveFileName(String saveFileName) {
        this.saveFileName = saveFileName;
    }

    public JTab(String title, JPanel jPanel) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add("Center", jPanel);
        this.add("North", this.inputPanel);
    }

    public void setClosable(boolean closable) {
        if (closable) {
            CommandButton closeButton = new CommandButton("X");
            closeButton.setTheme("midnight", false);
            closeButton.setBorderPainted(false);
            closeButton.setOpaque(false);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).getParent().getParent().getParent().remove(JTab.this.jTab);
                }
            });
            this.inputPanel.add("East", closeButton);
            this.add("North", this.inputPanel);
        }
    }

    public void setSave(boolean save) {
        if (save) {
            CommandButton saveButton = new CommandButton("Save");
            saveButton.setTheme("midnight", false);
            saveButton.setBorderPainted(false);
            saveButton.setOpaque(false);
            final JLabel outputText = new JLabel();
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JTab.this.saveFileName != null) {
                        outputText.setText(JTab.this.saveFileName + " , last Saved Date: " + new Date());
                        try {
                            RandomAccessFile raf = new RandomAccessFile(JTab.this.saveFileName, "rw");
                            String data = JTab.this.messageArea.getText();
                            raf.writeBytes(data);
                            raf.close();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(JTab.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
            this.inputPanel.add("Center", outputText);
            this.inputPanel.add("West", saveButton);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

