/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.scanner;

import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.lang.IgniteBiTuple;

public interface ScannerHandler {
    public void handle(IgniteBiTuple<WALPointer, WALRecord> var1);

    default public void finish() {
    }

    default public ScannerHandler andThen(final ScannerHandler then) {
        final ScannerHandler thiz = this;
        return new ScannerHandler(){

            @Override
            public void handle(IgniteBiTuple<WALPointer, WALRecord> record) {
                try {
                    thiz.handle(record);
                }
                finally {
                    then.handle(record);
                }
            }

            @Override
            public void finish() {
                try {
                    thiz.finish();
                }
                finally {
                    then.finish();
                }
            }
        };
    }

    public static String toStringRecord(WALRecord walRecord) {
        String walRecordStr;
        try {
            walRecordStr = walRecord != null ? walRecord.toString() : "Record is null";
        }
        catch (RuntimeException e) {
            walRecordStr = "Record : " + (Object)((Object)walRecord.type()) + " - Unable to convert to string representation.";
        }
        return walRecordStr;
    }
}

