/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cdc.CdcManager;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.systemview.ScanQuerySystemView;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.CacheDiagnosticManager;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectsReleaseFuture;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedTtlCleanupManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.PartitionsEvictManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.TransactionMetricsAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheSharedContext<K, V> {
    private GridKernalContext kernalCtx;
    private List<GridCacheSharedManager<K, V>> mgrs = new LinkedList<GridCacheSharedManager<K, V>>();
    private IgniteTxManager txMgr;
    private CacheJtaManagerAdapter jtaMgr;
    private GridCachePartitionExchangeManager<K, V> exchMgr;
    private GridCacheVersionManager verMgr;
    private GridCacheMvccManager mvccMgr;
    private GridCacheIoManager ioMgr;
    private GridCacheDeploymentManager<K, V> depMgr;
    @Nullable
    private IgniteWriteAheadLogManager walMgr;
    @Nullable
    private IgniteWriteAheadLogManager cdcWalMgr;
    @Nullable
    private CdcManager cdcMgr;
    private WalStateManager walStateMgr;
    private IgniteCacheDatabaseSharedManager dbMgr;
    @Nullable
    private IgnitePageStoreManager pageStoreMgr;
    private IgniteSnapshotManager snapshotMgr;
    private CacheAffinitySharedManager affMgr;
    private GridCacheSharedTtlCleanupManager ttlMgr;
    private PartitionsEvictManager evictMgr;
    private MvccCachingManager mvccCachingMgr;
    private final ConcurrentHashMap<Integer, GridCacheContext<K, V>> ctxMap;
    private final TransactionMetricsAdapter txMetrics;
    private CacheDiagnosticManager diagnosticMgr;
    private Collection<CacheStoreSessionListener> storeSesLsnrs;
    private final AtomicInteger locStoreCnt;
    private final boolean locStorePrimaryOnly = IgniteSystemProperties.getBoolean("IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY");
    private final IgniteLogger msgLog;
    private final IgniteLogger atomicMsgLog;
    private final IgniteLogger txPrepareMsgLog;
    private final IgniteLogger txFinishMsgLog;
    private final IgniteLogger txLockMsgLog;
    private final IgniteLogger txRecoveryMsgLog;
    private AtomicIntegerArray dhtAtomicUpdCnt;
    private boolean rebalanceEnabled = true;
    private final List<IgniteChangeGlobalStateSupport> stateAwareMgrs;
    private volatile boolean readOnlyMode;

    public static Builder builder() {
        return new Builder();
    }

    private GridCacheSharedContext(GridKernalContext kernalCtx, IgniteTxManager txMgr, GridCacheVersionManager verMgr, GridCacheMvccManager mvccMgr, @Nullable IgnitePageStoreManager pageStoreMgr, @Nullable IgniteWriteAheadLogManager walMgr, WalStateManager walStateMgr, IgniteCacheDatabaseSharedManager dbMgr, IgniteSnapshotManager snapshotMgr, GridCacheDeploymentManager<K, V> depMgr, GridCachePartitionExchangeManager<K, V> exchMgr, CacheAffinitySharedManager<K, V> affMgr, GridCacheIoManager ioMgr, GridCacheSharedTtlCleanupManager ttlMgr, PartitionsEvictManager evictMgr, CacheJtaManagerAdapter jtaMgr, Collection<CacheStoreSessionListener> storeSesLsnrs, MvccCachingManager mvccCachingMgr, CacheDiagnosticManager diagnosticMgr, CdcManager cdcMgr) {
        this.kernalCtx = kernalCtx;
        this.setManagers(this.mgrs, txMgr, jtaMgr, verMgr, mvccMgr, pageStoreMgr, CU.isPersistenceEnabled(kernalCtx.config()) ? walMgr : null, walMgr, walStateMgr, dbMgr, snapshotMgr, depMgr, exchMgr, affMgr, ioMgr, ttlMgr, evictMgr, mvccCachingMgr, diagnosticMgr, cdcMgr);
        this.storeSesLsnrs = storeSesLsnrs;
        this.txMetrics = new TransactionMetricsAdapter(kernalCtx);
        this.ctxMap = new ConcurrentHashMap();
        kernalCtx.systemView().registerView(new ScanQuerySystemView<K, V>(this.ctxMap.values()));
        this.locStoreCnt = new AtomicInteger();
        if (dbMgr != null && CU.isPersistenceEnabled(kernalCtx.config())) {
            this.dhtAtomicUpdCnt = new AtomicIntegerArray(kernalCtx.config().getSystemThreadPoolSize());
        }
        this.msgLog = kernalCtx.log("org.apache.ignite.cache.msg");
        this.atomicMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.atomic");
        this.txPrepareMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.prepare");
        this.txFinishMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.finish");
        this.txLockMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.lock");
        this.txRecoveryMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.recovery");
        this.stateAwareMgrs = new ArrayList<IgniteChangeGlobalStateSupport>();
        if (pageStoreMgr != null) {
            this.stateAwareMgrs.add(pageStoreMgr);
        }
        if (walMgr != null) {
            this.stateAwareMgrs.add(walMgr);
        }
        this.stateAwareMgrs.add(dbMgr);
        this.stateAwareMgrs.add(snapshotMgr);
        for (PluginProvider prv : kernalCtx.plugins().allProviders()) {
            if (!(prv instanceof IgniteChangeGlobalStateSupport)) continue;
            this.stateAwareMgrs.add((IgniteChangeGlobalStateSupport)((Object)prv));
        }
    }

    public void activate() throws IgniteCheckedException {
        long time = System.currentTimeMillis();
        for (IgniteChangeGlobalStateSupport mgr : this.stateAwareMgrs) {
            mgr.onActivate(this.kernalCtx);
        }
        if (this.msgLog.isInfoEnabled()) {
            this.msgLog.info("Components activation performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    public void deactivate() {
        for (int i = this.stateAwareMgrs.size() - 1; i >= 0; --i) {
            this.stateAwareMgrs.get(i).onDeActivate(this.kernalCtx);
        }
    }

    public IgniteLogger messageLogger() {
        return this.msgLog;
    }

    public IgniteLogger atomicMessageLogger() {
        return this.atomicMsgLog;
    }

    public IgniteLogger txPrepareMessageLogger() {
        return this.txPrepareMsgLog;
    }

    public IgniteLogger txFinishMessageLogger() {
        return this.txFinishMsgLog;
    }

    public IgniteLogger txLockMessageLogger() {
        return this.txLockMsgLog;
    }

    public IgniteLogger txRecoveryMessageLogger() {
        return this.txRecoveryMsgLog;
    }

    public boolean isRebalanceEnabled() {
        return this.rebalanceEnabled;
    }

    public void rebalanceEnabled(boolean rebalanceEnabled) {
        this.rebalanceEnabled = rebalanceEnabled;
        if (rebalanceEnabled) {
            this.enableRebalance();
        }
    }

    private void enableRebalance() {
        for (IgniteCacheProxy<?, ?> c : this.cache().publicCaches()) {
            c.rebalance();
        }
    }

    void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        GridCacheSharedManager<K, V> mgr;
        ListIterator<GridCacheSharedManager<K, V>> it = this.mgrs.listIterator(this.mgrs.size());
        while (it.hasPrevious()) {
            mgr = it.previous();
            mgr.onDisconnected(reconnectFut);
            if (!this.restartOnDisconnect(mgr)) continue;
            mgr.onKernalStop(true);
        }
        it = this.mgrs.listIterator(this.mgrs.size());
        while (it.hasPrevious()) {
            mgr = it.previous();
            if (!this.restartOnDisconnect(mgr)) continue;
            mgr.stop(true);
        }
        this.deactivate();
    }

    void onReconnected(boolean active) throws IgniteCheckedException {
        LinkedList<GridCacheSharedManager<K, V>> mgrs = new LinkedList<GridCacheSharedManager<K, V>>();
        this.setManagers(mgrs, this.txMgr, this.jtaMgr, this.verMgr, this.mvccMgr, this.pageStoreMgr, this.walMgr, this.cdcWalMgr, this.walStateMgr, this.dbMgr, this.snapshotMgr, new GridCacheDeploymentManager(), new GridCachePartitionExchangeManager(), this.affMgr, this.ioMgr, this.ttlMgr, this.evictMgr, this.mvccCachingMgr, this.diagnosticMgr, this.cdcMgr);
        this.mgrs = mgrs;
        for (GridCacheSharedManager gridCacheSharedManager : mgrs) {
            if (this.restartOnDisconnect(gridCacheSharedManager)) {
                gridCacheSharedManager.start(this);
            }
            gridCacheSharedManager.onReconnected(active);
        }
        this.kernalCtx.query().onCacheReconnect();
        if (!active) {
            this.affinity().clearGroupHoldersAndRegistry();
        }
        this.exchMgr.onKernalStart(active, true);
    }

    private boolean restartOnDisconnect(GridCacheSharedManager<?, ?> mgr) {
        return mgr instanceof GridCacheDeploymentManager || mgr instanceof GridCachePartitionExchangeManager;
    }

    private void setManagers(List<GridCacheSharedManager<K, V>> mgrs, IgniteTxManager txMgr, CacheJtaManagerAdapter jtaMgr, GridCacheVersionManager verMgr, GridCacheMvccManager mvccMgr, @Nullable IgnitePageStoreManager pageStoreMgr, IgniteWriteAheadLogManager walMgr, IgniteWriteAheadLogManager cdcWalMgr, WalStateManager walStateMgr, IgniteCacheDatabaseSharedManager dbMgr, IgniteSnapshotManager snapshotMgr, GridCacheDeploymentManager<K, V> depMgr, GridCachePartitionExchangeManager<K, V> exchMgr, CacheAffinitySharedManager affMgr, GridCacheIoManager ioMgr, GridCacheSharedTtlCleanupManager ttlMgr, PartitionsEvictManager evictMgr, MvccCachingManager mvccCachingMgr, CacheDiagnosticManager diagnosticMgr, CdcManager cdcMgr) {
        this.diagnosticMgr = this.add(mgrs, diagnosticMgr);
        this.mvccMgr = this.add(mgrs, mvccMgr);
        this.verMgr = this.add(mgrs, verMgr);
        this.txMgr = this.add(mgrs, txMgr);
        this.pageStoreMgr = this.add(mgrs, pageStoreMgr);
        this.walMgr = this.add(mgrs, walMgr);
        assert (walMgr == null || walMgr == cdcWalMgr);
        this.cdcWalMgr = walMgr == null ? this.add(mgrs, cdcWalMgr) : cdcWalMgr;
        this.cdcMgr = this.add(mgrs, cdcMgr);
        this.walStateMgr = this.add(mgrs, walStateMgr);
        this.dbMgr = this.add(mgrs, dbMgr);
        this.snapshotMgr = this.add(mgrs, snapshotMgr);
        this.jtaMgr = this.add(mgrs, jtaMgr);
        this.depMgr = this.add(mgrs, depMgr);
        this.exchMgr = this.add(mgrs, exchMgr);
        this.affMgr = this.add(mgrs, affMgr);
        this.ioMgr = this.add(mgrs, ioMgr);
        this.ttlMgr = this.add(mgrs, ttlMgr);
        this.evictMgr = this.add(mgrs, evictMgr);
        this.mvccCachingMgr = this.add(mgrs, mvccCachingMgr);
    }

    public Collection<GridCacheContext> cacheContexts() {
        return this.ctxMap.values();
    }

    void forAllCaches(IgniteInClosure<GridCacheContext> c) {
        for (Integer cacheId : this.ctxMap.keySet()) {
            this.ctxMap.computeIfPresent(cacheId, (cacheId1, ctx) -> {
                c.apply((GridCacheContext)ctx);
                return ctx;
            });
        }
    }

    public GridCacheProcessor cache() {
        return this.kernalCtx.cache();
    }

    public void addCacheContext(GridCacheContext cacheCtx) throws IgniteCheckedException {
        if (this.ctxMap.containsKey(cacheCtx.cacheId())) {
            GridCacheContext<K, V> existing = this.ctxMap.get(cacheCtx.cacheId());
            throw new IgniteCheckedException("Failed to start cache due to conflicting cache ID (change cache name and restart grid) [cacheName=" + cacheCtx.name() + ", conflictingCacheName=" + existing.name() + ']');
        }
        CacheStoreManager mgr = cacheCtx.store();
        if (mgr.configured() && mgr.isLocal()) {
            this.locStoreCnt.incrementAndGet();
        }
        this.ctxMap.put(cacheCtx.cacheId(), cacheCtx);
    }

    void removeCacheContext(GridCacheContext cacheCtx) {
        int cacheId = cacheCtx.cacheId();
        this.ctxMap.remove(cacheId, cacheCtx);
        CacheStoreManager mgr = cacheCtx.store();
        if (mgr.configured() && mgr.isLocal()) {
            this.locStoreCnt.decrementAndGet();
        }
        this.ioMgr.removeCacheHandlers(cacheId);
    }

    public boolean closed(GridCacheContext ctx) {
        return !this.ctxMap.containsKey(ctx.cacheId());
    }

    public List<GridCacheSharedManager<K, V>> managers() {
        return this.mgrs;
    }

    public GridCacheContext<K, V> cacheContext(int cacheId) {
        return this.ctxMap.get(cacheId);
    }

    @Nullable
    public CacheObjectContext cacheObjectContext(int cacheId) throws IgniteCheckedException {
        GridCacheContext<K, V> ctx = this.ctxMap.get(cacheId);
        if (ctx != null) {
            return ctx.cacheObjectContext();
        }
        DynamicCacheDescriptor desc = this.cache().cacheDescriptor(cacheId);
        return desc != null ? desc.cacheObjectContext(this.kernalContext().cacheObjects()) : null;
    }

    public String igniteInstanceName() {
        return this.kernalCtx.igniteInstanceName();
    }

    public TransactionConfiguration txConfig() {
        return this.kernalCtx.config().getTransactionConfiguration();
    }

    public long preloadExchangeTimeout() {
        long t2;
        long t1 = this.gridConfig().getNetworkTimeout() * 4L;
        long timeout = Math.max(t1, t2 = this.gridConfig().getNetworkTimeout() * (long)this.gridConfig().getCacheConfiguration().length * 2L);
        return timeout < 0L ? Long.MAX_VALUE : timeout;
    }

    public boolean deploymentEnabled() {
        return this.kernalContext().deploy().enabled();
    }

    public byte dataCenterId() {
        GridCacheContext cacheCtx = F.first(this.cacheContexts());
        return cacheCtx.dataCenterId();
    }

    public TransactionMetricsAdapter txMetrics() {
        return this.txMetrics;
    }

    public void resetTxMetrics() {
        this.txMetrics.reset();
    }

    public IgniteTxManager tm() {
        return this.txMgr;
    }

    public CacheJtaManagerAdapter jta() {
        return this.jtaMgr;
    }

    public GridCachePartitionExchangeManager<K, V> exchange() {
        return this.exchMgr;
    }

    public CacheAffinitySharedManager<K, V> affinity() {
        return this.affMgr;
    }

    public GridCacheVersionManager versions() {
        return this.verMgr;
    }

    public GridCacheMvccManager mvcc() {
        return this.mvccMgr;
    }

    public IgniteCacheDatabaseSharedManager database() {
        return this.dbMgr;
    }

    @Nullable
    public IgnitePageStoreManager pageStore() {
        return this.pageStoreMgr;
    }

    public IgniteSnapshotManager snapshotMgr() {
        return this.snapshotMgr;
    }

    @Nullable
    public IgniteWriteAheadLogManager wal() {
        return this.wal(false);
    }

    @Nullable
    public IgniteWriteAheadLogManager wal(boolean forCdc) {
        assert (!forCdc || this.cdcWalMgr != null);
        return this.walMgr != null ? this.walMgr : (forCdc ? this.cdcWalMgr : null);
    }

    public CdcManager cdc() {
        return this.cdcMgr;
    }

    public WalStateManager walState() {
        return this.walStateMgr;
    }

    public GridCacheIoManager io() {
        return this.ioMgr;
    }

    public GridCacheSharedTtlCleanupManager ttl() {
        return this.ttlMgr;
    }

    public GridCacheDeploymentManager<K, V> deploy() {
        return this.depMgr;
    }

    public Marshaller marshaller() {
        return this.kernalCtx.config().getMarshaller();
    }

    public IgniteConfiguration gridConfig() {
        return this.kernalCtx.config();
    }

    public GridKernalContext kernalContext() {
        return this.kernalCtx;
    }

    public GridIoManager gridIO() {
        return this.kernalCtx.io();
    }

    public GridDeploymentManager gridDeploy() {
        return this.kernalCtx.deploy();
    }

    public GridEventStorageManager gridEvents() {
        return this.kernalCtx.event();
    }

    public GridDiscoveryManager discovery() {
        return this.kernalCtx.discovery();
    }

    public GridTimeoutProcessor time() {
        return this.kernalCtx.timeout();
    }

    public MvccProcessor coordinators() {
        return this.kernalCtx.coordinators();
    }

    public PartitionsEvictManager evict() {
        return this.evictMgr;
    }

    public MvccCachingManager mvccCaching() {
        return this.mvccCachingMgr;
    }

    public CacheDiagnosticManager diagnostic() {
        return this.diagnosticMgr;
    }

    public UUID localNodeId() {
        return this.kernalCtx.localNodeId();
    }

    public ClusterNode localNode() {
        return this.kernalCtx.discovery().localNode();
    }

    public int getLocalStoreCount() {
        return this.locStoreCnt.get();
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        return this.kernalCtx.discovery().node(nodeId);
    }

    public boolean localStorePrimaryOnly() {
        return this.locStorePrimaryOnly;
    }

    public IgniteLogger logger(Class<?> cls) {
        return this.kernalCtx.log(cls);
    }

    public IgniteLogger logger(String category) {
        return this.kernalCtx.log(category);
    }

    public IgniteInternalFuture<?> partitionReleaseFuture(AffinityTopologyVersion topVer) {
        CacheObjectsReleaseFuture f = new CacheObjectsReleaseFuture("Partition", topVer);
        f.add(this.mvcc().finishExplicitLocks(topVer));
        f.add(this.mvcc().finishAtomicUpdates(topVer));
        f.add(this.mvcc().finishDataStreamerUpdates(topVer));
        IgniteInternalFuture<Boolean> finishLocalTxsFuture = this.tm().finishLocalTxs(topVer);
        f.add(finishLocalTxsFuture);
        f.add(this.tm().finishAllTxs(finishLocalTxsFuture, topVer));
        f.markInitialized();
        return f;
    }

    public IgniteInternalFuture<?> partitionRecoveryFuture(AffinityTopologyVersion topVer, ClusterNode node) {
        return this.tm().recoverLocalTxs(topVer, node);
    }

    public IgniteInternalFuture<?> nextAffinityReadyFuture(AffinityTopologyVersion curVer) {
        if (curVer == null) {
            return null;
        }
        AffinityTopologyVersion nextVer = new AffinityTopologyVersion(curVer.topologyVersion() + 1L);
        GridFinishedFuture fut = this.exchMgr.affinityReadyFuture(nextVer);
        return fut == null ? new GridFinishedFuture() : fut;
    }

    @Nullable
    public String verifyTxCompatibility(IgniteInternalTx tx, GridIntList activeCacheIds, GridCacheContext<K, V> cacheCtx) {
        if (cacheCtx.systemTx() && !tx.system()) {
            return "system cache can be enlisted only in system transaction";
        }
        if (!cacheCtx.systemTx() && tx.system()) {
            return "non-system cache can't be enlisted in system transaction";
        }
        for (int i = 0; i < activeCacheIds.size(); ++i) {
            int cacheId = activeCacheIds.get(i);
            GridCacheContext<K, V> activeCacheCtx = this.cacheContext(cacheId);
            if (cacheCtx.systemTx() && activeCacheCtx.cacheId() != cacheCtx.cacheId()) {
                return "system transaction can include only one cache";
            }
            CacheStoreManager store = cacheCtx.store();
            CacheStoreManager activeStore = activeCacheCtx.store();
            if (store.isLocal() != activeStore.isLocal()) {
                return "caches with local and non-local stores can't be enlisted in one transaction";
            }
            if (store.isWriteBehind() != activeStore.isWriteBehind()) {
                return "caches with different write-behind setting can't be enlisted in one transaction";
            }
            if (activeCacheCtx.deploymentEnabled() != cacheCtx.deploymentEnabled()) {
                return "caches with enabled and disabled deployment modes can't be enlisted in one transaction";
            }
            assert (store.isWriteToStoreFromDht() == activeStore.isWriteToStoreFromDht());
        }
        return null;
    }

    @Nullable
    public AffinityTopologyVersion lockedTopologyVersion(IgniteInternalTx ignore) {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.txMgr.lockedTopologyVersion(threadId, ignore);
        if (topVer == null) {
            topVer = this.mvccMgr.lastExplicitLockTopologyVersion(threadId);
        }
        return topVer;
    }

    public void cleanup() {
        this.mvccMgr = null;
        this.mgrs.clear();
    }

    public void endTx(GridNearTxLocal tx) throws IgniteCheckedException {
        boolean clearThreadMap;
        boolean bl = clearThreadMap = this.txMgr.threadLocalTx(null) == tx;
        if (clearThreadMap) {
            tx.txState().awaitLastFuture(this);
        } else {
            tx.state(TransactionState.MARKED_ROLLBACK);
        }
        tx.close(clearThreadMap);
    }

    public IgniteInternalFuture<IgniteInternalTx> commitTxAsync(GridNearTxLocal tx) {
        GridCacheContext ctx = tx.txState().singleCacheContext(this);
        if (ctx == null) {
            tx.txState().awaitLastFuture(this);
            return tx.commitNearTxLocalAsync();
        }
        return ctx.cache().commitTxAsync(tx);
    }

    public IgniteInternalFuture rollbackTxAsync(GridNearTxLocal tx) {
        boolean clearThreadMap;
        boolean bl = clearThreadMap = this.txMgr.threadLocalTx(null) == tx;
        if (clearThreadMap) {
            tx.txState().awaitLastFuture(this);
        } else {
            tx.state(TransactionState.MARKED_ROLLBACK);
        }
        return tx.rollbackNearTxLocalAsync(clearThreadMap, false);
    }

    public void suspendTx(GridNearTxLocal tx) throws IgniteCheckedException {
        tx.txState().awaitLastFuture(this);
        tx.suspend();
    }

    public void resumeTx(GridNearTxLocal tx) throws IgniteCheckedException {
        tx.txState().awaitLastFuture(this);
        tx.resume();
    }

    @Nullable
    public Collection<CacheStoreSessionListener> storeSessionListeners() {
        return this.storeSesLsnrs;
    }

    @Nullable
    private <T extends GridCacheSharedManager<K, V>> T add(List<GridCacheSharedManager<K, V>> mgrs, @Nullable T mgr) {
        if (mgr != null) {
            mgrs.add(mgr);
        }
        return mgr;
    }

    public void txContextReset() {
        this.mvccMgr.contextReset();
    }

    public int startDhtAtomicUpdate(GridCacheVersion ver) {
        assert (this.dhtAtomicUpdCnt != null);
        return this.dhtAtomicUpdCnt.incrementAndGet(this.dhtAtomicUpdateIndex(ver));
    }

    public void finishDhtAtomicUpdate(GridCacheVersion ver) {
        assert (this.dhtAtomicUpdCnt != null);
        this.dhtAtomicUpdCnt.decrementAndGet(this.dhtAtomicUpdateIndex(ver));
    }

    private int dhtAtomicUpdateIndex(GridCacheVersion ver) {
        return U.safeAbs(ver.hashCode()) % this.dhtAtomicUpdCnt.length();
    }

    public boolean readOnlyMode() {
        return this.readOnlyMode;
    }

    public void readOnlyMode(boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    public void setTxManager(IgniteTxManager txMgr) {
        this.txMgr = txMgr;
    }

    public boolean isLazyMemoryAllocation(@Nullable DataRegion region) {
        return this.gridConfig().isClientMode() != false || region == null || region.config().isLazyMemoryAllocation();
    }

    public static class Builder {
        private IgniteTxManager txMgr;
        private CacheJtaManagerAdapter jtaMgr;
        private GridCacheVersionManager verMgr;
        private GridCacheMvccManager mvccMgr;
        private IgnitePageStoreManager pageStoreMgr;
        private IgniteWriteAheadLogManager walMgr;
        private WalStateManager walStateMgr;
        private IgniteCacheDatabaseSharedManager dbMgr;
        private IgniteSnapshotManager snapshotMgr;
        private GridCacheDeploymentManager<?, ?> depMgr;
        private GridCachePartitionExchangeManager<?, ?> exchMgr;
        private CacheAffinitySharedManager<?, ?> affMgr;
        private GridCacheIoManager ioMgr;
        private GridCacheSharedTtlCleanupManager ttlMgr;
        private PartitionsEvictManager evictMgr;
        private MvccCachingManager mvccCachingMgr;
        private CacheDiagnosticManager diagnosticMgr;
        private CdcManager cdcMgr;

        private Builder() {
        }

        public <K, V> GridCacheSharedContext<K, V> build(GridKernalContext kernalCtx, Collection<CacheStoreSessionListener> storeSesLsnrs) {
            return new GridCacheSharedContext(kernalCtx, this.txMgr, this.verMgr, this.mvccMgr, this.pageStoreMgr, this.walMgr, this.walStateMgr, this.dbMgr, this.snapshotMgr, this.depMgr, this.exchMgr, this.affMgr, this.ioMgr, this.ttlMgr, this.evictMgr, this.jtaMgr, storeSesLsnrs, this.mvccCachingMgr, this.diagnosticMgr, this.cdcMgr);
        }

        public Builder setTxManager(IgniteTxManager txMgr) {
            this.txMgr = txMgr;
            return this;
        }

        public Builder setJtaManager(CacheJtaManagerAdapter jtaMgr) {
            this.jtaMgr = jtaMgr;
            return this;
        }

        public Builder setVersionManager(GridCacheVersionManager verMgr) {
            this.verMgr = verMgr;
            return this;
        }

        public Builder setMvccManager(GridCacheMvccManager mvccMgr) {
            this.mvccMgr = mvccMgr;
            return this;
        }

        public Builder setPageStoreManager(IgnitePageStoreManager pageStoreMgr) {
            this.pageStoreMgr = pageStoreMgr;
            return this;
        }

        public Builder setWalManager(IgniteWriteAheadLogManager walMgr) {
            this.walMgr = walMgr;
            return this;
        }

        public Builder setWalStateManager(WalStateManager walStateMgr) {
            this.walStateMgr = walStateMgr;
            return this;
        }

        public Builder setDatabaseManager(IgniteCacheDatabaseSharedManager dbMgr) {
            this.dbMgr = dbMgr;
            return this;
        }

        public Builder setSnapshotManager(IgniteSnapshotManager snapshotMgr) {
            this.snapshotMgr = snapshotMgr;
            return this;
        }

        public Builder setDeploymentManager(GridCacheDeploymentManager depMgr) {
            this.depMgr = depMgr;
            return this;
        }

        public Builder setPartitionExchangeManager(GridCachePartitionExchangeManager exchMgr) {
            this.exchMgr = exchMgr;
            return this;
        }

        public Builder setAffinityManager(CacheAffinitySharedManager affMgr) {
            this.affMgr = affMgr;
            return this;
        }

        public Builder setIoManager(GridCacheIoManager ioMgr) {
            this.ioMgr = ioMgr;
            return this;
        }

        public Builder setTtlCleanupManager(GridCacheSharedTtlCleanupManager ttlMgr) {
            this.ttlMgr = ttlMgr;
            return this;
        }

        public Builder setPartitionsEvictManager(PartitionsEvictManager evictMgr) {
            this.evictMgr = evictMgr;
            return this;
        }

        public Builder setMvccCachingManager(MvccCachingManager mvccCachingMgr) {
            this.mvccCachingMgr = mvccCachingMgr;
            return this;
        }

        public Builder setDiagnosticManager(CacheDiagnosticManager diagnosticMgr) {
            this.diagnosticMgr = diagnosticMgr;
            return this;
        }

        public Builder setCdcManager(CdcManager cdcMgr) {
            this.cdcMgr = cdcMgr;
            return this;
        }
    }
}

