/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheMvccEntryInfo
extends GridCacheEntryInfo
implements MvccVersionAware,
MvccUpdateVersionAware {
    private static final long serialVersionUID = 0L;
    private static final int SIZE_OVERHEAD = 40;
    private long mvccCrdVer;
    private long mvccCntr;
    private int mvccOpCntr;
    private long newMvccCrdVer;
    private long newMvccCntr;
    private int newMvccOpCntr;

    @Override
    public long newMvccCoordinatorVersion() {
        return this.newMvccCrdVer;
    }

    @Override
    public long newMvccCounter() {
        return this.newMvccCntr;
    }

    @Override
    public int newMvccOperationCounter() {
        return this.newMvccOpCntr & 0x1FFFFFFF;
    }

    @Override
    public byte newMvccTxState() {
        return (byte)(this.newMvccOpCntr >>> 30);
    }

    @Override
    public long mvccCoordinatorVersion() {
        return this.mvccCrdVer;
    }

    @Override
    public long mvccCounter() {
        return this.mvccCntr;
    }

    @Override
    public int mvccOperationCounter() {
        return this.mvccOpCntr & 0x1FFFFFFF;
    }

    @Override
    public byte mvccTxState() {
        return (byte)(this.mvccOpCntr >>> 30);
    }

    public void mvccTxState(byte mvccTxState) {
        this.mvccOpCntr = this.mvccOpCntr & 0x3FFFFFFF | mvccTxState << 30;
    }

    public void newMvccTxState(byte newMvccTxState) {
        this.newMvccOpCntr = this.newMvccOpCntr & 0x3FFFFFFF | newMvccTxState << 30;
    }

    @Override
    public void newMvccVersion(long crd, long cntr, int opCntr) {
        this.newMvccCrdVer = crd;
        this.newMvccCntr = cntr;
        this.newMvccOpCntr = opCntr;
    }

    @Override
    public void mvccVersion(long crd, long cntr, int opCntr) {
        this.mvccCrdVer = crd;
        this.mvccCntr = cntr;
        this.mvccOpCntr = opCntr;
    }

    @Override
    public int marshalledSize(CacheObjectContext ctx) throws IgniteCheckedException {
        return 40 + super.marshalledSize(ctx);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 6: {
                if (!writer.writeLong("mvccCntr", this.mvccCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("mvccCrdVer", this.mvccCrdVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("mvccOpCntr", this.mvccOpCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeLong("newMvccCntr", this.newMvccCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeLong("newMvccCrdVer", this.newMvccCrdVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeInt("newMvccOpCntr", this.newMvccOpCntr)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 6: {
                this.mvccCntr = reader.readLong("mvccCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.mvccCrdVer = reader.readLong("mvccCrdVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.mvccOpCntr = reader.readInt("mvccOpCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.newMvccCntr = reader.readLong("newMvccCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.newMvccCrdVer = reader.readLong("newMvccCrdVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.newMvccOpCntr = reader.readInt("newMvccOpCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheMvccEntryInfo.class);
    }

    @Override
    public byte fieldsCount() {
        return 12;
    }

    @Override
    public short directType() {
        return 143;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheMvccEntryInfo.class, this);
    }
}

