/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootInlineRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;

public class MetaPageInitRootInlineFlagsCreatedVersionRecord
extends MetaPageInitRootInlineRecord {
    private final long flags;
    private final IgniteProductVersion createdVer;

    public MetaPageInitRootInlineFlagsCreatedVersionRecord(int grpId, long pageId, long rootId, int inlineSize) {
        super(grpId, pageId, rootId, inlineSize);
        this.createdVer = IgniteVersionUtils.VER;
        this.flags = 7L;
    }

    public MetaPageInitRootInlineFlagsCreatedVersionRecord(int grpId, long pageId, long rootId, int inlineSize, long flags, IgniteProductVersion createdVer) {
        super(grpId, pageId, rootId, inlineSize);
        this.flags = flags;
        this.createdVer = createdVer;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        super.applyDelta(pageMem, pageAddr);
        BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        io.initFlagsAndVersion(pageAddr, this.flags, this.createdVer);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_META_PAGE_INIT_ROOT_V3;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageInitRootInlineFlagsCreatedVersionRecord.class, this, "super", (Object)super.toString());
    }

    public IgniteProductVersion createdVersion() {
        return this.createdVer;
    }

    public long flags() {
        return this.flags;
    }
}

