/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheFindGarbageCommandArg;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceTask;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceTaskResult;

public class CacheFindGarbageCommand
implements ComputeCommand<CacheFindGarbageCommandArg, FindAndDeleteGarbageInPersistenceTaskResult> {
    @Override
    public String description() {
        return "Find and optionally delete garbage from shared cache groups which could be left after cache destroy";
    }

    @Override
    public Class<CacheFindGarbageCommandArg> argClass() {
        return CacheFindGarbageCommandArg.class;
    }

    @Override
    public Class<FindAndDeleteGarbageInPersistenceTask> taskClass() {
        return FindAndDeleteGarbageInPersistenceTask.class;
    }

    @Override
    public void printResult(CacheFindGarbageCommandArg arg, FindAndDeleteGarbageInPersistenceTaskResult res, Consumer<String> printer) {
        CommandUtils.printErrors(res.exceptions(), "Scanning for garbage failed on nodes:", printer);
        for (Map.Entry<UUID, FindAndDeleteGarbageInPersistenceJobResult> nodeEntry : res.result().entrySet()) {
            if (!nodeEntry.getValue().hasGarbage()) {
                printer.accept("Node " + nodeEntry.getKey() + " - garbage not found.");
                continue;
            }
            printer.accept("Garbage found on node " + nodeEntry.getKey() + ":");
            FindAndDeleteGarbageInPersistenceJobResult value = nodeEntry.getValue();
            Map<Integer, Map<Integer, Long>> grpPartErrorsCount = value.checkResult();
            if (!grpPartErrorsCount.isEmpty()) {
                for (Map.Entry<Integer, Map<Integer, Long>> entry : grpPartErrorsCount.entrySet()) {
                    for (Map.Entry<Integer, Long> e : entry.getValue().entrySet()) {
                        printer.accept("  Group=" + entry.getKey() + ", partition=" + e.getKey() + ", count of keys=" + e.getValue());
                    }
                }
            }
            printer.accept("");
        }
    }
}

