/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.dump;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.dump.DumpConsumer;
import org.apache.ignite.dump.DumpReaderConfiguration;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cdc.CdcMain;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.Dump;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.encryption.EncryptionSpi;

@IgniteExperimental
public class DumpReader
implements Runnable {
    private final DumpReaderConfiguration cfg;
    private final IgniteLogger log;

    public DumpReader(DumpReaderConfiguration cfg, IgniteLogger log) {
        this.cfg = cfg;
        this.log = log.getLogger(DumpReader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.ackAsciiLogo();
        try (Dump dump = new Dump(this.cfg.dumpRoot(), null, this.cfg.keepBinary(), false, this.encryptionSpi(), this.log);){
            DumpConsumer cnsmr = this.cfg.consumer();
            cnsmr.start();
            try {
                HashMap groups;
                File[] files = new File(this.cfg.dumpRoot(), "db/marshaller").listFiles(BinaryUtils::notTmpFile);
                if (files != null) {
                    cnsmr.onMappings(CdcMain.typeMappingIterator(files, tm -> true));
                }
                cnsmr.onTypes(dump.types());
                HashMap<Integer, List> grpToNodes = new HashMap<Integer, List>();
                Set cacheGroupIds = this.cfg.cacheGroupNames() != null ? Arrays.stream(this.cfg.cacheGroupNames()).map(GridCacheUtils::cacheId).collect(Collectors.toSet()) : null;
                for (SnapshotMetadata meta : dump.metadata()) {
                    for (Integer n : meta.cacheGroupIds()) {
                        if (cacheGroupIds != null && !cacheGroupIds.contains(n)) continue;
                        grpToNodes.computeIfAbsent(n, key -> new ArrayList()).add(meta.folderName());
                    }
                }
                cnsmr.onCacheConfigs(grpToNodes.entrySet().stream().flatMap(e -> dump.configs((String)F.first((List)e.getValue()), (Integer)e.getKey()).stream()).iterator());
                ExecutorService execSvc = this.cfg.threadCount() > 1 ? Executors.newFixedThreadPool(this.cfg.threadCount()) : null;
                AtomicBoolean skip = new AtomicBoolean(false);
                HashMap hashMap = groups = this.cfg.skipCopies() ? new HashMap() : null;
                if (groups != null) {
                    grpToNodes.keySet().forEach(grpId -> {
                        Set cfr_ignored_0 = groups.put(grpId, new HashSet());
                    });
                }
                for (Map.Entry entry : grpToNodes.entrySet()) {
                    int grp = (Integer)entry.getKey();
                    for (String node : (List)entry.getValue()) {
                        for (int part : dump.partitions(node, grp)) {
                            if (groups != null && !((Set)groups.get(grp)).add(part)) {
                                this.log.info("Skip copy partition [node=" + node + ", grp=" + grp + ", part=" + part + ']');
                                continue;
                            }
                            Runnable consumePart = () -> {
                                if (skip.get()) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Skip partition due to previous error [node=" + node + ", grp=" + grp + ", part=" + part + ']');
                                    }
                                    return;
                                }
                                try (Dump.DumpedPartitionIterator iter = dump.iterator(node, grp, part);){
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Consuming partition [node=" + node + ", grp=" + grp + ", part=" + part + ']');
                                    }
                                    cnsmr.onPartition(grp, part, iter);
                                }
                                catch (Exception ex) {
                                    skip.set(this.cfg.failFast());
                                    this.log.error("Error consuming partition [node=" + node + ", grp=" + grp + ", part=" + part + ']', ex);
                                    throw new IgniteException(ex);
                                }
                            };
                            if (this.cfg.threadCount() > 1) {
                                execSvc.submit(consumePart);
                                continue;
                            }
                            consumePart.run();
                        }
                    }
                }
                if (this.cfg.threadCount() > 1) {
                    execSvc.shutdown();
                    boolean bl = execSvc.awaitTermination(this.cfg.timeout().toMillis(), TimeUnit.MILLISECONDS);
                    if (!bl) {
                        this.log.warning("Dump processing tasks not finished after timeout. Cancelling");
                        execSvc.shutdownNow();
                    }
                }
            }
            finally {
                cnsmr.stop();
            }
        }
        catch (Exception e3) {
            throw new IgniteException(e3);
        }
    }

    private void ackAsciiLogo() {
        String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
        if (this.log.isInfoEnabled()) {
            this.log.info(IgniteKernal.NL + IgniteKernal.NL + ">>>    __________  ________________  ___  __  ____  ______    ___  _______   ___  _______" + IgniteKernal.NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/ / _ \\/ / / /  |/  / _ \\  / _ \\/ __/ _ | / _ \\/ __/ _ \\" + IgniteKernal.NL + ">>>  _/ // (_ /    // /  / / / _/  / // / /_/ / /|_/ / ___/ / , _/ _// __ |/ // / _// , _/" + IgniteKernal.NL + ">>> /___/\\___/_/|_/___/ /_/ /___/ /____/\\____/_/  /_/_/    /_/|_/___/_/ |_/____/___/_/|_|" + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> " + ver + IgniteKernal.NL + ">>> " + IgniteVersionUtils.COPYRIGHT + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> Ignite documentation: http://" + "ignite.apache.org" + IgniteKernal.NL + ">>> ConsistentId: " + this.cfg.dumpRoot() + IgniteKernal.NL + ">>> Consumer: " + U.toStringSafe(this.cfg.consumer()));
        }
        if (this.log.isQuiet()) {
            U.quiet(false, "   __________  ________________  ___  __  ____  ______    ___  _______   ___  _______", "  /  _/ ___/ |/ /  _/_  __/ __/ / _ \\/ / / /  |/  / _ \\  / _ \\/ __/ _ | / _ \\/ __/ _ \\", " _/ // (_ /    // /  / / / _/  / // / /_/ / /|_/ / ___/ / , _/ _// __ |/ // / _// , _/", "/___/\\___/_/|_/___/ /_/ /___/ /____/\\____/_/  /_/_/    /_/|_/___/_/ |_/____/___/_/|_|", "", ver, IgniteVersionUtils.COPYRIGHT, "", "Ignite documentation: http://ignite.apache.org", "Dump: " + this.cfg.dumpRoot(), "Consumer: " + U.toStringSafe(this.cfg.consumer()), "", "Quiet mode.");
            String fileName = this.log.fileName();
            if (fileName != null) {
                U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
            }
            if (this.log instanceof GridLoggerProxy) {
                U.quiet(false, "  ^-- Logging by '" + ((GridLoggerProxy)this.log).getLoggerInfo() + '\'');
            }
            U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite-cdc.{sh|bat}", "");
        }
    }

    private EncryptionSpi encryptionSpi() {
        EncryptionSpi encSpi = this.cfg.encryptionSpi();
        if (encSpi == null) {
            return null;
        }
        if (encSpi instanceof IgniteSpiAdapter) {
            ((IgniteSpiAdapter)((Object)encSpi)).onBeforeStart();
        }
        encSpi.spiStart("dump-reader");
        return encSpi;
    }
}

