/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.datastructures.DataStructureType;
import org.apache.ignite.internal.processors.datastructures.VolatileAtomicDataStructureValue;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public final class GridCacheCountDownLatchValue
extends VolatileAtomicDataStructureValue
implements Cloneable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private int cnt;
    @GridToStringInclude(sensitive=true)
    private int initCnt;
    private boolean autoDel;
    private long gridStartTime;

    public GridCacheCountDownLatchValue(int cnt, boolean del, long gridStartTime) {
        assert (cnt >= 0);
        this.cnt = cnt;
        this.initCnt = cnt;
        this.autoDel = del;
        this.gridStartTime = gridStartTime;
    }

    public GridCacheCountDownLatchValue() {
    }

    @Override
    public DataStructureType type() {
        return DataStructureType.COUNT_DOWN_LATCH;
    }

    @Override
    public long gridStartTime() {
        return this.gridStartTime;
    }

    public void set(int cnt) {
        this.cnt = cnt;
    }

    public int get() {
        return this.cnt;
    }

    public int initialCount() {
        return this.initCnt;
    }

    public boolean autoDelete() {
        return this.autoDel;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.cnt);
        out.writeInt(this.initCnt);
        out.writeBoolean(this.autoDel);
        out.writeLong(this.gridStartTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.cnt = in.readInt();
        this.initCnt = in.readInt();
        this.autoDel = in.readBoolean();
        this.gridStartTime = in.readLong();
    }

    public String toString() {
        return S.toString(GridCacheCountDownLatchValue.class, this);
    }
}

