/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.lang.IgniteInClosure;

public abstract class AbstractDataLeafIO
extends BPlusLeafIO<CacheSearchRow>
implements RowLinkIO {
    public AbstractDataLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, CacheSearchRow row) {
        assert (row.link() != 0L);
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, off, row.link());
        PageUtils.putInt(pageAddr, off += 8, row.hash());
        off += 4;
        if (this.storeCacheId()) {
            assert (row.cacheId() != 0);
            PageUtils.putInt(pageAddr, off, row.cacheId());
            off += 4;
        }
        if (this.storeMvccVersion()) {
            long mvccCrdVer = row.mvccCoordinatorVersion();
            long mvccCntr = row.mvccCounter();
            int mvccOpCntr = row.mvccOperationCounter();
            assert (MvccUtils.mvccVersionIsValid(mvccCrdVer, mvccCntr, mvccOpCntr));
            PageUtils.putLong(pageAddr, off, mvccCrdVer);
            PageUtils.putLong(pageAddr, off += 8, mvccCntr);
            PageUtils.putInt(pageAddr, off += 8, mvccOpCntr);
            PageUtils.putLong(pageAddr, off += 4, mvccCrdVer);
            PageUtils.putLong(pageAddr, off += 8, mvccCntr);
        }
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<CacheSearchRow> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        RowLinkIO rowIo = (RowLinkIO)((Object)srcIo);
        long link = rowIo.getLink(srcPageAddr, srcIdx);
        int hash = rowIo.getHash(srcPageAddr, srcIdx);
        int off = this.offset(dstIdx);
        PageUtils.putLong(dstPageAddr, off, link);
        PageUtils.putInt(dstPageAddr, off += 8, hash);
        off += 4;
        if (this.storeCacheId()) {
            int cacheId = rowIo.getCacheId(srcPageAddr, srcIdx);
            assert (cacheId != 0);
            PageUtils.putInt(dstPageAddr, off, cacheId);
            off += 4;
        }
        if (this.storeMvccVersion()) {
            long mvccCrd = rowIo.getMvccCoordinatorVersion(srcPageAddr, srcIdx);
            long mvccCntr = rowIo.getMvccCounter(srcPageAddr, srcIdx);
            int mvccOpCntr = rowIo.getMvccOperationCounter(srcPageAddr, srcIdx);
            assert (MvccUtils.mvccVersionIsValid(mvccCrd, mvccCntr, mvccOpCntr));
            long lockCrdVer = rowIo.getMvccLockCoordinatorVersion(srcPageAddr, srcIdx);
            long lockCntr = rowIo.getMvccLockCounter(srcPageAddr, srcIdx);
            assert (MvccUtils.mvccVersionIsValid(lockCrdVer, lockCntr));
            PageUtils.putLong(dstPageAddr, off, mvccCrd);
            PageUtils.putLong(dstPageAddr, off += 8, mvccCntr);
            PageUtils.putInt(dstPageAddr, off += 8, mvccOpCntr);
            PageUtils.putLong(dstPageAddr, off += 4, lockCrdVer);
            PageUtils.putLong(dstPageAddr, off += 8, lockCntr);
        }
    }

    @Override
    public final CacheSearchRow getLookupRow(BPlusTree<CacheSearchRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        int cacheId;
        long link = this.getLink(pageAddr, idx);
        int hash = this.getHash(pageAddr, idx);
        int n = cacheId = this.storeCacheId() ? this.getCacheId(pageAddr, idx) : 0;
        if (this.storeMvccVersion()) {
            long mvccCrd = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            assert (MvccUtils.mvccVersionIsValid(mvccCrd, mvccCntr, mvccOpCntr));
            return ((CacheDataTree)tree).rowStore().mvccRow(cacheId, hash, link, CacheDataRowAdapter.RowData.KEY_ONLY, mvccCrd, mvccCntr, mvccOpCntr);
        }
        return ((CacheDataTree)tree).rowStore().keySearchRow(cacheId, hash, link);
    }

    @Override
    public final long getLink(long pageAddr, int idx) {
        assert (idx < this.getCount(pageAddr)) : "idx=" + idx + ", cnt=" + this.getCount(pageAddr);
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public final int getHash(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 8);
    }

    @Override
    public void visit(long pageAddr, IgniteInClosure<CacheSearchRow> c) {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            c.apply(new CacheDataRowAdapter(this.getLink(pageAddr, i)));
        }
    }

    public boolean storeCacheId() {
        return false;
    }

    protected boolean storeMvccVersion() {
        return false;
    }
}

