/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataVerificationTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataVerificationTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class SnapshotMetadataVerificationTask
extends ComputeTaskAdapter<SnapshotMetadataVerificationTaskArg, SnapshotMetadataVerificationTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, SnapshotMetadataVerificationTaskArg arg) throws IgniteException {
        HashMap<MetadataVerificationJob, ClusterNode> map = U.newHashMap(subgrid.size());
        for (ClusterNode node : subgrid) {
            map.put(new MetadataVerificationJob(arg), node);
        }
        return map;
    }

    @Override
    @Nullable
    public SnapshotMetadataVerificationTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap<ClusterNode, List<SnapshotMetadata>> reduceRes = new HashMap<ClusterNode, List<SnapshotMetadata>>();
        HashMap<ClusterNode, Exception> exs = new HashMap<ClusterNode, Exception>();
        SnapshotMetadata first = null;
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                exs.put(res.getNode(), res.getException());
                continue;
            }
            List metas = (List)res.getData();
            for (SnapshotMetadata meta : metas) {
                if (first == null) {
                    first = meta;
                }
                if (!first.sameSnapshot(meta)) {
                    exs.put(res.getNode(), new IgniteException("An error occurred during comparing snapshot metadata from cluster nodes [first=" + first + ", meta=" + meta + ", nodeId=" + res.getNode().id() + ']'));
                    continue;
                }
                reduceRes.computeIfAbsent(res.getNode(), n -> new ArrayList()).add(meta);
            }
        }
        return new SnapshotMetadataVerificationTaskResult(reduceRes, exs);
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }

    private static class MetadataVerificationJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;
        @LoggerResource
        private transient IgniteLogger log;
        private final SnapshotMetadataVerificationTaskArg arg;

        public MetadataVerificationJob(SnapshotMetadataVerificationTaskArg arg) {
            this.arg = arg;
        }

        @Override
        public List<SnapshotMetadata> execute() throws IgniteException {
            IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
            List<SnapshotMetadata> snpMeta = snpMgr.readSnapshotMetadatas(this.arg.snapshotName(), this.arg.snapshotPath());
            if (this.arg.incrementIndex() > 0) {
                List metas = snpMeta.stream().filter(m -> m.consistentId().equals(this.ignite.localNode().consistentId())).collect(Collectors.toList());
                if (metas.size() != 1) {
                    throw new IgniteException("Failed to find snapshot metafile [metas=" + metas + ", snpName=" + this.arg.snapshotName() + ", snpPath=" + this.arg.snapshotPath() + ']');
                }
                this.checkIncrementalSnapshots((SnapshotMetadata)metas.get(0), this.arg);
            }
            return snpMeta;
        }

        public void checkIncrementalSnapshots(SnapshotMetadata fullMeta, SnapshotMetadataVerificationTaskArg arg) {
            try {
                IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
                long startSeg = fullMeta.snapshotRecordPointer().index();
                for (int inc = 1; inc <= arg.incrementIndex(); ++inc) {
                    File incSnpDir = snpMgr.incrementalSnapshotLocalDir(arg.snapshotName(), arg.snapshotPath(), inc);
                    if (!incSnpDir.exists()) {
                        throw new IgniteException("No incremental snapshot found [snpName=" + arg.snapshotName() + ", snpPath=" + arg.snapshotPath() + ", incrementIndex=" + inc + ']');
                    }
                    String metaFileName = IgniteSnapshotManager.snapshotMetaFileName(this.ignite.localNode().consistentId().toString());
                    File metafile = incSnpDir.toPath().resolve(metaFileName).toFile();
                    IncrementalSnapshotMetadata incMeta = (IncrementalSnapshotMetadata)snpMgr.readFromFile(metafile);
                    if (!incMeta.matchBaseSnapshot(fullMeta)) {
                        throw new IgniteException("Incremental snapshot doesn't match full snapshot [incMeta=" + incMeta + ", fullMeta=" + fullMeta + ']');
                    }
                    if (incMeta.incrementIndex() != inc) {
                        throw new IgniteException("Incremental snapshot meta has wrong index [expectedIdx=" + inc + ", meta=" + incMeta + ']');
                    }
                    this.checkWalSegments(incMeta, startSeg, IgniteSnapshotManager.incrementalSnapshotWalsDir(incSnpDir, incMeta.folderName()));
                    startSeg = incMeta.incrementalSnapshotPointer().index() + 1L;
                }
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        private void checkWalSegments(IncrementalSnapshotMetadata meta, long startWalSeg, File incSnpWalDir) {
            IgniteWalIteratorFactory factory = new IgniteWalIteratorFactory(this.log);
            List<FileDescriptor> walSeg = factory.resolveWalFiles(new IgniteWalIteratorFactory.IteratorParametersBuilder().filesOrDirs(incSnpWalDir.listFiles(file -> FileWriteAheadLogManager.WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches())));
            if (walSeg.isEmpty()) {
                throw new IgniteException("No WAL segments found for incremental snapshot [dir=" + incSnpWalDir + ']');
            }
            long actFirstSeg = walSeg.get(0).idx();
            if (actFirstSeg != startWalSeg) {
                throw new IgniteException("Missed WAL segment [expectFirstSegment=" + startWalSeg + ", actualFirstSegment=" + actFirstSeg + ", meta=" + meta + ']');
            }
            long expLastSeg = meta.incrementalSnapshotPointer().index();
            long actLastSeg = walSeg.get(walSeg.size() - 1).idx();
            if (actLastSeg != expLastSeg) {
                throw new IgniteException("Missed WAL segment [expectLastSegment=" + startWalSeg + ", actualLastSegment=" + actFirstSeg + ", meta=" + meta + ']');
            }
            List<T2<Long, Long>> walSegGaps = factory.hasGaps(walSeg);
            if (!walSegGaps.isEmpty()) {
                throw new IgniteException("Missed WAL segments [misses=" + walSegGaps + ", meta=" + meta + ']');
            }
        }
    }
}

