/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PageMemoryNoStoreImpl
implements PageMemory {
    public static final long PAGE_MARKER = -4689742691020378367L;
    private static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long COUNTER_MASK = -72057594037927936L;
    private static final long COUNTER_INC = 0x100000000000000L;
    public static final int PAGE_ID_OFFSET = 8;
    public static final int LOCK_OFFSET = 16;
    public static final int PAGE_OVERHEAD = 24;
    private static final int SEG_BITS = 4;
    private static final int SEG_CNT = 16;
    private static final int IDX_BITS = 28;
    private static final int SEG_MASK = 15;
    private static final int IDX_MASK = 0xFFFFFFF;
    private final int sysPageSize;
    private final IgniteLogger log;
    private final DirectMemoryProvider directMemoryProvider;
    private final DataRegionConfiguration dataRegionCfg;
    private final AtomicLong freePageListHead = new AtomicLong(0xFFFFFFFFFFFFFFL);
    private volatile Segment[] segments;
    private final Object segmentsLock = new Object();
    private final AtomicInteger allocatedPages = new AtomicInteger();
    private final DataRegionMetricsImpl dataRegionMetrics;
    private final AtomicInteger selector = new AtomicInteger();
    private final OffheapReadWriteLock rwLock;
    private final int lockConcLvl = IgniteSystemProperties.getInteger("IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL", IgniteUtils.nearestPow2(Runtime.getRuntime().availableProcessors() * 4));
    private final int totalPages;
    private final boolean trackAcquiredPages;
    private final GridCacheSharedContext<?, ?> ctx;
    private volatile boolean started;

    public PageMemoryNoStoreImpl(GridCacheSharedContext<?, ?> sharedCtx, DirectMemoryProvider directMemoryProvider, int pageSize, DataRegionConfiguration dataRegionCfg, DataRegionMetricsImpl dataRegionMetrics) {
        this(sharedCtx.logger(PageMemoryNoStoreImpl.class), directMemoryProvider, sharedCtx, pageSize, dataRegionCfg, dataRegionMetrics, false);
    }

    public PageMemoryNoStoreImpl(IgniteLogger log, DirectMemoryProvider directMemoryProvider, GridCacheSharedContext<?, ?> sharedCtx, int pageSize, DataRegionConfiguration dataRegionCfg, DataRegionMetricsImpl dataRegionMetrics, boolean trackAcquiredPages) {
        assert (log != null);
        assert (pageSize % 8 == 0);
        this.log = log;
        this.directMemoryProvider = directMemoryProvider;
        this.trackAcquiredPages = trackAcquiredPages;
        this.dataRegionCfg = dataRegionCfg;
        this.ctx = sharedCtx;
        this.dataRegionMetrics = dataRegionMetrics;
        this.sysPageSize = pageSize + 24;
        assert (this.sysPageSize % 8 == 0) : this.sysPageSize;
        this.totalPages = (int)(dataRegionCfg.getMaxSize() / (long)this.sysPageSize);
        this.rwLock = new OffheapReadWriteLock(this.lockConcLvl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteException {
        Object object = this.segmentsLock;
        synchronized (object) {
            long allocSize;
            if (this.started) {
                return;
            }
            this.started = true;
            long startSize = this.dataRegionCfg.getInitialSize();
            long maxSize = this.dataRegionCfg.getMaxSize();
            long[] chunks = new long[16];
            chunks[0] = startSize;
            long total = startSize;
            long allocChunkSize = Math.max((maxSize - startSize) / 15L, 0x10000000L);
            int lastIdx = 0;
            int i = 1;
            while (i < 16 && (allocSize = Math.min(allocChunkSize, maxSize - total)) > 0L) {
                chunks[i] = allocSize;
                total += allocSize;
                lastIdx = i++;
            }
            if (lastIdx != 15) {
                chunks = Arrays.copyOf(chunks, lastIdx + 1);
            }
            if (this.segments == null) {
                this.directMemoryProvider.initialize(chunks);
            }
            this.addSegment(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean deallocate) throws IgniteException {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping page memory.");
            }
            this.started = false;
            this.directMemoryProvider.shutdown(deallocate);
            if (this.directMemoryProvider instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.directMemoryProvider)).close();
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
            }
        }
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer(pageAddr, this.pageSize());
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) {
        assert (this.started);
        long relPtr = this.borrowFreePage(grpId);
        long absPtr = 0L;
        if (relPtr != 0xFFFFFFFFFFFFFFL) {
            int pageIdx = PageIdUtils.pageIndex(relPtr);
            Segment seg = this.segment(pageIdx);
            absPtr = seg.absolute(pageIdx);
        } else {
            Segment[] seg0 = this.segments;
            Segment allocSeg = seg0[seg0.length - 1];
            while (allocSeg != null) {
                relPtr = allocSeg.allocateFreePage(flags);
                if (relPtr != 0xFFFFFFFFFFFFFFL) {
                    absPtr = allocSeg.absolute(PageIdUtils.pageIndex(relPtr));
                    this.allocatedPages.incrementAndGet();
                    PageMetrics grpPageMetrics = this.dataRegionMetrics.cacheGrpPageMetrics(grpId);
                    grpPageMetrics.totalPages().increment();
                    break;
                }
                allocSeg = this.addSegment(seg0);
            }
        }
        if (relPtr == 0xFFFFFFFFFFFFFFL) {
            IgniteOutOfMemoryException oom = new IgniteOutOfMemoryException("Out of memory in data region [name=" + this.dataRegionCfg.getName() + ", initSize=" + U.readableSize(this.dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(this.dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + this.dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable Ignite persistence (DataRegionConfiguration.persistenceEnabled)" + U.nl() + "  ^-- Enable eviction or expiration policies");
            if (this.ctx != null) {
                this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, oom));
            }
            throw oom;
        }
        assert ((relPtr & 0xFFFFFFFF00000000L) == 0L) : U.hexLong(relPtr & 0xFFFFFFFF00000000L);
        long pageId = PageIdUtils.pageId(partId, flags, (int)relPtr);
        this.writePageId(absPtr, pageId);
        GridUnsafe.zeroMemory(absPtr + 24L, this.sysPageSize - 24);
        return pageId;
    }

    @Override
    public boolean freePage(int grpId, long pageId) {
        assert (this.started);
        this.releaseFreePage(grpId, pageId);
        return true;
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 24;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int grpId) {
        return this.pageSize();
    }

    private int nextRoundRobinIndex() {
        int nextIdx;
        int idx;
        do {
            if ((nextIdx = (idx = this.selector.get()) + 1) < this.segments.length) continue;
            nextIdx = 0;
        } while (!this.selector.compareAndSet(idx, nextIdx));
        return nextIdx;
    }

    @Override
    public long loadedPages() {
        return this.allocatedPages.get();
    }

    public int totalPages() {
        return this.totalPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        long total = 0L;
        for (Segment seg : this.segments) {
            seg.readLock().lock();
            try {
                int acquired = seg.acquiredPages();
                assert (acquired >= 0);
                total += (long)acquired;
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total;
    }

    private void writePageId(long absPtr, long pageId) {
        GridUnsafe.putLong(absPtr + 8L, pageId);
    }

    private Segment segment(int pageIdx) {
        int segIdx = this.segmentIndex(pageIdx);
        return this.segments[segIdx];
    }

    private int segmentIndex(long pageIdx) {
        return (int)(pageIdx >> 28 & 0xFL);
    }

    private long fromSegmentIndex(int segIdx, long pageIdx) {
        long res = 0L;
        res = res << 4 | (long)(segIdx & 0xF);
        res = res << 28 | pageIdx & 0xFFFFFFFL;
        return res;
    }

    @Override
    public long acquirePage(int cacheId, long pageId) {
        return this.acquirePage(cacheId, pageId, IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public long acquirePage(int cacheId, long pageId, IoStatisticsHolder statHolder) {
        assert (this.started);
        int pageIdx = PageIdUtils.pageIndex(pageId);
        Segment seg = this.segment(pageIdx);
        long absPtr = seg.acquirePage(pageIdx);
        statHolder.trackLogicalRead(absPtr + 24L);
        return absPtr;
    }

    @Override
    public void releasePage(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.trackAcquiredPages) {
            Segment seg = this.segment(PageIdUtils.pageIndex(pageId));
            seg.onPageRelease();
        }
    }

    @Override
    public long readLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.readLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public long readLockForce(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.readLock(page + 16L, -1)) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public void readUnlock(int cacheId, long pageId, long page) {
        assert (this.started);
        this.rwLock.readUnlock(page + 16L);
    }

    @Override
    public long writeLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.writeLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public long tryWriteLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.tryWriteLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public void writeUnlock(int cacheId, long pageId, long page, Boolean walPlc, boolean dirtyFlag) {
        assert (this.started);
        long actualId = PageIO.getPageId(page + 24L);
        this.rwLock.writeUnlock(page + 16L, PageIdUtils.tag(actualId));
    }

    @Override
    public boolean isDirty(int cacheId, long pageId, long page) {
        return false;
    }

    public int pageSequenceNumber(int pageIdx) {
        Segment seg = this.segment(pageIdx);
        return seg.sequenceNumber(pageIdx);
    }

    public int pageIndex(int seqNo) {
        Object[] segs = this.segments;
        int low = 0;
        int high = segs.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Segment seg = segs[mid];
            int cmp = seg.containsPageBySequence(seqNo);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return seg.pageIndex(seqNo);
        }
        throw new IgniteException("Allocated page must always be present in one of the segments [seqNo=" + seqNo + ", segments=" + Arrays.toString(segs) + ']');
    }

    private void releaseFreePage(int grpId, long pageId) {
        long freePageRelPtrMasked;
        int pageIdx = PageIdUtils.pageIndex(pageId);
        long relPtr = PageIdUtils.pageId(0, (byte)0, pageIdx);
        Segment seg = this.segment(pageIdx);
        long absPtr = seg.absolute(pageIdx);
        this.writePageId(absPtr, relPtr);
        do {
            freePageRelPtrMasked = this.freePageListHead.get();
            long freePageRelPtr = freePageRelPtrMasked & 0xFFFFFFFFFFFFFFL;
            GridUnsafe.putLong(absPtr, freePageRelPtr);
        } while (!this.freePageListHead.compareAndSet(freePageRelPtrMasked, relPtr));
        this.allocatedPages.decrementAndGet();
        PageMetrics pageMetrics = this.dataRegionMetrics.cacheGrpPageMetrics(grpId);
        pageMetrics.totalPages().decrement();
    }

    private long borrowFreePage(int grpId) {
        long cnt;
        long freePageRelPtr;
        int pageIdx;
        Segment seg;
        long freePageAbsPtr;
        long nextFreePageRelPtr;
        long freePageRelPtrMasked;
        do {
            if ((freePageRelPtr = (freePageRelPtrMasked = this.freePageListHead.get()) & 0xFFFFFFFFFFFFFFL) != 0xFFFFFFFFFFFFFFL) continue;
            return 0xFFFFFFFFFFFFFFL;
        } while (!this.freePageListHead.compareAndSet(freePageRelPtrMasked, (nextFreePageRelPtr = GridUnsafe.getLong(freePageAbsPtr = (seg = this.segment(pageIdx = PageIdUtils.pageIndex(freePageRelPtr))).absolute(pageIdx)) & 0xFFFFFFFFFFFFFFL) | (cnt = (freePageRelPtrMasked & 0xFF00000000000000L) + 0x100000000000000L & 0xFF00000000000000L)));
        GridUnsafe.putLong(freePageAbsPtr, -4689742691020378367L);
        this.allocatedPages.incrementAndGet();
        PageMetrics grpPageMetrics = this.dataRegionMetrics.cacheGrpPageMetrics(grpId);
        grpPageMetrics.totalPages().increment();
        return freePageRelPtr;
    }

    private synchronized Segment addSegment(Segment[] oldRef) {
        if (this.segments == oldRef) {
            DirectMemoryRegion region = this.directMemoryProvider.nextRegion();
            if (region == null) {
                return null;
            }
            if (oldRef != null && this.log.isInfoEnabled()) {
                this.log.info("Allocated next memory segment [plcName=" + this.dataRegionCfg.getName() + ", chunkSize=" + U.readableSize(region.size(), true) + ']');
            }
            Segment[] newRef = new Segment[oldRef == null ? 1 : oldRef.length + 1];
            if (oldRef != null) {
                System.arraycopy(oldRef, 0, newRef, 0, oldRef.length);
            }
            Segment lastSeg = oldRef == null ? null : oldRef[oldRef.length - 1];
            Segment allocated = new Segment(newRef.length - 1, region, lastSeg == null ? 0 : lastSeg.sumPages());
            allocated.init();
            newRef[newRef.length - 1] = allocated;
            this.segments = newRef;
        }
        return this.segments[this.segments.length - 1];
    }

    @Override
    public int checkpointBufferPagesCount() {
        return 0;
    }

    @Override
    public DataRegionMetricsImpl metrics() {
        return this.dataRegionMetrics;
    }

    private class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private final int idx;
        private final DirectMemoryRegion region;
        private long lastAllocatedIdxPtr;
        private long pagesBase;
        private final int pagesInPrevSegments;
        private int maxPages;
        private final AtomicInteger acquiredPages;

        private Segment(int idx, DirectMemoryRegion region, int pagesInPrevSegments) {
            this.idx = idx;
            this.region = region;
            this.pagesInPrevSegments = pagesInPrevSegments;
            this.acquiredPages = new AtomicInteger();
        }

        private void init() {
            long base;
            this.lastAllocatedIdxPtr = base = this.region.address();
            this.pagesBase = (base += 8L) + 7L & 0xFFFFFFFFFFFFFFF8L;
            GridUnsafe.putLong(this.lastAllocatedIdxPtr, 0L);
            long limit = this.region.address() + this.region.size();
            this.maxPages = (int)((limit - this.pagesBase) / (long)PageMemoryNoStoreImpl.this.sysPageSize);
        }

        private long acquirePage(int pageIdx) {
            long absPtr = this.absolute(pageIdx);
            assert (absPtr % 8L == 0L) : absPtr;
            if (PageMemoryNoStoreImpl.this.trackAcquiredPages) {
                this.acquiredPages.incrementAndGet();
            }
            return absPtr;
        }

        private void onPageRelease() {
            this.acquiredPages.decrementAndGet();
        }

        private long absolute(int pageIdx) {
            long off = (long)(pageIdx &= 0xFFFFFFF) * (long)PageMemoryNoStoreImpl.this.sysPageSize;
            return this.pagesBase + off;
        }

        private int sequenceNumber(int pageIdx) {
            return this.pagesInPrevSegments + (pageIdx &= 0xFFFFFFF);
        }

        private int sumPages() {
            return this.pagesInPrevSegments + this.maxPages;
        }

        private int acquiredPages() {
            return this.acquiredPages.get();
        }

        private long allocateFreePage(int tag) throws GridOffHeapOutOfMemoryException {
            long lastIdx;
            long limit = this.region.address() + this.region.size();
            do {
                if (this.pagesBase + ((lastIdx = GridUnsafe.getLongVolatile(null, this.lastAllocatedIdxPtr)) + 1L) * (long)PageMemoryNoStoreImpl.this.sysPageSize <= limit) continue;
                return 0xFFFFFFFFFFFFFFL;
            } while (!GridUnsafe.compareAndSwapLong(null, this.lastAllocatedIdxPtr, lastIdx, lastIdx + 1L));
            long absPtr = this.pagesBase + lastIdx * (long)PageMemoryNoStoreImpl.this.sysPageSize;
            assert (lastIdx <= 0xFFFFFFFFL) : lastIdx;
            long pageIdx = PageMemoryNoStoreImpl.this.fromSegmentIndex(this.idx, lastIdx);
            assert (pageIdx != 0xFFFFFFFFFFFFFFL);
            PageMemoryNoStoreImpl.this.writePageId(absPtr, pageIdx);
            GridUnsafe.putLong(absPtr, -4689742691020378367L);
            PageMemoryNoStoreImpl.this.rwLock.init(absPtr + 16L, tag);
            return pageIdx;
        }

        public int containsPageBySequence(int seqNo) {
            if (seqNo < this.pagesInPrevSegments) {
                return -1;
            }
            if (seqNo < this.pagesInPrevSegments + this.maxPages) {
                return 0;
            }
            return 1;
        }

        public int pageIndex(int seqNo) {
            return PageIdUtils.pageIndex(PageMemoryNoStoreImpl.this.fromSegmentIndex(this.idx, seqNo - this.pagesInPrevSegments));
        }
    }
}

