/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.management.tx.TxCommand;
import org.apache.ignite.internal.management.tx.TxCommandArg;
import org.apache.ignite.internal.management.tx.TxInfo;
import org.apache.ignite.internal.management.tx.TxInfoCommandArg;
import org.apache.ignite.internal.management.tx.TxKeyLockType;
import org.apache.ignite.internal.management.tx.TxMappingType;
import org.apache.ignite.internal.management.tx.TxTaskResult;
import org.apache.ignite.internal.management.tx.TxVerboseInfo;
import org.apache.ignite.internal.management.tx.TxVerboseKey;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class TxTask
extends VisorMultiNodeTask<TxCommand.AbstractTxCommandArg, Map<ClusterNode, TxTaskResult>, TxTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<TxCommand.AbstractTxCommandArg, TxTaskResult> job(TxCommand.AbstractTxCommandArg arg) {
        return new TxJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<TxCommand.AbstractTxCommandArg> arg) {
        if (this.taskArg instanceof TxCommandArg) {
            TxCommandArg taskArg = (TxCommandArg)arg.getArgument();
            if (!F.isEmpty(taskArg.nodes())) {
                final HashSet<String> consistentIds = new HashSet<String>(Arrays.asList(taskArg.nodes()));
                return F.transform(this.ignite.cluster().forPredicate(new IgnitePredicate<ClusterNode>(){

                    @Override
                    public boolean apply(ClusterNode node) {
                        return consistentIds.contains(node.consistentId().toString());
                    }
                }).nodes(), new IgniteClosure<ClusterNode, UUID>(){

                    @Override
                    public UUID apply(ClusterNode node) {
                        return node.id();
                    }
                });
            }
            if (taskArg.servers()) {
                return F.transform(this.ignite.cluster().forServers().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                    @Override
                    public UUID apply(ClusterNode node) {
                        return node.id();
                    }
                });
            }
            if (taskArg.clients()) {
                return F.transform(this.ignite.cluster().forClients().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                    @Override
                    public UUID apply(ClusterNode node) {
                        return node.id();
                    }
                });
            }
        }
        return F.transform(this.ignite.cluster().nodes(), new IgniteClosure<ClusterNode, UUID>(){

            @Override
            public UUID apply(ClusterNode node) {
                return node.id();
            }
        });
    }

    @Override
    @Nullable
    protected Map<ClusterNode, TxTaskResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        return TxTask.reduce0(results, this.taskArg instanceof TxInfoCommandArg);
    }

    public static Map<ClusterNode, TxTaskResult> reduce0(List<ComputeJobResult> results, boolean detailedInfo) {
        TreeMap<ClusterNode, TxTaskResult> mapRes = new TreeMap<ClusterNode, TxTaskResult>();
        HashMap<UUID, ClusterNode> nodeMap = new HashMap<UUID, ClusterNode>();
        for (ComputeJobResult computeJobResult : results) {
            TxTaskResult data = (TxTaskResult)computeJobResult.getData();
            if (data == null || data.getInfos().isEmpty()) continue;
            mapRes.put(computeJobResult.getNode(), data);
            nodeMap.put(computeJobResult.getNode().id(), computeJobResult.getNode());
        }
        if (!detailedInfo) {
            for (TxTaskResult txTaskResult : mapRes.values()) {
                List<TxInfo> infos = txTaskResult.getInfos();
                Iterator<TxInfo> it = infos.iterator();
                while (it.hasNext()) {
                    TxTaskResult res0;
                    UUID nearNodeId;
                    ClusterNode node;
                    TxInfo info = it.next();
                    if (info.getXid().equals(info.getNearXid()) || (node = (ClusterNode)nodeMap.get(nearNodeId = info.getMasterNodeIds().iterator().next())) == null || (res0 = (TxTaskResult)mapRes.get(node)) == null) continue;
                    boolean exists = false;
                    for (TxInfo txInfo : res0.getInfos()) {
                        if (!txInfo.getXid().equals(info.getNearXid())) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) continue;
                    it.remove();
                }
            }
        }
        return mapRes;
    }

    private static TxVerboseInfo createVerboseInfo(IgniteEx ignite, IgniteInternalTx locTx) {
        TxVerboseInfo res = new TxVerboseInfo();
        res.nearXidVersion(locTx.nearXidVersion());
        HashMap<Integer, String> usedCaches = new HashMap<Integer, String>();
        HashMap<Integer, String> usedCacheGroups = new HashMap<Integer, String>();
        ClusterNode locNode = ignite.context().discovery().localNode();
        res.localNodeId(locNode.id());
        res.localNodeConsistentId(locNode.consistentId());
        if (locTx instanceof GridNearTxLocal) {
            IgniteTxMappings mappings = ((GridNearTxLocal)locTx).mappings();
            ArrayList<IgniteTxEntry> nearOnlyEntries = new ArrayList<IgniteTxEntry>();
            ArrayList<IgniteTxEntry> locEntries = new ArrayList<IgniteTxEntry>();
            for (GridDistributedTxMapping mapping : mappings.mappings()) {
                if (F.eqNodes(mapping.primary(), locNode)) {
                    locEntries.addAll(mapping.entries());
                    continue;
                }
                nearOnlyEntries.addAll(mapping.entries());
            }
            res.nearNodeId(locNode.id());
            res.nearNodeConsistentId(locNode.consistentId());
            res.txMappingType(TxMappingType.NEAR);
            List<TxVerboseKey> nearOnlyTxKeys = TxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, nearOnlyEntries, true);
            List<TxVerboseKey> locTxKeys = TxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locEntries, false);
            res.nearOnlyTxKeys(nearOnlyTxKeys);
            res.localTxKeys(locTxKeys);
        } else if (locTx instanceof GridDhtTxLocal) {
            UUID nearNodeId = locTx.masterNodeIds().iterator().next();
            DiscoCache discoCache = ignite.context().discovery().discoCache(locTx.topologyVersion());
            if (discoCache == null) {
                discoCache = ignite.context().discovery().discoCache();
            }
            ClusterNode nearNode = discoCache.node(nearNodeId);
            res.nearNodeId(nearNodeId);
            res.nearNodeConsistentId(nearNode.consistentId());
            res.txMappingType(TxMappingType.DHT);
            res.localTxKeys(TxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locTx.allEntries(), false));
        } else if (locTx instanceof GridDhtTxRemote) {
            Iterator<UUID> masterNodesIter = locTx.masterNodeIds().iterator();
            UUID nearNodeId = masterNodesIter.next();
            UUID dhtNodeId = masterNodesIter.next();
            DiscoCache discoCache = ignite.context().discovery().discoCache(locTx.topologyVersion());
            if (discoCache == null) {
                discoCache = ignite.context().discovery().discoCache();
            }
            ClusterNode nearNode = discoCache.node(nearNodeId);
            ClusterNode dhtNode = discoCache.node(dhtNodeId);
            res.nearNodeId(nearNodeId);
            res.nearNodeConsistentId(nearNode.consistentId());
            res.txMappingType(TxMappingType.REMOTE);
            res.dhtNodeId(dhtNodeId);
            res.dhtNodeConsistentId(dhtNode.consistentId());
            res.localTxKeys(TxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locTx.allEntries(), false));
        }
        res.usedCaches(usedCaches);
        res.usedCacheGroups(usedCacheGroups);
        return res;
    }

    private static List<TxVerboseKey> fetchTxEntriesAndFillUsedCaches(IgniteEx ignite, IgniteInternalTx locTx, Map<Integer, String> usedCaches, Map<Integer, String> usedCacheGroups, Collection<IgniteTxEntry> locEntries, boolean skipLocksCheck) {
        ArrayList<TxVerboseKey> locTxKeys = new ArrayList<TxVerboseKey>();
        for (IgniteTxEntry txEntry : locEntries) {
            GridCacheContext cacheCtx = ignite.context().cache().context().cacheContext(txEntry.cacheId());
            usedCaches.put(cacheCtx.cacheId(), cacheCtx.name());
            usedCacheGroups.put(cacheCtx.groupId(), cacheCtx.group().cacheOrGroupName());
            TxKeyLockType keyLockType = TxKeyLockType.NO_LOCK;
            GridCacheVersion ownerVer = null;
            if (!skipLocksCheck) {
                Collection<GridCacheMvccCandidate> locCandidates;
                GridCacheEntryEx entryEx = cacheCtx.cache().entryEx(txEntry.key(), locTx.topologyVersion());
                try {
                    locCandidates = entryEx.localCandidates(new GridCacheVersion[0]);
                }
                catch (GridCacheEntryRemovedException ignored) {
                    U.warn(ignite.log(), "Failed to process TX key: entry was already removed: " + txEntry.txKey());
                    continue;
                }
                boolean owner = false;
                boolean present = false;
                for (GridCacheMvccCandidate mvccCandidate : locCandidates) {
                    if (mvccCandidate.owner()) {
                        ownerVer = mvccCandidate.version();
                    }
                    if (!locTx.xidVersion().equals(mvccCandidate.version())) continue;
                    present = true;
                    if (!mvccCandidate.owner()) continue;
                    owner = true;
                }
                keyLockType = present ? (owner ? TxKeyLockType.OWNS_LOCK : TxKeyLockType.AWAITS_LOCK) : TxKeyLockType.NO_LOCK;
            }
            TxVerboseKey txVerboseKey = new TxVerboseKey(txEntry.txKey().toString(), keyLockType, ownerVer, txEntry.isRead());
            locTxKeys.add(txVerboseKey);
        }
        return locTxKeys;
    }

    private static class RemoteKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private RemoteKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            IgniteTxRemoteEx remote = (IgniteTxRemoteEx)tx;
            if (tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED) {
                return new GridFinishedFuture<IgniteInternalTx>();
            }
            if (tx.state() == TransactionState.PREPARED) {
                remote.doneRemote(tx.xidVersion(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            }
            return tx.rollbackAsync();
        }
    }

    private static class LocalKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private LocalKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            return tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED ? new GridFinishedFuture<IgniteInternalTx>() : ((GridDhtTxLocal)tx).rollbackDhtLocalAsync();
        }
    }

    private static class NearKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private NearKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            return tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED ? new GridFinishedFuture<IgniteInternalTx>() : ((GridNearTxLocal)tx).rollbackNearTxLocalAsync(false, false);
        }
    }

    private static interface TxKillClosure
    extends IgniteBiClosure<IgniteInternalTx, IgniteTxManager, IgniteInternalFuture<IgniteInternalTx>> {
    }

    private static class TxSizeComparator
    implements Comparator<TxInfo> {
        public static final TxSizeComparator INSTANCE = new TxSizeComparator();

        private TxSizeComparator() {
        }

        @Override
        public int compare(TxInfo o1, TxInfo o2) {
            return Long.compare(o2.getSize(), o1.getSize());
        }
    }

    private static class TxDurationComparator
    implements Comparator<TxInfo> {
        public static final TxDurationComparator INSTANCE = new TxDurationComparator();

        private TxDurationComparator() {
        }

        @Override
        public int compare(TxInfo o1, TxInfo o2) {
            return Long.compare(o2.getDuration(), o1.getDuration());
        }
    }

    private static class TxStartTimeComparator
    implements Comparator<TxInfo> {
        public static final TxStartTimeComparator INSTANCE = new TxStartTimeComparator();

        private TxStartTimeComparator() {
        }

        @Override
        public int compare(TxInfo o1, TxInfo o2) {
            return Long.compare(o2.getStartTime(), o1.getStartTime());
        }
    }

    public static class TxJob
    extends VisorJob<TxCommand.AbstractTxCommandArg, TxTaskResult> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_LIMIT = 50;
        private static final TxKillClosure NEAR_KILL_CLOSURE = new NearKillClosure();
        private static final TxKillClosure LOCAL_KILL_CLOSURE = new LocalKillClosure();
        private static final TxKillClosure REMOTE_KILL_CLOSURE = new RemoteKillClosure();

        TxJob(TxCommand.AbstractTxCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected TxTaskResult run(@Nullable TxCommand.AbstractTxCommandArg arg) throws IgniteException {
            if (arg instanceof TxCommandArg) {
                return TxJob.run(this.ignite, (TxCommandArg)arg, null);
            }
            return TxJob.run(this.ignite, new TxCommandArg(), (TxInfoCommandArg)arg);
        }

        public static TxTaskResult run(IgniteEx ignite, TxCommandArg arg, @Nullable TxInfoCommandArg infoArg) {
            if (arg == null) {
                return new TxTaskResult(Collections.emptyList());
            }
            IgniteTxManager tm = ignite.context().cache().context().tm();
            Collection<IgniteInternalTx> transactions = tm.activeTransactions();
            ArrayList<TxInfo> infos = new ArrayList<TxInfo>();
            int limit = arg.limit() == null ? 50 : arg.limit();
            Pattern lbMatch = null;
            if (arg.label() != null) {
                try {
                    lbMatch = Pattern.compile(arg.label());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            for (IgniteInternalTx locTx : transactions) {
                IgniteTxAdapter locTx0;
                boolean skip;
                if (infoArg != null && !Objects.equals(infoArg.gridCacheVersion(), locTx.nearXidVersion()) || arg.xid() != null && !locTx.xid().toString().equals(arg.xid())) continue;
                long duration = U.currentTimeMillis() - locTx.startTime();
                if (arg.minDuration() != null && duration < arg.minDuration()) continue;
                String lb = null;
                int size = 0;
                ArrayList<UUID> mappings = null;
                TxKillClosure killClo = null;
                boolean bl = skip = arg.minSize() != null || lbMatch != null;
                if (locTx instanceof GridNearTxLocal) {
                    locTx0 = (GridNearTxLocal)locTx;
                    lb = ((GridNearTxLocal)locTx0).label();
                    if (lbMatch != null && !lbMatch.matcher(lb == null ? "null" : lb).matches()) continue;
                    mappings = new ArrayList<UUID>();
                    if (((GridNearTxLocal)locTx0).mappings() != null) {
                        IgniteTxMappings txMappings = ((GridNearTxLocal)locTx0).mappings();
                        for (GridDistributedTxMapping mapping : txMappings.single() ? Collections.singleton(txMappings.singleMapping()) : txMappings.mappings()) {
                            if (mapping == null) continue;
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    if (arg.minSize() != null && size < arg.minSize()) continue;
                    killClo = NEAR_KILL_CLOSURE;
                } else if (locTx instanceof GridDhtTxLocal) {
                    Map nearMap;
                    if (skip) continue;
                    locTx0 = (GridDhtTxLocal)locTx;
                    Map dhtMap = (Map)U.field(locTx0, "dhtMap");
                    mappings = new ArrayList();
                    if (dhtMap != null) {
                        for (GridDistributedTxMapping mapping : dhtMap.values()) {
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    if ((nearMap = (Map)U.field(locTx, "nearMap")) != null) {
                        for (GridDistributedTxMapping mapping : nearMap.values()) {
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    killClo = LOCAL_KILL_CLOSURE;
                } else if (locTx instanceof GridDhtTxRemote) {
                    if (skip) continue;
                    locTx0 = (GridDhtTxRemote)locTx;
                    size = ((GridDistributedTxRemoteAdapter)locTx0).readMap().size() + locTx.writeMap().size();
                    killClo = REMOTE_KILL_CLOSURE;
                }
                TxVerboseInfo verboseInfo = infoArg != null ? TxTask.createVerboseInfo(ignite, locTx) : null;
                infos.add(new TxInfo(locTx.xid(), locTx.startTime(), duration, locTx.isolation(), locTx.concurrency(), locTx.timeout(), lb, mappings, locTx.state(), size, locTx.nearXidVersion().asIgniteUuid(), locTx.masterNodeIds(), locTx.topologyVersionSnapshot(), verboseInfo));
                if (arg.kill()) {
                    killClo.apply(locTx, tm);
                }
                if (infos.size() != limit) continue;
                break;
            }
            if (infoArg != null && infos.isEmpty()) {
                Boolean completed;
                Boolean bl = completed = infoArg == null ? null : tm.peekCompletedVersionsHistory(infoArg.gridCacheVersion());
                if (completed != null) {
                    if (Boolean.TRUE.equals(completed)) {
                        infos.add(new TxInfo(infoArg.gridCacheVersion().asIgniteUuid(), TransactionState.COMMITTED));
                    } else if (Boolean.FALSE.equals(completed)) {
                        infos.add(new TxInfo(infoArg.gridCacheVersion().asIgniteUuid(), TransactionState.ROLLED_BACK));
                    }
                }
            }
            Comparator<TxInfo> comp = TxDurationComparator.INSTANCE;
            if (arg.order() != null) {
                switch (arg.order()) {
                    case DURATION: {
                        comp = TxDurationComparator.INSTANCE;
                        break;
                    }
                    case SIZE: {
                        comp = TxSizeComparator.INSTANCE;
                        break;
                    }
                    case START_TIME: {
                        comp = TxStartTimeComparator.INSTANCE;
                        break;
                    }
                }
            }
            Collections.sort(infos, comp);
            return new TxTaskResult(infos);
        }
    }
}

