/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.PreparableCommand;
import org.apache.ignite.internal.management.cache.CacheDestroyCommandArg;
import org.apache.ignite.internal.management.cache.CacheStopTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheDestroyCommand
implements ComputeCommand<CacheDestroyCommandArg, Void>,
PreparableCommand<CacheDestroyCommandArg, Void> {
    public static final String CONFIRM_MSG = "Warning! The command will destroy %d caches: %s.\nIf you continue, the cache data will be impossible to recover.";
    public static final String NOOP_MSG = "No user-created caches exist.";
    public static final String RESULT_MSG = "The following caches have been stopped: %s.";

    @Override
    public String description() {
        return "Permanently destroy specified caches";
    }

    @Override
    public boolean prepare(@Nullable GridClient cli, @Nullable Ignite ignite, CacheDestroyCommandArg arg, Consumer<String> printer) throws GridClientException {
        if (arg.destroyAllCaches()) {
            TreeSet<String> caches = new TreeSet<String>();
            if (cli != null) {
                for (GridClientNode node : cli.compute().nodes(GridClientNode::connectable)) {
                    caches.addAll(node.caches().keySet());
                }
            } else {
                caches.addAll(ignite.cacheNames());
            }
            arg.caches(caches.toArray(U.EMPTY_STRS));
        }
        if (F.isEmpty(arg.caches())) {
            printer.accept(NOOP_MSG);
            return false;
        }
        return true;
    }

    @Override
    public String confirmationPrompt(CacheDestroyCommandArg arg) {
        return String.format(CONFIRM_MSG, arg.caches().length, S.joinToString(Arrays.asList(arg.caches()), ", ", "..", 80, 0));
    }

    @Override
    public void printResult(CacheDestroyCommandArg arg, Void res, Consumer<String> printer) {
        printer.accept(String.format(RESULT_MSG, F.concat(Arrays.asList(arg.caches()), ", ")));
    }

    @Override
    public Class<CacheDestroyCommandArg> argClass() {
        return CacheDestroyCommandArg.class;
    }

    @Override
    public Class taskClass() {
        return CacheStopTask.class;
    }
}

