/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.Security;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.apache.ignite.IgniteCache;

public class GridPublishFile
implements Runnable {
    private Thread thread = null;
    private IgniteCache igniteCache = null;
    private String cacheName = null;
    private String hostname = null;
    private String modelFilePath = null;
    private String missionPromptFolder = null;
    private String cipherMessage = null;
    private String keyStorePass = null;
    private String locationStart;
    private Properties crcLocalDocs = new Properties();

    public GridPublishFile(String missionPromptFolder) {
        this.missionPromptFolder = missionPromptFolder;
    }

    public GridPublishFile(String locationStart, IgniteCache igniteCache, String cacheName, String hostname, String modelFilePath, String missionPromptFolder, String cipherMessage, String keyStorePass) {
        this.locationStart = locationStart;
        this.igniteCache = igniteCache;
        this.cacheName = cacheName;
        this.hostname = hostname;
        this.modelFilePath = modelFilePath;
        this.missionPromptFolder = missionPromptFolder;
        this.cipherMessage = cipherMessage;
        this.keyStorePass = keyStorePass;
    }

    public synchronized String getFirstFileName(String folder) {
        String[] lQuestionsFolder;
        String data = "";
        this.createFolderIfNotExists(folder);
        File fQuestionsFolder = new File(folder);
        for (String sFile : lQuestionsFolder = fQuestionsFolder.list()) {
            if (!sFile.endsWith(".txt")) continue;
            data = sFile;
            break;
        }
        return data;
    }

    public List getLocalDocsList(String folder) {
        String[] lQuestionsFolder;
        try {
            FileInputStream fis = new FileInputStream("crcLocalDocs.properties");
            this.crcLocalDocs.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<String> data = new ArrayList<String>();
        this.createFolderIfNotExists(folder);
        File fQuestionsFolder = new File(folder);
        for (String sFile : lQuestionsFolder = fQuestionsFolder.list()) {
            if (sFile.toLowerCase().endsWith(".pdf") || sFile.toLowerCase().endsWith(".txt")) {
                String filePath = "/" + folder + "/" + sFile;
                data.add(filePath);
                String localFile = filePath.replaceAll(this.missionPromptFolder + "/", "");
                CRC32 crc32 = new CRC32();
                crc32.update(localFile.getBytes());
                long crcValue = crc32.getValue();
                if (this.crcLocalDocs.getProperty("" + crcValue) != null) continue;
                this.crcLocalDocs.setProperty("" + crcValue, localFile);
                continue;
            }
            String subFolder = folder + "/" + sFile;
            File fDir = new File(subFolder);
            if (!fDir.isDirectory()) continue;
            data.addAll(this.getLocalDocsList(subFolder));
        }
        try {
            FileOutputStream fos = new FileOutputStream("crcLocalDocs.properties");
            this.crcLocalDocs.store(fos, "LocalDocs");
            fos.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return data;
    }

    public String readFile(String questionFolder, String file) {
        String data = "";
        if (file.length() > 3) {
            try {
                File fFile = new File(questionFolder + "/" + file);
                if (fFile.exists()) {
                    FileInputStream fis = new FileInputStream(fFile);
                    String text = null;
                    DataInputStream dis = new DataInputStream(fis);
                    while ((text = dis.readLine()) != null) {
                        data = data + text;
                    }
                    fis.close();
                }
            }
            catch (Exception ex) {
                String sStep = "\nreadFile error: " + ex.toString();
                Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, sStep);
            }
        }
        return data;
    }

    public void createFolderIfNotExists(String folder) {
        File fQuestionsFolder = new File(folder);
        if (!fQuestionsFolder.exists()) {
            fQuestionsFolder.mkdirs();
        }
    }

    public synchronized boolean preProcessFile(String uuid, String questionsFolder, String questionFile, String questionsPreProcessFolder) {
        boolean status = false;
        try {
            this.createFolderIfNotExists(questionsPreProcessFolder);
            File fFile = new File(questionsFolder + "/" + questionFile);
            fFile.renameTo(new File(questionsPreProcessFolder + "/" + uuid + ".txt"));
            status = true;
        }
        catch (Exception e) {
            String sStep = "preProcessFile error: " + e.toString();
            Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, sStep);
        }
        return status;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String sQuestionsFolder = "questions";
        String sPreProcessedFolder = "questions_pre-processed";
        String sFile = this.getFirstFileName(sQuestionsFolder);
        String sQuestion = this.readFile(sQuestionsFolder, sFile);
        if (sQuestion.length() > 3) {
            long inicio = System.currentTimeMillis();
            String modelName = this.modelFilePath;
            if (modelName.contains("/")) {
                modelName = modelName.substring(modelName.lastIndexOf("/") + 1, modelName.length());
                modelName = modelName.substring(0, modelName.lastIndexOf("."));
            } else if (modelName.contains("\\")) {
                modelName = modelName.substring(modelName.lastIndexOf("\\") + 1, modelName.length());
                modelName = modelName.substring(0, modelName.lastIndexOf("."));
            }
            if (sFile.endsWith("].txt") && sFile.contains("[")) {
                FileInputStream fis = null;
                try {
                    String crc = sFile.substring(sFile.lastIndexOf("[") + 1, sFile.lastIndexOf("]"));
                    fis = new FileInputStream("crcLocalDocs.properties");
                    this.crcLocalDocs.load(fis);
                    fis.close();
                    String localDoc = this.crcLocalDocs.getProperty(crc);
                    String sFolder = this.missionPromptFolder;
                    if (sFolder.contains("\\")) {
                        sFolder = sFolder.replaceAll("\\\\", "/");
                    }
                    System.out.println("Encontre archivo automatizado: " + crc + ", automation doc: " + localDoc + ", sFolder=" + sFolder);
                    String automationDoc = this.readFile(sFolder, localDoc);
                    System.out.println("Encontre archivo automatizado: " + automationDoc);
                    sQuestion = automationDoc + sQuestion;
                }
                catch (Exception ex) {
                    Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            String uuid = inicio + "-" + modelName + "-" + this.hostname + "_" + this.locationStart.hashCode() + "-(" + sFile + ")";
            this.preProcessFile(uuid, sQuestionsFolder, sFile, sPreProcessedFolder);
            String sStep = "\r\nReady for publish in Grid: Internal id: " + inicio + "-" + modelName + "-" + this.hostname + "\r\nExternal id: " + sFile + "\r\nuuid :" + uuid + "\r\nQuestion:\r\n" + sQuestion;
            System.out.println(sStep);
            Properties pMessage = new Properties();
            pMessage.setProperty(uuid, sQuestion);
            if (this.cipherMessage.equals("true")) {
                try {
                    String publicKey;
                    String sKey = publicKey = Security.getPublicKeyFromKeystore(this.cacheName + ".pfx", this.keyStorePass, this.cacheName, "PKCS12");
                    if (sKey.lastIndexOf("==") != -1) {
                        sKey = sKey.substring(0, sKey.lastIndexOf("=="));
                        sKey = sKey.substring(sKey.length() - 32, sKey.length());
                        pMessage.setProperty(uuid, Security.encryptText(sKey, sQuestion));
                    }
                }
                catch (Exception publicKey) {
                    // empty catch block
                }
            }
            this.igniteCache.put((Object)uuid, (Object)pMessage);
            long fin = System.currentTimeMillis();
            sStep = "\r\nPublished in grid: " + uuid + ",Total time:" + (fin - inicio) + " ms";
            Logger.getLogger(GridPublishFile.class.getName()).log(Level.SEVERE, null, sStep);
        }
    }
}

