/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.DownloadModels;
import cl.mc3d.ai.GridPublishFile;
import cl.mc3d.ai.JProgressItem;
import cl.mc3d.ai.LLM;
import cl.mc3d.ai.ModelsInfo;
import cl.mc3d.ai.PubSubFiles;
import cl.mc3d.ai.Security;
import cl.mc3d.ai.TimerService;
import cl.mc3d.as4p.ui.ComboBox;
import cl.mc3d.as4p.ui.CommandButton;
import cl.mc3d.as4p.ui.DataTable;
import cl.mc3d.as4p.ui.Div;
import cl.mc3d.as4p.ui.InputText;
import cl.mc3d.as4p.ui.JTab;
import cl.mc3d.as4p.ui.OutputLabel;
import cl.mc3d.as4p.ui.SelectBooleanCheckbox;
import cl.mc3d.as4p.ui.Tree;
import cl.mc3d.as4p.ui.VDMutableTreeNode;
import com.sun.pdfview.PDFViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class Console
extends JFrame {
    private PubSubFiles pubSubFiles = null;
    private ModelsInfo modelsInfo;
    private HashMap<String, JTextPane> hWebView = new HashMap();
    private HashMap<String, JTextArea> hMessageArea = new HashMap();
    private HashMap<String, String> hPendingConversations = new HashMap();
    private InputText modelRepositoryTextField;
    private InputText modelTextField;
    private InputText modelPromptTemplateTextField;
    private InputText missionPromptFolderTextField = new InputText();
    private InputText cacheTextField;
    private ComboBox cacheLocalIpComboBox;
    private SelectBooleanCheckbox cipherMessageCheckBox;
    private JPasswordField keyStorePassTextField;
    private CommandButton testKeystore;
    private SelectBooleanCheckbox chatUICheckBox;
    private JToggleButton igniteControl;
    private JTextArea logTextArea;
    private String locationStart;
    private Properties properties = new Properties();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private TimerService timerService;
    private DefaultTableModel dtmGridStatus = null;
    private String theme = "midnight";
    private VDMutableTreeNode dmtMissions = null;
    private Tree jtreeMissions = null;

    public Console(final TimerService timerService) {
        this.setTitle("MC3D AI - v1.2.1");
        this.timerService = timerService;
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/resources/mc3d-icon.png"));
        this.setIconImage(icon.getImage());
        this.locationStart = System.getProperty("user.dir");
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                SwingUtilities.updateComponentTreeUI(this);
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("Error manejado" + ex.toString());
        }
        this.setDefaultCloseOperation(3);
        this.setSize(800, 600);
        boolean chatSession = false;
        CommandButton newChatButton = new CommandButton("New Chat");
        newChatButton.setTheme(this.theme, false);
        newChatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.createTabPane("Chat: " + Console.this.tabbedPane.getTabCount(), Console.this.tabbedPane);
            }
        });
        this.igniteControl = new JToggleButton("Ignite the cluster");
        this.igniteControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Console.this.igniteControl.isSelected()) {
                    timerService.stop();
                    timerService.config();
                    timerService.start();
                    Console.this.igniteControl.setBackground(Color.yellow);
                    System.out.println("Cluster on");
                } else {
                    System.out.println("Cluster off");
                    Console.this.igniteControl.setBackground(Color.red);
                    Console.this.igniteControl.setText("Ignite the cluster");
                    timerService.stop();
                }
            }
        });
        ImageIcon mc3dIcon = new ImageIcon(this.getClass().getResource("/resources/mc3d_logo.png"));
        CommandButton jbMc3dLogo = new CommandButton();
        jbMc3dLogo.setIcon((Icon)mc3dIcon);
        jbMc3dLogo.setTheme(this.theme, false);
        jbMc3dLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon qrIcon = new ImageIcon(this.getClass().getResource("/resources/mc3d-qr.png"));
                Div jpQR = new Div("MC3D AI", null, (LayoutManager)new BorderLayout());
                jpQR.setTheme(Console.this.theme, false);
                CommandButton jbMc3dQR = new CommandButton();
                jbMc3dQR.setIcon((Icon)qrIcon);
                jpQR.add("Center", (Component)jbMc3dQR);
                JOptionPane.showMessageDialog(Console.this, jpQR);
            }
        });
        Div leftPanel = new Div();
        leftPanel.setTheme(this.theme, false);
        leftPanel.setLayout((LayoutManager)new GridLayout(4, 1));
        leftPanel.add((Component)newChatButton);
        leftPanel.add((Component)this.igniteControl);
        leftPanel.add((Component)jbMc3dLogo);
        Div compressleftPanel = new Div();
        compressleftPanel.setTheme(this.theme, false);
        compressleftPanel.setLayout((LayoutManager)new BorderLayout());
        compressleftPanel.add("North", (Component)leftPanel);
        this.dmtMissions = new VDMutableTreeNode("Missions Docs");
        this.dmtMissions.setName("Missions docs");
        this.jtreeMissions = new Tree((DefaultMutableTreeNode)this.dmtMissions);
        this.jtreeMissions.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTree jtree = (JTree)e.getSource();
                final VDMutableTreeNode vdmMissions = (VDMutableTreeNode)jtree.getLastSelectedPathComponent();
                JPopupMenu popupmenu = new JPopupMenu("Propiedades");
                String dato = "";
                if ((e.getButton() == 1 || e.getButton() == 3) && vdmMissions != null) {
                    int iPath = vdmMissions.getUserObjectPath().length;
                    for (int i = 1; i < iPath; ++i) {
                        dato = dato + "/" + vdmMissions.getUserObjectPath()[i];
                    }
                    if (e.getButton() == 3) {
                        final String textFile = dato;
                        if (dato.toLowerCase().endsWith(".pdf") || dato.toLowerCase().endsWith(".txt")) {
                            JMenuItem openText = new JMenuItem("Open");
                            openText.setName("open");
                            popupmenu.add(openText);
                            openText.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Console.this.createTabPane(textFile, Console.this.tabbedPane);
                                    Console.this.tabbedPane.setSelectedIndex(Console.this.tabbedPane.getTabCount() - 1);
                                }
                            });
                            if (dato.toLowerCase().endsWith(".txt")) {
                                JMenuItem tokenFile = new JMenuItem("Token");
                                tokenFile.setName("token");
                                popupmenu.add(tokenFile);
                                tokenFile.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        CRC32 crc32 = new CRC32();
                                        crc32.update(textFile.getBytes());
                                        long crcValue = crc32.getValue();
                                        String token = JOptionPane.showInputDialog("The token must be used for Chat with files interchange, use: <fileName>[<tokenid>].txt, ie: test[12345].txt", (Object)crcValue);
                                    }
                                });
                            }
                        } else {
                            JMenu addText = new JMenu("Add");
                            addText.setName("add");
                            JMenuItem addFile = new JMenuItem("File");
                            addFile.setName("addFile");
                            addText.add(addFile);
                            addFile.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String sFolder;
                                    String newName = JOptionPane.showInputDialog(Console.this, (Object)"Enter file name");
                                    if (!newName.toLowerCase().endsWith(".txt")) {
                                        newName = newName + ".txt";
                                    }
                                    if ((sFolder = Console.this.missionPromptFolderTextField.getText() + "/" + newName).contains("\\")) {
                                        sFolder = sFolder.replaceAll("\\\\", "/");
                                    }
                                    File f = new File(sFolder);
                                    System.out.println("sFolder: " + sFolder);
                                    if (!f.exists()) {
                                        try {
                                            f.createNewFile();
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                }
                            });
                            JMenuItem addDirectory = new JMenuItem("Directory");
                            addDirectory.setName("addDirectory");
                            addText.add(addDirectory);
                            addDirectory.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String newName = JOptionPane.showInputDialog(Console.this, (Object)"Enter directory name");
                                    String sFolder = Console.this.missionPromptFolderTextField.getText() + "/" + newName;
                                    if (sFolder.contains("\\")) {
                                        sFolder = sFolder.replaceAll("\\\\", "/");
                                    }
                                    File f = new File(sFolder);
                                    System.out.println("sFolder: " + sFolder);
                                    if (!f.exists()) {
                                        try {
                                            f.mkdirs();
                                            File l = new File(sFolder + "/changeme.txt");
                                            l.createNewFile();
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                }
                            });
                            popupmenu.add(addText);
                        }
                        if (iPath > 1) {
                            JMenuItem renameText = new JMenuItem("Rename");
                            renameText.setName("rename");
                            popupmenu.add(renameText);
                            renameText.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String newName;
                                    String oldTitle = textFile;
                                    if (oldTitle.startsWith("/")) {
                                        oldTitle = oldTitle.substring(1, oldTitle.length());
                                    }
                                    if ((newName = JOptionPane.showInputDialog(Console.this, (Object)("Enter new name for: " + oldTitle))) != null && !newName.isEmpty()) {
                                        if (newName.length() > 1) {
                                            String sFolder = Console.this.missionPromptFolderTextField.getText();
                                            File f = new File(sFolder + "/" + oldTitle);
                                            if (f.exists()) {
                                                String sNewFolder = sFolder + "/" + newName;
                                                if (f.isDirectory()) {
                                                    File f2 = new File(sNewFolder);
                                                    if (!f2.exists()) {
                                                        f.renameTo(f2);
                                                    } else {
                                                        JOptionPane.showMessageDialog(Console.this, "Please choice other name");
                                                    }
                                                } else {
                                                    String extension = oldTitle.substring(oldTitle.lastIndexOf("."), oldTitle.length());
                                                    if (!(newName = newName.toLowerCase().replaceAll(extension, "")).toLowerCase().endsWith(extension)) {
                                                        if (sFolder.contains("\\")) {
                                                            sFolder = sFolder.replaceAll("\\\\", "/");
                                                        }
                                                        newName = textFile.replaceAll(oldTitle.substring(oldTitle.lastIndexOf("/") + 1, oldTitle.length()), newName);
                                                        sNewFolder = sFolder + "/" + newName + extension;
                                                        File f2 = new File(sNewFolder);
                                                        if (!f2.exists()) {
                                                            f.renameTo(f2);
                                                            vdmMissions.removeFromParent();
                                                        } else {
                                                            JOptionPane.showMessageDialog(Console.this, "Please choice other name");
                                                        }
                                                        System.out.println("oldTitle: " + oldTitle);
                                                        System.out.println("sNewFolder: " + sNewFolder);
                                                        System.out.println("textFile: " + textFile);
                                                    }
                                                }
                                            }
                                        } else {
                                            JOptionPane.showMessageDialog(Console.this, "Please choice other name");
                                        }
                                    }
                                }
                            });
                            JMenuItem deleteText = new JMenuItem("Delete");
                            deleteText.setName("delete");
                            popupmenu.add(deleteText);
                            deleteText.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    int option;
                                    String sFolder;
                                    String delete = textFile;
                                    if (delete.startsWith("/")) {
                                        delete = delete.substring(1, delete.length());
                                    }
                                    if ((sFolder = Console.this.missionPromptFolderTextField.getText() + "/" + delete).contains("\\")) {
                                        sFolder = sFolder.replaceAll("\\\\", "/");
                                    }
                                    if ((option = JOptionPane.showConfirmDialog(Console.this, "Delete: " + delete)) == 0) {
                                        File f = new File(sFolder);
                                        if (f.isDirectory()) {
                                            String[] childs;
                                            for (String leaf : childs = f.list()) {
                                                File l = new File(sFolder + "/" + leaf);
                                                l.delete();
                                            }
                                        }
                                        f.delete();
                                        vdmMissions.removeFromParent();
                                    }
                                    System.out.println("delete: " + sFolder + ", option: " + option);
                                }
                            });
                        }
                        popupmenu.setVisible(false);
                        popupmenu.show(jtree, e.getX(), 30);
                        popupmenu.setVisible(true);
                    }
                    if (dato.toLowerCase().endsWith(".pdf") || dato.toLowerCase().endsWith(".txt")) {
                        dato = dato + "\"";
                        if (e.getClickCount() == 2) {
                            int index = Console.this.tabbedPane.getSelectedIndex();
                            JTab tab = (JTab)Console.this.tabbedPane.getComponent(index);
                            System.out.println("Tab active: " + index + ", name: " + tab.getId());
                            if (tab.getId().toLowerCase().equals("setup") || tab.getId().toLowerCase().equals("status")) {
                                JOptionPane.showMessageDialog(Console.this, "Please select a Chat Tab!");
                            } else {
                                ((JTextArea)Console.this.hMessageArea.get(tab.getId())).append(" localDoc=\"" + dato);
                                Console.this.jtreeMissions.removeSelectionPath(Console.this.jtreeMissions.getAnchorSelectionPath());
                            }
                        }
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.jtreeMissions.setDragEnabled(true);
        this.jtreeMissions.setDropMode(DropMode.ON_OR_INSERT);
        this.jtreeMissions.setTheme(this.theme);
        JScrollPane jsMissions = new JScrollPane((Component)this.jtreeMissions);
        Timer t = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Console.this.missionPromptFolderTextField.getText().length() > 0) {
                    Console.this.listDocs(Console.this.missionPromptFolderTextField.getText(), Console.this.dmtMissions, Console.this.jtreeMissions);
                }
            }
        });
        t.start();
        t.setRepeats(true);
        t.setDelay(1000);
        compressleftPanel.add("Center", (Component)jsMissions);
        this.getContentPane().add((Component)compressleftPanel, "West");
        this.createTabPane("Setup", this.tabbedPane);
        this.createTabPane("Status", this.tabbedPane);
        this.createTabPane("Principal", this.tabbedPane);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    String newName;
                    int index = Console.this.tabbedPane.getSelectedIndex();
                    String oldTitle = Console.this.tabbedPane.getTitleAt(index);
                    if (!(oldTitle.equals("Principal") || oldTitle.equals("Status") || oldTitle.equals("Setup") || (newName = JOptionPane.showInputDialog(Console.this, (Object)"Enter new name for Tab:")) == null || newName.isEmpty())) {
                        if (!(newName.toLowerCase().equals("principal") || newName.toLowerCase().equals("status") || newName.toLowerCase().equals("setup"))) {
                            Console.this.tabbedPane.setTitleAt(index, newName);
                        } else {
                            JOptionPane.showMessageDialog(Console.this, "Please choice other name");
                        }
                    }
                }
            }
        });
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            if (this.chatUICheckBox.isSelected()) {
                try {
                    String sLocation = "";
                    List lIdResponses = this.pubSubFiles.getResponseId(sLocation);
                    for (String id : lIdResponses) {
                        String sResponse;
                        String externalId;
                        if (!id.contains("WV")) continue;
                        LinkedHashMap message = this.pubSubFiles.getResponse(sLocation, id);
                        String modelName = id;
                        if (modelName.contains("-(")) {
                            modelName = modelName.substring(modelName.indexOf("-") + 1, modelName.lastIndexOf("-("));
                            modelName = modelName.substring(0, modelName.lastIndexOf("-"));
                        }
                        if ((externalId = id).contains("-(")) {
                            if ((externalId = externalId.substring(externalId.indexOf("-(") + 2, externalId.length())).contains(".")) {
                                externalId = externalId.substring(0, externalId.indexOf("."));
                            }
                            if (externalId.contains("-")) {
                                externalId = externalId.substring(0, externalId.indexOf("-"));
                            }
                        }
                        if ((sResponse = "" + message.get("data")).length() <= 3) continue;
                        this.addJeMensajes("" + new Date(), externalId, modelName, sResponse);
                        this.pubSubFiles.deleteResponse(sLocation, id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
        this.loadProperties("mc3d-ai.properties");
        this.setVisible(true);
    }

    public JToggleButton getIgniteControl() {
        return this.igniteControl;
    }

    private void loadProperties(String sConfig) {
        try {
            FileInputStream input = new FileInputStream(sConfig);
            this.properties.load(input);
            input.close();
            this.modelRepositoryTextField.setText(this.properties.getProperty("modelRepository", "repository"));
            this.modelTextField.setText(this.properties.getProperty("model", ""));
            this.modelPromptTemplateTextField.setText(this.properties.getProperty("modelPromptTemplate", ""));
            this.missionPromptFolderTextField.setText(this.properties.getProperty("missionPromptFolder", ""));
            this.cacheTextField.setText(this.properties.getProperty("cache", ""));
            this.cacheLocalIpComboBox.setSelectedItem((Object)this.properties.getProperty("cacheLocalIp", ""));
            this.cipherMessageCheckBox.setSelected(Boolean.parseBoolean(this.properties.getProperty("cipherMessage", "false")));
            this.keyStorePassTextField.setText(this.properties.getProperty("keyStorePass", ""));
            try {
                Security.getPublicKeyFromKeystore(this.cacheTextField.getText() + ".pfx", this.keyStorePassTextField.getText(), this.cacheTextField.getText(), "PKCS12");
            }
            catch (Exception ex) {
                this.cipherMessageCheckBox.setSelected(false);
            }
            this.chatUICheckBox.setSelected(Boolean.parseBoolean(this.properties.getProperty("chatUI")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveFormInformation(String sConfig) {
        System.out.println("Properties: " + this.properties);
        try {
            this.properties.setProperty("modelRepository", this.modelRepositoryTextField.getText());
            this.properties.setProperty("model", this.modelTextField.getText());
            this.properties.setProperty("modelPromptTemplate", this.modelPromptTemplateTextField.getText());
            this.properties.setProperty("missionPromptFolder", this.missionPromptFolderTextField.getText());
            this.properties.setProperty("cache", this.cacheTextField.getText());
            this.properties.setProperty("cacheLocalIp", this.cacheLocalIpComboBox.getSelectedItem().toString());
            this.properties.setProperty("cipherMessage", String.valueOf(this.cipherMessageCheckBox.isSelected()));
            this.properties.setProperty("keyStorePass", this.keyStorePassTextField.getText());
            this.properties.setProperty("chatUI", String.valueOf(this.chatUICheckBox.isSelected()));
            FileOutputStream fos = new FileOutputStream(sConfig);
            this.properties.store(fos, "MC3D AI- configuration");
            fos.close();
            this.loadProperties(sConfig);
            this.igniteControl.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearForm() {
        this.modelRepositoryTextField.setText("");
        this.modelTextField.setText("");
        this.modelPromptTemplateTextField.setText("");
        this.missionPromptFolderTextField.setText("");
        this.cacheTextField.setText("");
        this.cacheLocalIpComboBox.setSelectedIndex(0);
        this.cipherMessageCheckBox.setSelected(false);
        this.keyStorePassTextField.setText("");
        this.chatUICheckBox.setSelected(true);
    }

    private void createTabPane(String title, JTabbedPane tabbedPane) {
        final Div mainPanel = new Div(null, null, (LayoutManager)new BorderLayout());
        mainPanel.setTheme(this.theme, false);
        JTab tab = new JTab(title, (JPanel)mainPanel);
        if (title.equals("Status")) {
            mainPanel.setName(title);
            tab.setId("Status");
            Vector<String> vGridStatusTitles = new Vector<String>();
            vGridStatusTitles.add("Name");
            vGridStatusTitles.add("IP");
            vGridStatusTitles.add("LLM");
            vGridStatusTitles.add("Last Access");
            this.dtmGridStatus = new DefaultTableModel(vGridStatusTitles, 0);
            DataTable dtGridStatus = new DataTable(this.dtmGridStatus);
            dtGridStatus.setTheme(this.theme);
            dtGridStatus.setShowVerticalLines(true);
            dtGridStatus.setShowHorizontalLines(true);
            dtGridStatus.getTableHeader().setReorderingAllowed(false);
            dtGridStatus.setAutoResizeMode(4);
            dtGridStatus.setSelectionMode(2);
            JScrollPane jsGeneral = new JScrollPane((Component)dtGridStatus);
            mainPanel.add((Component)jsGeneral, (Object)"Center");
            this.logTextArea = new JTextArea();
            this.logTextArea.setEditable(false);
            this.logTextArea.setRows(20);
            JScrollPane jslogTextArea = new JScrollPane(this.logTextArea);
            JPanel inputPanel = new JPanel(new BorderLayout());
            inputPanel.setOpaque(false);
            inputPanel.add((Component)jslogTextArea, "Center");
            CommandButton jbClear = new CommandButton("Clear Logs");
            jbClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.logTextArea.setText("");
                }
            });
            jbClear.setTheme(this.theme, false);
            inputPanel.add((Component)jbClear, "East");
            mainPanel.add((Component)inputPanel, (Object)"South");
        } else if (title.equals("Setup")) {
            tab.setId("Setup");
            final Div progressBarPanel = new Div();
            progressBarPanel.setTheme(this.theme, true);
            progressBarPanel.setOpaque(false);
            progressBarPanel.setLayout((LayoutManager)new BoxLayout((Container)progressBarPanel, 1));
            JScrollPane jsProgressBarPanel = new JScrollPane((Component)progressBarPanel);
            jsProgressBarPanel.setOpaque(false);
            jsProgressBarPanel.setPreferredSize(new Dimension(300, 20));
            Vector<String> vLLMListTitles = new Vector<String>();
            vLLMListTitles.add("Ranking");
            vLLMListTitles.add("Model");
            vLLMListTitles.add("Last Update");
            final DefaultTableModel dtmLLMList = new DefaultTableModel(vLLMListTitles, 0);
            final DataTable dtLLMList = new DataTable(dtmLLMList);
            dtLLMList.setTheme(this.theme);
            dtLLMList.setShowVerticalLines(true);
            dtLLMList.setShowHorizontalLines(true);
            dtLLMList.getTableHeader().setReorderingAllowed(false);
            dtLLMList.setAutoResizeMode(4);
            dtLLMList.setSelectionMode(2);
            final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(dtLLMList.getModel());
            dtLLMList.setRowSorter(sorter);
            Div setupLLMPanel = new Div(null, null, (LayoutManager)new FlowLayout());
            setupLLMPanel.setTheme(this.theme, false);
            CommandButton startDownloadListModels = new CommandButton("Get List of LLM from Hugging face");
            setupLLMPanel.add((Component)startDownloadListModels);
            startDownloadListModels.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.modelsInfo.start();
                }
            });
            final InputText field = new InputText();
            field.setPreferredSize(new Dimension(200, 30));
            setupLLMPanel.add((Component)field);
            mainPanel.add((Component)setupLLMPanel, (Object)"North");
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String text = field.getText();
                    if (text.trim().length() == 0) {
                        sorter.setRowFilter(null);
                    } else {
                        sorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    String text = field.getText();
                    if (text.trim().length() == 0) {
                        sorter.setRowFilter(null);
                    } else {
                        sorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            dtLLMList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = dtLLMList.convertRowIndexToModel(dtLLMList.getSelectedRow()) + 1;
                        int max = sorter.getViewRowCount();
                        System.out.println("Ranking id:" + index);
                        for (int position = 0; position < max; ++position) {
                            if (!dtLLMList.getValueAt(position, 0).toString().equals("" + index)) continue;
                            System.out.println("Encontrado en la posicion: " + position);
                            String sModel = "" + dtmLLMList.getValueAt(dtLLMList.convertRowIndexToModel(position), 1);
                            System.out.println("Encontrado en la sModel: " + sModel);
                            List<LLM> lListModelType = Console.this.modelsInfo.listModelType(sModel);
                            JComboBox<String> comboBox = new JComboBox<String>();
                            for (LLM llm : lListModelType) {
                                comboBox.addItem(llm.getName());
                            }
                            JPanel panel = new JPanel();
                            panel.add(new JLabel("Select LLM version:"));
                            panel.add(comboBox);
                            int result = JOptionPane.showConfirmDialog(Console.this, panel, "LLM Download", 2, -1);
                            if (result != 0) continue;
                            String sModelType = (String)comboBox.getSelectedItem();
                            DownloadModels downloadModels = new DownloadModels(Console.this.modelRepositoryTextField.getText(), sModel, sModelType);
                            int iListModelTypeSize = lListModelType.size();
                            String sSize = "";
                            for (int i = 1; i < iListModelTypeSize; ++i) {
                                if (!lListModelType.get(i).getName().equals(sModelType)) continue;
                                sSize = lListModelType.get(i).getSize();
                                break;
                            }
                            JProgressItem progressItem = new JProgressItem(Console.this.modelRepositoryTextField.getText(), sModel, sModelType, sSize);
                            progressBarPanel.add((Component)progressItem);
                            JOptionPane.showMessageDialog(Console.this, "Option selected: " + sModelType);
                            mainPanel.updateUI();
                            downloadModels.start();
                            break;
                        }
                    }
                }
            });
            JScrollPane jsGeneral = new JScrollPane((Component)dtLLMList);
            mainPanel.add((Component)jsGeneral, (Object)"Center");
            this.modelsInfo = new ModelsInfo(dtmLLMList);
            JPanel jpGroupSetup = new JPanel(new GridLayout(10, 3));
            jpGroupSetup.setOpaque(false);
            OutputLabel modelRepositoryLabel = new OutputLabel("Model repository:");
            modelRepositoryLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)modelRepositoryLabel);
            this.modelRepositoryTextField = new InputText();
            jpGroupSetup.add((Component)this.modelRepositoryTextField);
            CommandButton jbAssignRepository = new CommandButton("Assign Repository");
            jbAssignRepository.setTheme(this.theme, false);
            jpGroupSetup.add((Component)jbAssignRepository);
            jbAssignRepository.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(new File(Console.this.modelRepositoryTextField.getText()));
                    fileChooser.setDialogTitle("Select Directory");
                    fileChooser.setFileSelectionMode(1);
                    int result = fileChooser.showOpenDialog(Console.this);
                    if (result == 0) {
                        File selectedDirectory = fileChooser.getSelectedFile();
                        Console.this.modelRepositoryTextField.setText(selectedDirectory.getAbsolutePath());
                    }
                }
            });
            OutputLabel modelLabel = new OutputLabel("Model:");
            modelLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)modelLabel);
            this.modelTextField = new InputText();
            jpGroupSetup.add((Component)this.modelTextField);
            CommandButton jbAssignModel = new CommandButton("Assign Model");
            jbAssignModel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)jbAssignModel);
            jbAssignModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(new File(Console.this.modelTextField.getText()));
                    fileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            String extension = this.getExtension(f);
                            return extension != null && extension.equals("gguf");
                        }

                        @Override
                        public String getDescription() {
                            return "GGUF files (*.gguf)";
                        }

                        private String getExtension(File f) {
                            String fileName = f.getName();
                            int index = fileName.lastIndexOf(46);
                            if (index > 0 && index < fileName.length() - 1) {
                                return fileName.substring(index + 1).toLowerCase();
                            }
                            return null;
                        }
                    });
                    fileChooser.setDialogTitle("Select the LLM");
                    fileChooser.setFileSelectionMode(0);
                    int result = fileChooser.showOpenDialog(Console.this);
                    if (result == 0) {
                        File selectedDirectory = fileChooser.getSelectedFile();
                        Console.this.modelTextField.setText(selectedDirectory.getAbsolutePath());
                    }
                }
            });
            OutputLabel modelPromptTemplateLabel = new OutputLabel("Model Prompt Template:");
            modelPromptTemplateLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)modelPromptTemplateLabel);
            this.modelPromptTemplateTextField = new InputText();
            jpGroupSetup.add((Component)this.modelPromptTemplateTextField);
            jpGroupSetup.add(new JLabel(""));
            OutputLabel missionPromptFolderLabel = new OutputLabel("Mission Prompt Folder:");
            missionPromptFolderLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)missionPromptFolderLabel);
            jpGroupSetup.add((Component)this.missionPromptFolderTextField);
            CommandButton jbMissionPromptFolder = new CommandButton("Mission Prompt Folder");
            jbMissionPromptFolder.setTheme(this.theme, false);
            jpGroupSetup.add((Component)jbMissionPromptFolder);
            jbMissionPromptFolder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(new File(Console.this.missionPromptFolderTextField.getText()));
                    fileChooser.setDialogTitle("Select Directory");
                    fileChooser.setFileSelectionMode(1);
                    int result = fileChooser.showOpenDialog(Console.this);
                    if (result == 0) {
                        File selectedDirectory = fileChooser.getSelectedFile();
                        Console.this.missionPromptFolderTextField.setText(selectedDirectory.getAbsolutePath());
                    }
                }
            });
            jpGroupSetup.add((Component)jbMissionPromptFolder);
            OutputLabel cacheLabel = new OutputLabel("Cache:");
            cacheLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)cacheLabel);
            this.cacheTextField = new InputText();
            jpGroupSetup.add((Component)this.cacheTextField);
            jpGroupSetup.add(new JLabel(""));
            OutputLabel cacheLocalIpLabel = new OutputLabel("Cache Local IP:");
            cacheLocalIpLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)cacheLocalIpLabel);
            this.cacheLocalIpComboBox = new ComboBox();
            this.cacheLocalIpComboBox.setTheme(this.theme);
            for (String sIp : this.listIPAddresses()) {
                this.cacheLocalIpComboBox.addItem((Object)sIp);
            }
            jpGroupSetup.add((Component)this.cacheLocalIpComboBox);
            jpGroupSetup.add(new JLabel(""));
            OutputLabel cipherMessageLabel = new OutputLabel("Cipher Message:");
            cipherMessageLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)cipherMessageLabel);
            this.cipherMessageCheckBox = new SelectBooleanCheckbox();
            this.cipherMessageCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Console.this.cipherMessageCheckBox.isSelected()) {
                        Console.this.testKeystore.setEnabled(true);
                    } else {
                        Console.this.testKeystore.setEnabled(false);
                        Console.this.testKeystore.setForeground(Color.BLACK);
                    }
                }
            });
            jpGroupSetup.add((Component)this.cipherMessageCheckBox);
            jpGroupSetup.add(new JLabel(""));
            OutputLabel keyStorePassLabel = new OutputLabel("KeyStore Password:");
            keyStorePassLabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)keyStorePassLabel);
            this.keyStorePassTextField = new JPasswordField();
            jpGroupSetup.add(this.keyStorePassTextField);
            this.testKeystore = new CommandButton("Test KeyStore");
            this.testKeystore.setTheme(this.theme, false);
            this.testKeystore.setEnabled(false);
            this.testKeystore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Console.this.cipherMessageCheckBox.isSelected() && !Console.this.keyStorePassTextField.getText().isEmpty()) {
                        File f = new File(Console.this.cacheTextField.getText() + ".pfx");
                        if (!f.exists()) {
                            JOptionPane.showMessageDialog(Console.this, "The KeyStore: " + Console.this.cacheTextField.getText() + ".pfx not exists");
                            Console.this.testKeystore.setEnabled(false);
                        } else {
                            try {
                                Security.getPublicKeyFromKeystore(Console.this.cacheTextField.getText() + ".pfx", new String(Console.this.keyStorePassTextField.getPassword()), Console.this.cacheTextField.getText(), "PKCS12");
                                Console.this.testKeystore.setForeground(Color.GREEN);
                            }
                            catch (Exception ex) {
                                Console.this.testKeystore.setForeground(Color.RED);
                                Console.this.cipherMessageCheckBox.setSelected(false);
                                Console.this.testKeystore.setEnabled(false);
                                JOptionPane.showMessageDialog(Console.this, "The password for KeyStore: " + Console.this.cacheTextField.getText() + ".pfx is invalid");
                            }
                        }
                    }
                }
            });
            jpGroupSetup.add((Component)this.testKeystore);
            OutputLabel chatUILabel = new OutputLabel("Chat UI:");
            chatUILabel.setTheme(this.theme, false);
            jpGroupSetup.add((Component)chatUILabel);
            this.chatUICheckBox = new SelectBooleanCheckbox();
            this.chatUICheckBox.setTheme(this.theme);
            jpGroupSetup.add((Component)this.chatUICheckBox);
            jpGroupSetup.add(new JLabel(""));
            mainPanel.add((Component)jsProgressBarPanel, (Object)"East");
            JPanel jpButtonsSetup = new JPanel(new FlowLayout(1));
            jpButtonsSetup.setOpaque(false);
            CommandButton jbSave = new CommandButton("Save");
            jbSave.setTheme(this.theme, false);
            jbSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.saveFormInformation("mc3d-ai.properties");
                }
            });
            jpButtonsSetup.add((Component)jbSave);
            CommandButton jbClear = new CommandButton("Clear");
            jbClear.setTheme(this.theme, false);
            jpButtonsSetup.add((Component)jbClear);
            jbClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.clearForm();
                }
            });
            CommandButton jbReload = new CommandButton("Reload");
            jbReload.setTheme(this.theme, false);
            jpButtonsSetup.add((Component)jbReload);
            jbReload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.loadProperties("mc3d-ai.properties");
                }
            });
            jpGroupSetup.add(new JLabel(""));
            jpGroupSetup.add(jpButtonsSetup);
            jpGroupSetup.add(new JLabel(""));
            JPanel jpPackSetup = new JPanel(new FlowLayout(1));
            jpPackSetup.setOpaque(false);
            jpPackSetup.add(jpGroupSetup);
            mainPanel.add((Component)jpPackSetup, (Object)"South");
        } else if (title.toLowerCase().endsWith(".txt")) {
            tab.setClosable(true);
            tab.setSave(true);
            String sFolder = this.missionPromptFolderTextField.getText();
            if (sFolder.contains("\\")) {
                sFolder = sFolder.replaceAll("\\\\", "/");
            }
            String file = sFolder + title;
            System.out.println("File txt: " + file);
            tab.setSaveFileName(file);
            tab.getMessageArea().setRows(20);
            try {
                FileInputStream fis = new FileInputStream(file);
                DataInputStream dis = new DataInputStream(fis);
                String data = "";
                while ((data = dis.readLine()) != null) {
                    tab.getMessageArea().append(data + "\n");
                }
                ((InputStream)fis).close();
                dis.close();
            }
            catch (Exception fis) {
                // empty catch block
            }
            JScrollPane jsMessageArea = new JScrollPane(tab.getMessageArea());
            mainPanel.add((Component)jsMessageArea, (Object)"Center");
        } else if (title.toLowerCase().endsWith(".pdf")) {
            tab.setClosable(true);
            String sFolder = this.missionPromptFolderTextField.getText();
            if (sFolder.contains("\\")) {
                sFolder = sFolder.replaceAll("\\\\", "/");
            }
            String file = sFolder + title;
            System.out.println("File pdf: " + file);
            byte[] pdf = null;
            PDFViewer pdfViewer = new PDFViewer(true);
            pdfViewer.init();
            try {
                FileInputStream fis = new FileInputStream(file);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int data = 0;
                while ((data = fis.read()) != -1) {
                    baos.write(data);
                }
                pdf = baos.toByteArray();
                System.out.println("pdf lenght: " + pdf.length);
                pdfViewer.openPDFByteBuffer(ByteBuffer.wrap(pdf), sFolder, title);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            pdfViewer.setOpenFile(false);
            pdfViewer.validate();
            JScrollPane jsMessageArea = new JScrollPane((Component)pdfViewer);
            mainPanel.add((Component)jsMessageArea, (Object)"Center");
        } else {
            tab.setId("WV" + System.currentTimeMillis());
            if (title.equals("Principal")) {
                tab.setId("WV0");
                tab.setClosable(false);
            } else {
                tab.setClosable(true);
            }
            this.pubSubFiles = new PubSubFiles();
            JTextPane chatPane = new JTextPane();
            chatPane.setName(tab.getId());
            chatPane.setContentType("text/html");
            chatPane.setText("<html><body></body></html>");
            this.hWebView.put(tab.getId(), chatPane);
            chatPane.setEditable(false);
            JScrollPane jsChatPane = new JScrollPane(chatPane);
            JTextArea messageArea = new JTextArea();
            this.hMessageArea.put(tab.getId(), messageArea);
            JScrollPane jsMessageArea = new JScrollPane(messageArea);
            CommandButton sendMessageButton = new CommandButton("Send");
            sendMessageButton.setTheme(this.theme, false);
            sendMessageButton.addActionListener(e -> {
                String message = messageArea.getText();
                if (!message.isEmpty()) {
                    this.sendMessage((JButton)sendMessageButton, "" + System.currentTimeMillis() + tab.getId(), messageArea);
                    messageArea.setText("");
                }
            });
            CommandButton clearChatMessageButton = new CommandButton("Clear Chat");
            clearChatMessageButton.setTheme(this.theme, false);
            clearChatMessageButton.addActionListener(e -> {
                String message = messageArea.getText();
                chatPane.setText("<html><body></body>></html>");
            });
            CommandButton clearMessageButton = new CommandButton("Clear Message");
            clearMessageButton.setTheme(this.theme, false);
            clearMessageButton.addActionListener(e -> {
                String message = messageArea.getText();
                messageArea.setText("");
            });
            JPanel groupButtonsPanel = new JPanel();
            groupButtonsPanel.setLayout(new GridLayout(3, 1));
            groupButtonsPanel.add((Component)sendMessageButton);
            groupButtonsPanel.add((Component)clearChatMessageButton);
            groupButtonsPanel.add((Component)clearMessageButton);
            JPanel inputPanel = new JPanel(new BorderLayout());
            inputPanel.add((Component)jsMessageArea, "Center");
            inputPanel.add((Component)groupButtonsPanel, "East");
            mainPanel.add((Component)jsChatPane, (Object)"Center");
            mainPanel.add((Component)inputPanel, (Object)"South");
        }
        tabbedPane.addTab(title, (Component)tab);
    }

    public DefaultTableModel getDtmGridStatus() {
        return this.dtmGridStatus;
    }

    private void sendMessage(JButton sendMessageButton, String id, JTextArea messageArea) {
        String message = messageArea.getText();
        if (!message.isEmpty()) {
            sendMessageButton.setEnabled(false);
            try {
                String sFolder = this.missionPromptFolderTextField.getText();
                if (sFolder.contains("\\")) {
                    sFolder = sFolder.replaceAll("\\\\", "/");
                }
                this.pubSubFiles.putQuestion("", sFolder, "" + id, message);
                this.addJeMensajes("" + new Date(), "" + id, "Me", message);
                messageArea.setText("");
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Send Error: " + e.toString());
            }
            sendMessageButton.setEnabled(true);
        }
    }

    public JTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public void addJeMensajes(String timestamp, String id, String username, String message) {
        try {
            JTextPane jTextPane = null;
            String sWebViewId = "";
            if (id.contains("WV")) {
                String localMessage;
                System.out.println("Id: " + id);
                sWebViewId = id.substring(id.indexOf("WV"), id.length());
                boolean existTab = false;
                for (Component component : this.tabbedPane.getComponents()) {
                    JTab tab = (JTab)component;
                    if (!tab.getId().equals(sWebViewId)) continue;
                    System.out.println("Encontrado el editor: " + sWebViewId);
                    existTab = true;
                    jTextPane = this.hWebView.get(sWebViewId);
                    break;
                }
                if (!existTab) {
                    jTextPane = this.hWebView.get("WV0");
                    System.out.println("Encontre el jTextPane");
                    this.hWebView.remove(sWebViewId);
                }
                if ((localMessage = message).contains("\n")) {
                    localMessage = localMessage.replaceAll("\n", "<br/>");
                }
                String currentHtml = jTextPane.getText();
                String align = "right";
                String headerColor = "orange";
                String refId = ", question id: " + id;
                String anchor = "<a name=\"" + id + "\">" + username + " says:</a>";
                if (!username.toLowerCase().equals("me")) {
                    anchor = username + " says:";
                    headerColor = "yellow";
                    align = "left";
                    refId = ", Response to: <a href=\"#" + id + "\">" + id + "</a>";
                }
                String newHtml = currentHtml.substring(0, currentHtml.lastIndexOf("</body>")) + "<div align=\"" + align + "\"><table border=1 width=50%><th bgcolor=" + headerColor + ">" + anchor + "</th><tr><td>" + localMessage + "</td></tr><tr><td>[" + new Date() + "]" + refId + "</td></tr></table></div><br/></body></html>";
                if (username.toLowerCase().equals("me")) {
                    this.hPendingConversations.put(id, newHtml);
                } else {
                    if (!existTab) {
                        String oldHtml = this.hPendingConversations.get(id);
                        newHtml = oldHtml + newHtml;
                    }
                    this.hPendingConversations.remove(id);
                }
                jTextPane.setText(newHtml);
                jTextPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent pE) {
                        if (HyperlinkEvent.EventType.ACTIVATED == pE.getEventType()) {
                            System.out.println("JEditorPane link click: url='" + pE.getURL() + "' description='" + pE.getDescription() + "'");
                            String reference = pE.getDescription();
                            if (reference != null && reference.startsWith("#")) {
                                reference = reference.substring(1);
                                ((JTextPane)pE.getSource()).scrollToReference(reference);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Add Messages error: " + e.toString());
            e.printStackTrace();
        }
    }

    private List<String> listIPAddresses() {
        ArrayList<String> lMyCustomAddress = new ArrayList<String>();
        lMyCustomAddress.add("");
        Enumeration<NetworkInterface> net = null;
        try {
            net = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        if (net == null) {
            throw new RuntimeException("No network interfaces found.");
        }
        while (net.hasMoreElements()) {
            NetworkInterface element = net.nextElement();
            try {
                if (element.isVirtual() || element.isLoopback()) continue;
                Enumeration<InetAddress> addresses = element.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address) || !ip.isSiteLocalAddress()) continue;
                    lMyCustomAddress.add(ip.getHostAddress());
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        return lMyCustomAddress;
    }

    public void listDocs(String sFolder, VDMutableTreeNode dmtDocs, Tree treeDocs) {
        String missionPromptFolder;
        if (sFolder.contains("\\")) {
            sFolder = sFolder.replaceAll("\\\\", "/");
        }
        if ((missionPromptFolder = this.missionPromptFolderTextField.getText()).contains("\\")) {
            missionPromptFolder = missionPromptFolder.replaceAll("\\\\", "/");
        }
        GridPublishFile unitaryProcessPublishFile = new GridPublishFile(missionPromptFolder);
        List inputs = unitaryProcessPublishFile.getLocalDocsList(sFolder);
        Collections.sort(inputs);
        if (inputs.size() > 0) {
            for (String input : inputs) {
                if (input.contains("\\")) {
                    input = input.replaceAll("\\\\", "/");
                }
                if (input.contains("/" + sFolder)) {
                    input = input.replaceAll("/" + sFolder, "");
                }
                VDMutableTreeNode dmtBase = dmtDocs;
                StringTokenizer st = new StringTokenizer(input, "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    VDMutableTreeNode dmtNuevo = new VDMutableTreeNode(token);
                    dmtNuevo.setName(token);
                    if (!this.searchTreeLeaf(dmtBase, token)) {
                        dmtBase.add((MutableTreeNode)dmtNuevo);
                    }
                    dmtBase = this.getTreeLeaf(dmtBase, token);
                }
                dmtBase = dmtDocs;
            }
            treeDocs.updateUI();
            treeDocs.validate();
            treeDocs.getParent().validate();
        }
    }

    public boolean searchTreeLeaf(VDMutableTreeNode vdmProject, String buscar) {
        boolean existe = false;
        for (int i = 0; i < vdmProject.getChildCount(); ++i) {
            VDMutableTreeNode dmt = (VDMutableTreeNode)vdmProject.getChildAt(i);
            if (!dmt.getName().toLowerCase().equals(buscar.toString().toLowerCase())) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public VDMutableTreeNode getTreeLeaf(VDMutableTreeNode vdmProject, String buscar) {
        VDMutableTreeNode existe = vdmProject;
        for (int i = 0; i < vdmProject.getChildCount(); ++i) {
            VDMutableTreeNode dmt = (VDMutableTreeNode)vdmProject.getChildAt(i);
            if (!dmt.getName().toLowerCase().equals(buscar.toString().toLowerCase())) continue;
            existe = dmt;
            break;
        }
        return existe;
    }
}

