/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;

public class LlamaCPP {
    public LinkedHashMap startMC3DAI(String location, String model, double temperature, String prompt) {
        LinkedHashMap<String, Long> resultMap = new LinkedHashMap<String, Long>();
        long start = System.currentTimeMillis();
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        try {
            if (isWindows) {
                CommandLine cmdLine = new CommandLine("cmd.exe");
                cmdLine.addArgument("/c " + location + "/main.exe -m " + location + "/" + model + " --ctx_size 32768  --no-mmap -np 8 -ns 8 --temp " + temperature + " --top_k 20 --top_p 0.95 -n 2048 --log-disable --in-prefix \"USER: \" --in-suffix \"ASSISTANT: \" -r \"USER:\" -p \"You are a helpful ASSISTANT. USER: " + prompt + " ASSISTANT:\"");
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)stdout, (OutputStream)stderr);
                DefaultExecutor executor = new DefaultExecutor();
                executor.execute(cmdLine);
                executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
                System.out.println("Resultado: " + stdout.toString());
            }
        }
        catch (Exception cmdLine) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        resultMap.put("total", end - start);
        return resultMap;
    }

    public static void main(String[] args) {
        String sWindowsDir = "D:/llama-avx-x64-mc3d";
        String sLinuxDir = "/MC3D-IA";
        String sModel = "dolphin-2.8-experiment26-7b.q4_k_m-by_macadeliccc.gguf";
        LlamaCPP ll = new LlamaCPP();
        long uuid = System.currentTimeMillis();
        String prompt = "La siguiente es una lista de categorias de un portal web: Sin categorizar, slug: sin-categorizar. ACCESORIO DE BA\u00d1O, slug: accesorio-de-bano. BARRAS DE CORTINA, slug: barras-de-cortina. BARRAS DE SEGURIDAD, slug: barras-de-seguridad. COLGADORES DE DUCHA, slug: colgadores-de-ducha. CORTINAS DE BA\u00d1O, slug: cortinas-de-bano. FLEXIBLES DE DUCHA, slug: flexibles-de-ducha. JUEGOS DE DUCHA, slug: juegos-de-ducha. MANGOS DE DUCHA, slug: mangos-de-ducha. PORTA TOALLAS, slug: porta-toallas. SECADORA DE MANOS, slug: secadora-de-manos. SIFONES LAVATORIOS, slug: sifones-lavatorios. ARTICULOS PARA GAS, slug: articulos-para-gas. LLAVES DE GAS, slug: llaves-de-gas. REGULADORES DE GAS, slug: reguladores-de-gas. SOPLETES, slug: sopletes. ESPEJOS, slug: espejos. ESPEJO LED, slug: espejo-led. ESPEJOS NORMALES, slug: espejos-normales. GRIFERIA BA\u00d1O, slug: griferia-bano. COLUMNAS DUCHA, slug: columnas-ducha. MONOMANDO DUCHA, slug: monomando-ducha. MONOMANDO LAVATORIO, slug: monomando-lavatorio. MONOMANDO TINA DUCHA, slug: monomando-tina-ducha. GRIFERIA COCINA, slug: griferia-cocina. COMBINACION DE LAVAPLATOS, slug: combinacion-de-lavaplatos. MONOMANDO LAVAPLATOS, slug: monomando-lavaplatos-griferia-cocina. MUEBLES, slug: muebles. MUEBLES PARA BA\u00d1O, slug: muebles-para-bano. SALA DE BA\u00d1O, slug: sala-de-bano. SHOWERDOOR Y MAMPARAS, slug: showerdoor-y-mamparas. SHOWERDOOR, slug: showerdoor. TINAS Y RECEPTACULOS, slug: tinas-y-receptaculos. RECEPTACULOS, slug: receptaculos-tinas-y-receptaculos. WC, slug: wc. PORTA PAPEL, slug: porta-papel. a que categoria asignarias el siguiente producto: FE00090-SILICONA BANO COCINA ANTI HONGO SOUDAL BLANCO";
        LinkedHashMap result = ll.startMC3DAI(sWindowsDir, sModel, 0.09, prompt);
        System.out.println("Tiempo total: " + result.get("total") + " ms texto:" + result.get("data"));
    }
}

