/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.processors.service.ServiceInfo;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.services.ServiceConfiguration;
import org.jetbrains.annotations.NotNull;

public class ServiceDeploymentActions {
    private boolean deactivate;
    private Map<IgniteUuid, ServiceInfo> servicesToDeploy;
    private Map<IgniteUuid, ServiceInfo> servicesToUndeploy;
    private Map<IgniteUuid, Map<UUID, Integer>> depTops;
    private Map<IgniteUuid, Collection<byte[]>> depErrors;
    private final String platform;

    public ServiceDeploymentActions(GridKernalContext ctx) {
        this.platform = ctx.platform().hasContext() ? ctx.platform().context().platform() : "";
    }

    public void servicesToDeploy(@NotNull Map<IgniteUuid, ServiceInfo> servicesToDeploy) {
        HashMap<IgniteUuid, ServiceInfo> res = new HashMap<IgniteUuid, ServiceInfo>();
        for (Map.Entry<IgniteUuid, ServiceInfo> kv : servicesToDeploy.entrySet()) {
            ServiceInfo dsc = kv.getValue();
            ServiceConfiguration cfg = dsc.configuration();
            String svcPlatform = PlatformUtils.servicePlatform(cfg);
            if (!svcPlatform.isEmpty() && !this.platform.equals(svcPlatform)) continue;
            res.put(kv.getKey(), dsc);
        }
        this.servicesToDeploy = Collections.unmodifiableMap(res);
    }

    @NotNull
    public Map<IgniteUuid, ServiceInfo> servicesToDeploy() {
        return this.servicesToDeploy != null ? this.servicesToDeploy : Collections.emptyMap();
    }

    public void servicesToUndeploy(@NotNull Map<IgniteUuid, ServiceInfo> servicesToUndeploy) {
        this.servicesToUndeploy = Collections.unmodifiableMap(new HashMap<IgniteUuid, ServiceInfo>(servicesToUndeploy));
    }

    @NotNull
    public Map<IgniteUuid, ServiceInfo> servicesToUndeploy() {
        return this.servicesToUndeploy != null ? this.servicesToUndeploy : Collections.emptyMap();
    }

    public void deactivate(boolean deactivate) {
        this.deactivate = deactivate;
    }

    public boolean deactivate() {
        return this.deactivate;
    }

    @NotNull
    public Map<IgniteUuid, Map<UUID, Integer>> deploymentTopologies() {
        return this.depTops != null ? this.depTops : Collections.emptyMap();
    }

    public void deploymentTopologies(@NotNull Map<IgniteUuid, Map<UUID, Integer>> depTops) {
        this.depTops = Collections.unmodifiableMap(new HashMap<IgniteUuid, Map<UUID, Integer>>(depTops));
    }

    @NotNull
    public Map<IgniteUuid, Collection<byte[]>> deploymentErrors() {
        return this.depErrors != null ? this.depErrors : Collections.emptyMap();
    }

    public void deploymentErrors(@NotNull Map<IgniteUuid, Collection<byte[]>> depErrors) {
        this.depErrors = Collections.unmodifiableMap(new HashMap<IgniteUuid, Collection<byte[]>>(depErrors));
    }
}

