/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.managers.systemview.walker.StatisticsColumnGlobalDataViewWalker;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAddressedRequest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.StatisticsUtils;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsObjectData;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsRequest;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsResponse;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnGlobalDataView;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class IgniteGlobalStatisticsManager
implements GridMessageListener {
    private static final String STAT_GLOBAL_VIEW_NAME = "statisticsGlobalData";
    private static final String STAT_GLOBAL_VIEW_DESCRIPTION = "Global statistics.";
    private final IgniteStatisticsManagerImpl statMgr;
    private final IgniteThreadPoolExecutor mgmtPool;
    private final GridDiscoveryManager discoMgr;
    private final GridClusterStateProcessor cluster;
    private final GridCachePartitionExchangeManager<?, ?> exchange;
    private final IgniteStatisticsHelper helper;
    private final GridIoManager ioMgr;
    private final ConcurrentMap<StatisticsKey, CacheEntry<ObjectStatisticsImpl>> globalStatistics = new ConcurrentHashMap<StatisticsKey, CacheEntry<ObjectStatisticsImpl>>();
    private final ConcurrentMap<StatisticsKey, Collection<StatisticsAddressedRequest>> inLocalRequests = new ConcurrentHashMap<StatisticsKey, Collection<StatisticsAddressedRequest>>();
    private final ConcurrentMap<StatisticsKey, Collection<StatisticsAddressedRequest>> inGloblaRequests = new ConcurrentHashMap<StatisticsKey, Collection<StatisticsAddressedRequest>>();
    private final ConcurrentMap<StatisticsKey, StatisticsGatheringContext> curCollections = new ConcurrentHashMap<StatisticsKey, StatisticsGatheringContext>();
    private final ConcurrentMap<StatisticsKey, UUID> outGlobalStatisticsRequests = new ConcurrentHashMap<StatisticsKey, UUID>();
    private final IgniteLogger log;
    private boolean started;
    private final PartitionsExchangeAware exchAwareLsnr = new PartitionsExchangeAware(){

        @Override
        public void onDoneAfterTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
            if (fut.exchangeType() != GridDhtPartitionsExchangeFuture.ExchangeType.ALL || IgniteGlobalStatisticsManager.this.cluster.clusterState().lastState() != ClusterState.ACTIVE) {
                return;
            }
            DiscoveryEvent evt = fut.firstEvent();
            if (evt.type() == 18) {
                DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)evt).customMessage();
                if (msg instanceof DynamicCacheChangeBatch) {
                    return;
                }
                if (IgniteGlobalStatisticsManager.this.log.isDebugEnabled()) {
                    IgniteGlobalStatisticsManager.this.log.debug("Resetting all global statistics activities due to new topology " + fut.topologyVersion());
                }
                IgniteGlobalStatisticsManager.this.inLocalRequests.clear();
                IgniteGlobalStatisticsManager.this.inGloblaRequests.clear();
                Set curColls = IgniteGlobalStatisticsManager.this.curCollections.keySet();
                for (StatisticsKey key : curColls) {
                    IgniteGlobalStatisticsManager.this.curCollections.remove(key);
                    IgniteGlobalStatisticsManager.this.mgmtPool.submit(() -> IgniteGlobalStatisticsManager.this.collectGlobalStatistics(key));
                }
                Set outReqs = IgniteGlobalStatisticsManager.this.outGlobalStatisticsRequests.keySet();
                for (StatisticsKey key : outReqs) {
                    IgniteGlobalStatisticsManager.this.outGlobalStatisticsRequests.remove(key);
                    IgniteGlobalStatisticsManager.this.mgmtPool.submit(() -> IgniteGlobalStatisticsManager.this.collectGlobalStatistics(key));
                }
            }
        }
    };

    public IgniteGlobalStatisticsManager(IgniteStatisticsManagerImpl statMgr, GridSystemViewManager sysViewMgr, IgniteThreadPoolExecutor mgmtPool, GridDiscoveryManager discoMgr, GridClusterStateProcessor cluster, GridCachePartitionExchangeManager<?, ?> exchange, IgniteStatisticsHelper helper, GridIoManager ioMgr, Function<Class<?>, IgniteLogger> logSupplier) {
        this.statMgr = statMgr;
        this.mgmtPool = mgmtPool;
        this.discoMgr = discoMgr;
        this.cluster = cluster;
        this.exchange = exchange;
        this.helper = helper;
        this.ioMgr = ioMgr;
        this.log = logSupplier.apply(IgniteGlobalStatisticsManager.class);
        statMgr.subscribeToLocalStatistics(nls -> this.onLocalStatisticsAggregated(nls.key(), nls.statistics(), nls.topologyVersion()));
        statMgr.subscribeToStatisticsConfig(this::onConfigChanged);
        ioMgr.addMessageListener(GridTopic.TOPIC_STATISTICS, (GridMessageListener)this);
        sysViewMgr.registerFiltrableView(STAT_GLOBAL_VIEW_NAME, STAT_GLOBAL_VIEW_DESCRIPTION, new StatisticsColumnGlobalDataViewWalker(), this::columnGlobalStatisticsViewSupplier, Function.identity());
    }

    private Iterable<StatisticsColumnGlobalDataView> columnGlobalStatisticsViewSupplier(Map<String, Object> filter) {
        Map<StatisticsKey, ObjectStatisticsImpl> globalStatsMap;
        String type = (String)filter.get("type");
        if (type != null && !"TABLE".equalsIgnoreCase(type)) {
            return Collections.emptyList();
        }
        String schema = (String)filter.get("schema");
        String name = (String)filter.get("name");
        String column = (String)filter.get("column");
        if (!F.isEmpty(schema) && !F.isEmpty(name)) {
            StatisticsKey key = new StatisticsKey(schema, name);
            CacheEntry objLocStat = (CacheEntry)this.globalStatistics.get(key);
            if (objLocStat == null || objLocStat.obj == null) {
                return Collections.emptyList();
            }
            globalStatsMap = Collections.singletonMap(key, objLocStat.object());
        } else {
            globalStatsMap = this.globalStatistics.entrySet().stream().filter(e -> ((CacheEntry)e.getValue()).object() != null && (F.isEmpty(schema) || schema.equals(((StatisticsKey)e.getKey()).schema()))).collect(Collectors.toMap(Map.Entry::getKey, e -> (ObjectStatisticsImpl)((CacheEntry)e.getValue()).object()));
        }
        ArrayList<StatisticsColumnGlobalDataView> res = new ArrayList<StatisticsColumnGlobalDataView>();
        for (Map.Entry<StatisticsKey, ObjectStatisticsImpl> localStatsEntry : globalStatsMap.entrySet()) {
            StatisticsKey key = localStatsEntry.getKey();
            ObjectStatisticsImpl stat = localStatsEntry.getValue();
            if (column == null) {
                for (Map.Entry<String, ColumnStatistics> colStat : localStatsEntry.getValue().columnsStatistics().entrySet()) {
                    StatisticsColumnGlobalDataView colStatView = new StatisticsColumnGlobalDataView(key, colStat.getKey(), stat);
                    res.add(colStatView);
                }
                continue;
            }
            ColumnStatistics colStat = localStatsEntry.getValue().columnStatistics(column);
            if (colStat == null) continue;
            StatisticsColumnGlobalDataView colStatView = new StatisticsColumnGlobalDataView(key, column, stat);
            res.add(colStatView);
        }
        return res;
    }

    public synchronized void start() {
        if (this.started) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("IgniteGlobalStatisticsManager already started.");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Global statistics manager starting...");
        }
        this.globalStatistics.clear();
        this.exchange.registerExchangeAwareComponent(this.exchAwareLsnr);
        this.started = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Global statistics manager started.");
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("IgniteGlobalStatisticsManager already stopped.");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Global statistics manager stopping...");
        }
        this.globalStatistics.clear();
        this.inGloblaRequests.clear();
        this.inLocalRequests.clear();
        this.outGlobalStatisticsRequests.clear();
        this.curCollections.clear();
        this.exchange.unregisterExchangeAwareComponent(this.exchAwareLsnr);
        this.started = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Global statistics manager stopped.");
        }
    }

    public ObjectStatisticsImpl getGlobalStatistics(StatisticsKey key) {
        CacheEntry res = this.globalStatistics.computeIfAbsent(key, k -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Scheduling global statistics collection by key " + key);
            }
            this.mgmtPool.submit(() -> this.collectGlobalStatistics(key));
            return new CacheEntry<Object>(null);
        });
        return (ObjectStatisticsImpl)res.object();
    }

    private void collectGlobalStatistics(StatisticsKey key) {
        block8: {
            try {
                StatisticsObjectConfiguration statCfg = this.statMgr.statisticConfiguration().config(key);
                if (statCfg != null && !statCfg.columns().isEmpty()) {
                    UUID statMaster = this.getStatisticsMasterNode(key);
                    if (this.discoMgr.localNode().id().equals(statMaster)) {
                        this.gatherGlobalStatistics(statCfg);
                    } else {
                        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(key.schema(), key.obj(), Collections.emptyList());
                        Map<String, Long> versions = statCfg.columns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatisticsColumnConfiguration)e.getValue()).version()));
                        StatisticsRequest globalReq = new StatisticsRequest(UUID.randomUUID(), keyMsg, StatisticsType.GLOBAL, null, versions);
                        this.outGlobalStatisticsRequests.put(key, globalReq.reqId());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Send global statistics request by configuration " + statCfg);
                        }
                        this.send(statMaster, globalReq);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to start global statistics collection due to lack of configuration by key " + key);
                }
            }
            catch (IgniteCheckedException e2) {
                if (!this.log.isInfoEnabled()) break block8;
                this.log.info("Unable to get statistics configuration due to " + e2.getMessage());
            }
        }
    }

    private void gatherGlobalStatistics(StatisticsObjectConfiguration statCfg) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start global statistics collection by configuration " + statCfg);
        }
        StatisticsTarget target = new StatisticsTarget(statCfg.key(), new String[0]);
        List<StatisticsAddressedRequest> locRequests = this.helper.generateGatheringRequests(target, statCfg);
        UUID reqId = locRequests.get(0).req().reqId();
        StatisticsGatheringContext gatCtx = new StatisticsGatheringContext(locRequests.size(), reqId, statCfg);
        this.curCollections.put(statCfg.key(), gatCtx);
        for (StatisticsAddressedRequest addReq : locRequests) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending local request " + addReq.req().reqId() + " to node " + addReq.nodeId());
            }
            this.send(addReq.nodeId(), addReq.req());
        }
    }

    @Override
    public void onMessage(UUID nodeId, Object msg, byte plc) {
        this.mgmtPool.submit(() -> {
            try {
                if (msg instanceof StatisticsRequest) {
                    StatisticsRequest req = (StatisticsRequest)msg;
                    switch (req.type()) {
                        case LOCAL: {
                            this.processLocalRequest(nodeId, req);
                            break;
                        }
                        case GLOBAL: {
                            this.processGlobalRequest(nodeId, req);
                            break;
                        }
                        default: {
                            this.log.warning("Unexpected type " + (Object)((Object)req.type()) + " in statistics request message " + req);
                            break;
                        }
                    }
                } else if (msg instanceof StatisticsResponse) {
                    StatisticsResponse resp = (StatisticsResponse)msg;
                    switch (resp.data().type()) {
                        case LOCAL: {
                            this.processLocalResponse(nodeId, resp);
                            break;
                        }
                        case GLOBAL: {
                            this.processGlobalResponse(nodeId, resp);
                            break;
                        }
                        default: {
                            this.log.warning("Unexpected type " + (Object)((Object)resp.data().type()) + " in statistics reposonse message " + resp);
                            break;
                        }
                    }
                } else {
                    this.log.warning("Unknown msg " + msg + " in statistics topic " + (Object)((Object)GridTopic.TOPIC_STATISTICS) + " from node " + nodeId);
                }
            }
            catch (Throwable e) {
                this.log.warning("Unable to process statistics message: " + e.getMessage(), e);
            }
        });
    }

    private void processLocalRequest(UUID nodeId, StatisticsRequest req) throws IgniteCheckedException {
        StatisticsKey key;
        ObjectStatisticsImpl objectStatistics;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got local statistics request from node " + nodeId + " : " + req);
        }
        if (StatisticsUtils.compareVersions(objectStatistics = this.statMgr.getLocalStatistics(key = new StatisticsKey(req.key().schema(), req.key().obj()), req.topVer()), req.versions()) == 0) {
            this.sendResponse(nodeId, req.reqId(), key, StatisticsType.LOCAL, objectStatistics);
        } else {
            StatisticsAddressedRequest removed;
            this.addToRequests(this.inLocalRequests, key, new StatisticsAddressedRequest(req, nodeId));
            objectStatistics = this.statMgr.getLocalStatistics(key, req.topVer());
            if (StatisticsUtils.compareVersions(objectStatistics, req.versions()) == 0 && (removed = this.removeFromRequests(this.inLocalRequests, key, req.reqId())) != null) {
                this.sendResponse(nodeId, req.reqId(), key, StatisticsType.LOCAL, objectStatistics);
            }
        }
    }

    private boolean checkStatisticsCfg(StatisticsObjectConfiguration cfg, Map<String, Long> versions) {
        if (cfg == null) {
            return false;
        }
        for (Map.Entry<String, Long> version : versions.entrySet()) {
            StatisticsColumnConfiguration colCfg = cfg.columns().get(version.getKey());
            if (colCfg != null && colCfg.version() >= version.getValue()) continue;
            return false;
        }
        return true;
    }

    private void processGlobalRequest(UUID nodeId, StatisticsRequest req) throws IgniteCheckedException {
        StatisticsKey key;
        ObjectStatisticsImpl objStatistics;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got global statistics request from node " + nodeId + " : " + req);
        }
        if ((objStatistics = this.getGlobalStatistics(key = new StatisticsKey(req.key().schema(), req.key().obj()), req.versions())) == null) {
            StatisticsAddressedRequest removed;
            if (this.discoMgr.localNode().id().equals(this.getStatisticsMasterNode(key))) {
                this.addToRequests(this.inGloblaRequests, key, new StatisticsAddressedRequest(req, nodeId));
                this.globalStatistics.computeIfAbsent(key, k -> new CacheEntry<Object>(null));
                if (!this.hasCurrentCollection(key, req.versions())) {
                    StatisticsObjectConfiguration objCfg = this.statMgr.statisticConfiguration().config(key);
                    if (StatisticsUtils.compareVersions(objCfg, req.versions()) >= 0) {
                        this.gatherGlobalStatistics(objCfg);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Wait for statistics configuration to process global statistics request " + req.reqId());
                    }
                }
            }
            if ((objStatistics = this.getGlobalStatistics(key, req.versions())) != null && (removed = this.removeFromRequests(this.inGloblaRequests, key, req.reqId())) != null) {
                this.sendResponse(nodeId, req.reqId(), key, StatisticsType.GLOBAL, objStatistics);
            }
        } else {
            this.sendResponse(nodeId, req.reqId(), key, StatisticsType.GLOBAL, objStatistics);
        }
    }

    private boolean hasCurrentCollection(StatisticsKey key, Map<String, Long> versions) {
        StatisticsGatheringContext ctx = (StatisticsGatheringContext)this.curCollections.get(key);
        if (ctx == null) {
            return false;
        }
        return StatisticsUtils.compareVersions(ctx.configuration(), versions) == 0;
    }

    private ObjectStatisticsImpl getGlobalStatistics(StatisticsKey key, Map<String, Long> versions) {
        CacheEntry objStatEntry = (CacheEntry)this.globalStatistics.get(key);
        if (objStatEntry == null || StatisticsUtils.compareVersions((ObjectStatisticsImpl)objStatEntry.object(), versions) != 0) {
            return null;
        }
        return (ObjectStatisticsImpl)objStatEntry.object();
    }

    private void sendResponse(UUID nodeId, UUID reqId, StatisticsKey key, StatisticsType type, ObjectStatisticsImpl data) throws IgniteCheckedException {
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(key.schema(), key.obj(), null);
        StatisticsObjectData dataMsg = StatisticsUtils.toObjectData(keyMsg, type, data);
        this.send(nodeId, new StatisticsResponse(reqId, dataMsg));
    }

    private void addToRequests(ConcurrentMap<StatisticsKey, Collection<StatisticsAddressedRequest>> map, StatisticsKey key, StatisticsAddressedRequest req) {
        map.compute(key, (k, v) -> {
            if (v == null) {
                v = new ArrayList<StatisticsAddressedRequest>();
            }
            v.add(req);
            return v;
        });
    }

    private StatisticsAddressedRequest removeFromRequests(ConcurrentMap<StatisticsKey, Collection<StatisticsAddressedRequest>> map, StatisticsKey key, UUID reqId) {
        StatisticsAddressedRequest[] res = new StatisticsAddressedRequest[1];
        map.compute(key, (k, v) -> {
            if (v != null) {
                res[0] = v.stream().filter(e -> reqId.equals(e.req().reqId())).findAny().orElse(null);
            }
            if (res[0] != null) {
                v = v.stream().filter(e -> !reqId.equals(e.req().reqId())).collect(Collectors.toList());
            }
            return v;
        });
        return res[0];
    }

    public void onConfigChanged(StatisticsObjectConfiguration cfg) {
        StatisticsKey key = cfg.key();
        this.curCollections.remove(key);
        this.outGlobalStatisticsRequests.remove(key);
        this.inLocalRequests.computeIfPresent(key, (k, v) -> {
            v.removeIf(req -> StatisticsUtils.compareVersions(cfg, req.req().versions()) > 0);
            return v.isEmpty() ? null : v;
        });
        this.inGloblaRequests.computeIfPresent(key, (k, v) -> {
            v.removeIf(req -> StatisticsUtils.compareVersions(cfg, req.req().versions()) > 0);
            return v.isEmpty() ? null : v;
        });
        if (cfg.columns().isEmpty()) {
            this.globalStatistics.remove(key);
        } else {
            this.globalStatistics.computeIfPresent(key, (k, v) -> {
                if (v != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Scheduling global statistics recollection by key " + key);
                    }
                    this.mgmtPool.submit(() -> this.collectGlobalStatistics(key));
                }
                return v;
            });
        }
    }

    public void clearGlobalStatistics(StatisticsKey key, Set<String> colNames) {
        this.globalStatistics.computeIfPresent(key, (k, v) -> {
            ObjectStatisticsImpl globStatOld = (ObjectStatisticsImpl)v.object();
            ObjectStatisticsImpl globStatNew = globStatOld == null ? null : (ObjectStatisticsImpl)globStatOld.subtract(colNames);
            return globStatNew == null || globStatNew.columnsStatistics().isEmpty() ? null : new CacheEntry<ObjectStatisticsImpl>(globStatNew);
        });
        this.outGlobalStatisticsRequests.remove(key);
    }

    private void processLocalResponse(UUID nodeId, StatisticsResponse resp) throws IgniteCheckedException {
        StatisticsGatheringContext curCtx;
        StatisticsKeyMessage keyMsg = resp.data().key();
        StatisticsKey key = new StatisticsKey(keyMsg.schema(), resp.data().key().obj());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got local statistics response " + resp.reqId() + " from node " + nodeId + " by key " + key);
        }
        if ((curCtx = (StatisticsGatheringContext)this.curCollections.get(key)) != null) {
            if (!curCtx.reqId().equals(resp.reqId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Got outdated local statistics response " + resp + " instead of " + curCtx.reqId());
                }
                return;
            }
            ObjectStatisticsImpl data = StatisticsUtils.toObjectStatistics(null, resp.data());
            if (curCtx.registerResponse(data)) {
                StatisticsObjectConfiguration cfg = this.statMgr.statisticConfiguration().config(key);
                if (cfg != null) {
                    Collection globalRequests;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Aggregating global statistics for key " + key + " by request " + curCtx.reqId());
                    }
                    ObjectStatisticsImpl globalStat = this.helper.aggregateLocalStatistics(cfg, curCtx.collectedData());
                    this.globalStatistics.put(key, new CacheEntry<ObjectStatisticsImpl>(globalStat));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Global statistics for key " + key + " collected.");
                    }
                    if ((globalRequests = (Collection)this.inGloblaRequests.remove(key)) != null) {
                        StatisticsObjectData globalStatData = StatisticsUtils.toObjectData(keyMsg, StatisticsType.GLOBAL, globalStat);
                        for (StatisticsAddressedRequest req : globalRequests) {
                            StatisticsResponse outResp = new StatisticsResponse(req.req().reqId(), globalStatData);
                            this.send(req.nodeId(), outResp);
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Dropping collected statistics due to lack of configuration for key " + key);
                }
                this.curCollections.remove(key);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Got outdated local statistics response " + resp);
        }
    }

    private void processGlobalResponse(UUID nodeId, StatisticsResponse resp) throws IgniteCheckedException {
        UUID reqId;
        StatisticsKeyMessage keyMsg = resp.data().key();
        StatisticsKey key = new StatisticsKey(keyMsg.schema(), keyMsg.obj());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got global statistics response " + resp.reqId() + " from node " + nodeId + " by key " + key);
        }
        if ((reqId = (UUID)this.outGlobalStatisticsRequests.get(key)) != null) {
            if (!resp.reqId().equals(reqId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Got outdated global statistics response " + resp + " instead of " + reqId);
                }
                return;
            }
            ObjectStatisticsImpl data = StatisticsUtils.toObjectStatistics(null, resp.data());
            this.globalStatistics.put(key, new CacheEntry<ObjectStatisticsImpl>(data));
            this.outGlobalStatisticsRequests.remove(key);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Got outdated global statistics response " + resp);
        }
    }

    private UUID getStatisticsMasterNode(StatisticsKey key) {
        UUID[] nodes = (UUID[])this.discoMgr.aliveServerNodes().stream().map(ClusterNode::id).sorted().toArray(UUID[]::new);
        int idx = IgniteUtils.hashToIndex(key.obj().hashCode(), nodes.length);
        return nodes[idx];
    }

    public void onLocalStatisticsAggregated(StatisticsKey key, ObjectStatisticsImpl statistics, AffinityTopologyVersion topVer) {
        ArrayList inReqs = new ArrayList();
        this.inLocalRequests.computeIfPresent(key, (k, v) -> {
            ArrayList<StatisticsAddressedRequest> left = new ArrayList<StatisticsAddressedRequest>();
            for (StatisticsAddressedRequest req : v) {
                if (topVer.equals(req.req().topVer()) && StatisticsUtils.compareVersions(statistics, req.req().versions()) == 0) {
                    inReqs.add(req);
                    continue;
                }
                left.add(req);
            }
            return left.isEmpty() ? null : left;
        });
        if (inReqs.isEmpty()) {
            return;
        }
        for (StatisticsAddressedRequest req : inReqs) {
            try {
                this.sendResponse(req.nodeId(), req.req().reqId(), key, StatisticsType.LOCAL, statistics);
            }
            catch (IgniteCheckedException e) {
                this.log.info("Unable to send local object statistics for key " + key + " due to " + e.getMessage());
            }
        }
    }

    private void send(UUID nodeId, StatisticsRequest msg) throws IgniteCheckedException {
        if (this.discoMgr.localNode().id().equals(nodeId)) {
            switch (msg.type()) {
                case LOCAL: {
                    this.processLocalRequest(nodeId, msg);
                    break;
                }
                default: {
                    this.log.warning("Unexpected type " + (Object)((Object)msg.type()) + " in statistics request message " + msg);
                    break;
                }
            }
        } else {
            this.ioMgr.sendToGridTopic(nodeId, GridTopic.TOPIC_STATISTICS, (Message)msg, (byte)3);
        }
    }

    private void send(UUID nodeId, StatisticsResponse msg) throws IgniteCheckedException {
        if (this.discoMgr.localNode().id().equals(nodeId)) {
            switch (msg.data().type()) {
                case LOCAL: {
                    this.processLocalResponse(nodeId, msg);
                    break;
                }
                case GLOBAL: {
                    this.processGlobalResponse(nodeId, msg);
                    break;
                }
                default: {
                    this.log.warning("Unexpected type " + (Object)((Object)msg.data().type()) + " in statistics response message " + msg);
                    break;
                }
            }
        } else {
            this.ioMgr.sendToGridTopic(nodeId, GridTopic.TOPIC_STATISTICS, (Message)msg, (byte)3);
        }
    }

    private static class StatisticsGatheringContext {
        private int remainingResponses;
        private final UUID reqId;
        private final Collection<ObjectStatisticsImpl> responses = new ArrayList<ObjectStatisticsImpl>();
        private final StatisticsObjectConfiguration cfg;

        public StatisticsGatheringContext(int responseCont, UUID reqId, StatisticsObjectConfiguration cfg) {
            this.remainingResponses = responseCont;
            this.reqId = reqId;
            this.cfg = cfg;
        }

        public synchronized boolean registerResponse(ObjectStatisticsImpl data) {
            this.responses.add(data);
            return --this.remainingResponses == 0;
        }

        public UUID reqId() {
            return this.reqId;
        }

        public Collection<ObjectStatisticsImpl> collectedData() {
            assert (this.remainingResponses == 0);
            return this.responses;
        }

        public StatisticsObjectConfiguration configuration() {
            return this.cfg;
        }
    }

    private static class CacheEntry<T> {
        private final T obj;

        public CacheEntry(T obj) {
            this.obj = obj;
        }

        public T object() {
            return this.obj;
        }
    }
}

