/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryMemoryAllocator;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientMessage;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientGetIdleTimeoutRequest;
import org.apache.ignite.internal.processors.platform.client.ClientOutgoingMessage;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientRawRequest;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResourceCloseRequest;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryConfigurationGetRequest;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryTypeGetRequest;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryTypeNameGetRequest;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryTypeNamePutRequest;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryTypePutRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheClearKeyRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheClearKeysRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheClearRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheContainsKeyRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheContainsKeysRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheCreateWithConfigurationRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheCreateWithNameRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDestroyRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetAllRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetAndPutIfAbsentRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetAndPutRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetAndRemoveRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetAndReplaceRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetConfigurationRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetNamesRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetOrCreateWithConfigurationRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetOrCreateWithNameRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheGetSizeRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheIndexQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheLocalPeekRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheNodePartitionsRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionsRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePutAllConflictRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePutAllRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePutIfAbsentRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePutRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryContinuousRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryNextPageRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRemoveAllConflictRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRemoveAllRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRemoveIfEqualsRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRemoveKeyRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRemoveKeysRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheReplaceIfEqualsRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheReplaceRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheScanQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlFieldsQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterChangeStateRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGetStateRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupGetNodeIdsRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupGetNodesDetailsRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupGetNodesEndpointsRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterWalChangeStateRequest;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterWalGetStateRequest;
import org.apache.ignite.internal.processors.platform.client.compute.ClientExecuteTaskRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongCreateRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongExistsRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongRemoveRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongValueAddAndGetRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongValueCompareAndSetAndGetRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongValueCompareAndSetRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongValueGetAndSetRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongValueGetRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetClearRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetCloseRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetExistsRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetGetOrCreateRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetIteratorGetPageRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetIteratorStartRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetSizeRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueAddAllRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueAddRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueContainsAllRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueContainsRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueRemoveAllRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueRemoveRequest;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetValueRetainAllRequest;
import org.apache.ignite.internal.processors.platform.client.service.ClientServiceGetDescriptorRequest;
import org.apache.ignite.internal.processors.platform.client.service.ClientServiceGetDescriptorsRequest;
import org.apache.ignite.internal.processors.platform.client.service.ClientServiceInvokeRequest;
import org.apache.ignite.internal.processors.platform.client.service.ClientServiceTopologyRequest;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerAddDataRequest;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerStartRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxEndRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxStartRequest;

public class ClientMessageParser
implements ClientListenerMessageParser {
    private static final short OP_RESOURCE_CLOSE = 0;
    private static final short OP_HEARTBEAT = 1;
    private static final short OP_GET_IDLE_TIMEOUT = 2;
    private static final short OP_CACHE_GET = 1000;
    private static final short OP_CACHE_PUT = 1001;
    private static final short OP_CACHE_PUT_IF_ABSENT = 1002;
    private static final short OP_CACHE_GET_ALL = 1003;
    private static final short OP_CACHE_PUT_ALL = 1004;
    private static final short OP_CACHE_GET_AND_PUT = 1005;
    private static final short OP_CACHE_GET_AND_REPLACE = 1006;
    private static final short OP_CACHE_GET_AND_REMOVE = 1007;
    private static final short OP_CACHE_GET_AND_PUT_IF_ABSENT = 1008;
    private static final short OP_CACHE_REPLACE = 1009;
    private static final short OP_CACHE_REPLACE_IF_EQUALS = 1010;
    private static final short OP_CACHE_CONTAINS_KEY = 1011;
    private static final short OP_CACHE_CONTAINS_KEYS = 1012;
    private static final short OP_CACHE_CLEAR = 1013;
    private static final short OP_CACHE_CLEAR_KEY = 1014;
    private static final short OP_CACHE_CLEAR_KEYS = 1015;
    private static final short OP_CACHE_REMOVE_KEY = 1016;
    private static final short OP_CACHE_REMOVE_IF_EQUALS = 1017;
    private static final short OP_CACHE_REMOVE_KEYS = 1018;
    private static final short OP_CACHE_REMOVE_ALL = 1019;
    private static final short OP_CACHE_GET_SIZE = 1020;
    private static final short OP_CACHE_LOCAL_PEEK = 1021;
    private static final short OP_CACHE_PUT_ALL_CONFLICT = 1022;
    private static final short OP_CACHE_REMOVE_ALL_CONFLICT = 1023;
    private static final short OP_CACHE_GET_NAMES = 1050;
    private static final short OP_CACHE_CREATE_WITH_NAME = 1051;
    private static final short OP_CACHE_GET_OR_CREATE_WITH_NAME = 1052;
    private static final short OP_CACHE_CREATE_WITH_CONFIGURATION = 1053;
    private static final short OP_CACHE_GET_OR_CREATE_WITH_CONFIGURATION = 1054;
    private static final short OP_CACHE_GET_CONFIGURATION = 1055;
    private static final short OP_CACHE_DESTROY = 1056;
    private static final short OP_CACHE_NODE_PARTITIONS = 1100;
    private static final short OP_CACHE_PARTITIONS = 1101;
    private static final short OP_QUERY_SCAN = 2000;
    private static final short OP_QUERY_SCAN_CURSOR_GET_PAGE = 2001;
    private static final short OP_QUERY_SQL = 2002;
    private static final short OP_QUERY_SQL_CURSOR_GET_PAGE = 2003;
    private static final short OP_QUERY_SQL_FIELDS = 2004;
    private static final short OP_QUERY_SQL_FIELDS_CURSOR_GET_PAGE = 2005;
    private static final short OP_QUERY_CONTINUOUS = 2006;
    public static final short OP_QUERY_CONTINUOUS_EVENT_NOTIFICATION = 2007;
    private static final short OP_QUERY_INDEX = 2008;
    private static final short OP_QUERY_INDEX_CURSOR_GET_PAGE = 2009;
    private static final short OP_BINARY_TYPE_NAME_GET = 3000;
    private static final short OP_BINARY_TYPE_NAME_PUT = 3001;
    private static final short OP_BINARY_TYPE_GET = 3002;
    private static final short OP_BINARY_TYPE_PUT = 3003;
    private static final short OP_BINARY_CONFIGURATION_GET = 3004;
    private static final short OP_TX_START = 4000;
    private static final short OP_TX_END = 4001;
    private static final short OP_CLUSTER_GET_STATE = 5000;
    private static final short OP_CLUSTER_CHANGE_STATE = 5001;
    private static final short OP_CLUSTER_CHANGE_WAL_STATE = 5002;
    private static final short OP_CLUSTER_GET_WAL_STATE = 5003;
    private static final short OP_CLUSTER_GROUP_GET_NODE_IDS = 5100;
    private static final short OP_CLUSTER_GROUP_GET_NODE_INFO = 5101;
    private static final short OP_CLUSTER_GROUP_GET_NODE_ENDPOINTS = 5102;
    private static final short OP_COMPUTE_TASK_EXECUTE = 6000;
    public static final short OP_COMPUTE_TASK_FINISHED = 6001;
    private static final short OP_SERVICE_INVOKE = 7000;
    private static final short OP_SERVICE_GET_DESCRIPTORS = 7001;
    private static final short OP_SERVICE_GET_DESCRIPTOR = 7002;
    private static final short OP_DATA_STREAMER_START = 8000;
    private static final short OP_DATA_STREAMER_ADD_DATA = 8001;
    private static final short OP_ATOMIC_LONG_CREATE = 9000;
    private static final short OP_ATOMIC_LONG_REMOVE = 9001;
    private static final short OP_ATOMIC_LONG_EXISTS = 9002;
    private static final short OP_ATOMIC_LONG_VALUE_GET = 9003;
    private static final short OP_ATOMIC_LONG_VALUE_ADD_AND_GET = 9004;
    private static final short OP_ATOMIC_LONG_VALUE_GET_AND_SET = 9005;
    private static final short OP_ATOMIC_LONG_VALUE_COMPARE_AND_SET = 9006;
    private static final short OP_ATOMIC_LONG_VALUE_COMPARE_AND_SET_AND_GET = 9007;
    private static final short OP_SET_GET_OR_CREATE = 9010;
    private static final short OP_SET_CLOSE = 9011;
    private static final short OP_SET_EXISTS = 9012;
    private static final short OP_SET_VALUE_ADD = 9013;
    private static final short OP_SET_VALUE_ADD_ALL = 9014;
    private static final short OP_SET_VALUE_REMOVE = 9015;
    private static final short OP_SET_VALUE_REMOVE_ALL = 9016;
    private static final short OP_SET_VALUE_CONTAINS = 9017;
    private static final short OP_SET_VALUE_CONTAINS_ALL = 9018;
    private static final short OP_SET_VALUE_RETAIN_ALL = 9019;
    private static final short OP_SET_SIZE = 9020;
    private static final short OP_SET_CLEAR = 9021;
    private static final short OP_SET_ITERATOR_START = 9022;
    private static final short OP_SET_ITERATOR_GET_PAGE = 9023;
    private static final short OP_SERVICE_GET_TOPOLOGY = 7003;
    private final GridBinaryMarshaller marsh;
    private final ClientConnectionContext ctx;
    private final ClientProtocolContext protocolCtx;

    ClientMessageParser(ClientConnectionContext ctx, ClientProtocolContext protocolCtx) {
        assert (ctx != null);
        assert (protocolCtx != null);
        this.ctx = ctx;
        this.protocolCtx = protocolCtx;
        CacheObjectBinaryProcessorImpl cacheObjProc = (CacheObjectBinaryProcessorImpl)ctx.kernalContext().cacheObjects();
        this.marsh = cacheObjProc.marshaller();
    }

    @Override
    public ClientListenerRequest decode(ClientMessage msg) {
        assert (msg != null);
        BinaryHeapInputStream inStream = new BinaryHeapInputStream(msg.payload());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(this.marsh.context(), inStream, null, null, true, true);
        return this.decode(reader);
    }

    public ClientListenerRequest decode(BinaryReaderExImpl reader) {
        short opCode = reader.readShort();
        switch (opCode) {
            case 1000: {
                return new ClientCacheGetRequest(reader);
            }
            case 3000: {
                return new ClientBinaryTypeNameGetRequest(reader);
            }
            case 3002: {
                return new ClientBinaryTypeGetRequest(reader);
            }
            case 1001: {
                return new ClientCachePutRequest(reader);
            }
            case 3001: {
                return new ClientBinaryTypeNamePutRequest(reader);
            }
            case 3003: {
                return new ClientBinaryTypePutRequest(reader);
            }
            case 3004: {
                return new ClientBinaryConfigurationGetRequest(reader);
            }
            case 2000: {
                return new ClientCacheScanQueryRequest(reader);
            }
            case 2001: 
            case 2003: 
            case 2009: {
                return new ClientCacheQueryNextPageRequest(reader);
            }
            case 0: {
                return new ClientResourceCloseRequest(reader);
            }
            case 1: {
                return new ClientRequest(reader);
            }
            case 2: {
                return new ClientGetIdleTimeoutRequest(reader);
            }
            case 1011: {
                return new ClientCacheContainsKeyRequest(reader);
            }
            case 1012: {
                return new ClientCacheContainsKeysRequest(reader);
            }
            case 1003: {
                return new ClientCacheGetAllRequest(reader);
            }
            case 1005: {
                return new ClientCacheGetAndPutRequest(reader);
            }
            case 1006: {
                return new ClientCacheGetAndReplaceRequest(reader);
            }
            case 1007: {
                return new ClientCacheGetAndRemoveRequest(reader);
            }
            case 1002: {
                return new ClientCachePutIfAbsentRequest(reader);
            }
            case 1008: {
                return new ClientCacheGetAndPutIfAbsentRequest(reader);
            }
            case 1009: {
                return new ClientCacheReplaceRequest(reader);
            }
            case 1010: {
                return new ClientCacheReplaceIfEqualsRequest(reader);
            }
            case 1004: {
                return new ClientCachePutAllRequest(reader);
            }
            case 1013: {
                return new ClientCacheClearRequest(reader);
            }
            case 1014: {
                return new ClientCacheClearKeyRequest(reader);
            }
            case 1015: {
                return new ClientCacheClearKeysRequest(reader);
            }
            case 1016: {
                return new ClientCacheRemoveKeyRequest(reader);
            }
            case 1017: {
                return new ClientCacheRemoveIfEqualsRequest(reader);
            }
            case 1020: {
                return new ClientCacheGetSizeRequest(reader);
            }
            case 1018: {
                return new ClientCacheRemoveKeysRequest(reader);
            }
            case 1021: {
                return new ClientCacheLocalPeekRequest(reader);
            }
            case 1019: {
                return new ClientCacheRemoveAllRequest(reader);
            }
            case 1022: {
                return new ClientCachePutAllConflictRequest(reader, this.ctx);
            }
            case 1023: {
                return new ClientCacheRemoveAllConflictRequest(reader);
            }
            case 1051: {
                return new ClientCacheCreateWithNameRequest(reader);
            }
            case 1052: {
                return new ClientCacheGetOrCreateWithNameRequest(reader);
            }
            case 1056: {
                return new ClientCacheDestroyRequest(reader);
            }
            case 1100: {
                return new ClientCacheNodePartitionsRequest(reader);
            }
            case 1101: {
                return new ClientCachePartitionsRequest(reader, this.protocolCtx);
            }
            case 1050: {
                return new ClientCacheGetNamesRequest(reader);
            }
            case 1055: {
                return new ClientCacheGetConfigurationRequest(reader, this.protocolCtx);
            }
            case 1053: {
                return new ClientCacheCreateWithConfigurationRequest(reader, this.protocolCtx);
            }
            case 1054: {
                return new ClientCacheGetOrCreateWithConfigurationRequest(reader, this.protocolCtx);
            }
            case 2002: {
                return new ClientCacheSqlQueryRequest(reader);
            }
            case 2004: {
                return new ClientCacheSqlFieldsQueryRequest(reader, this.protocolCtx);
            }
            case 2005: {
                return new ClientCacheQueryNextPageRequest(reader);
            }
            case 2006: {
                return new ClientCacheQueryContinuousRequest(reader);
            }
            case 2008: {
                return new ClientCacheIndexQueryRequest(reader, this.protocolCtx);
            }
            case 4000: {
                return new ClientTxStartRequest(reader);
            }
            case 4001: {
                return new ClientTxEndRequest(reader);
            }
            case 5000: {
                return new ClientClusterGetStateRequest(reader);
            }
            case 5001: {
                return new ClientClusterChangeStateRequest(reader);
            }
            case 5002: {
                return new ClientClusterWalChangeStateRequest(reader);
            }
            case 5003: {
                return new ClientClusterWalGetStateRequest(reader);
            }
            case 5100: {
                return new ClientClusterGroupGetNodeIdsRequest(reader);
            }
            case 5101: {
                return new ClientClusterGroupGetNodesDetailsRequest(reader);
            }
            case 5102: {
                return new ClientClusterGroupGetNodesEndpointsRequest(reader);
            }
            case 6000: {
                return new ClientExecuteTaskRequest(reader);
            }
            case 7000: {
                return new ClientServiceInvokeRequest(reader, this.protocolCtx);
            }
            case 7001: {
                return new ClientServiceGetDescriptorsRequest(reader);
            }
            case 7002: {
                return new ClientServiceGetDescriptorRequest(reader);
            }
            case 8000: {
                return new ClientDataStreamerStartRequest(reader);
            }
            case 8001: {
                return new ClientDataStreamerAddDataRequest(reader);
            }
            case 9000: {
                return new ClientAtomicLongCreateRequest(reader);
            }
            case 9001: {
                return new ClientAtomicLongRemoveRequest(reader);
            }
            case 9002: {
                return new ClientAtomicLongExistsRequest(reader);
            }
            case 9003: {
                return new ClientAtomicLongValueGetRequest(reader);
            }
            case 9004: {
                return new ClientAtomicLongValueAddAndGetRequest(reader);
            }
            case 9005: {
                return new ClientAtomicLongValueGetAndSetRequest(reader);
            }
            case 9006: {
                return new ClientAtomicLongValueCompareAndSetRequest(reader);
            }
            case 9007: {
                return new ClientAtomicLongValueCompareAndSetAndGetRequest(reader);
            }
            case 9010: {
                return new ClientIgniteSetGetOrCreateRequest(reader);
            }
            case 9011: {
                return new ClientIgniteSetCloseRequest(reader);
            }
            case 9012: {
                return new ClientIgniteSetExistsRequest(reader);
            }
            case 9013: {
                return new ClientIgniteSetValueAddRequest(reader);
            }
            case 9014: {
                return new ClientIgniteSetValueAddAllRequest(reader);
            }
            case 9015: {
                return new ClientIgniteSetValueRemoveRequest(reader);
            }
            case 9016: {
                return new ClientIgniteSetValueRemoveAllRequest(reader);
            }
            case 9017: {
                return new ClientIgniteSetValueContainsRequest(reader);
            }
            case 9018: {
                return new ClientIgniteSetValueContainsAllRequest(reader);
            }
            case 9019: {
                return new ClientIgniteSetValueRetainAllRequest(reader);
            }
            case 9020: {
                return new ClientIgniteSetSizeRequest(reader);
            }
            case 9021: {
                return new ClientIgniteSetClearRequest(reader);
            }
            case 9022: {
                return new ClientIgniteSetIteratorStartRequest(reader);
            }
            case 9023: {
                return new ClientIgniteSetIteratorGetPageRequest(reader);
            }
            case 7003: {
                return new ClientServiceTopologyRequest(reader);
            }
        }
        return new ClientRawRequest(reader.readLong(), 2, "Invalid request op code: " + opCode);
    }

    @Override
    public ClientMessage encode(ClientListenerResponse resp) {
        assert (resp != null);
        BinaryHeapOutputStream outStream = new BinaryHeapOutputStream(32, BinaryMemoryAllocator.POOLED.chunk());
        BinaryWriterExImpl writer = this.marsh.writer(outStream);
        assert (resp instanceof ClientOutgoingMessage) : "Unexpected response type: " + resp.getClass();
        ((ClientOutgoingMessage)((Object)resp)).encode(this.ctx, writer);
        return new ClientMessage(outStream);
    }

    @Override
    public int decodeCommandType(ClientMessage msg) {
        assert (msg != null);
        BinaryHeapInputStream inStream = new BinaryHeapInputStream(msg.payload());
        return inStream.readShort();
    }

    @Override
    public long decodeRequestId(ClientMessage msg) {
        return 0L;
    }
}

