/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class MvccAckRequestTx
implements MvccMessage {
    private static final long serialVersionUID = 0L;
    private static final int SKIP_RESPONSE_FLAG_MASK = 1;
    private long futId;
    private long txCntr;
    private byte flags;

    public MvccAckRequestTx() {
    }

    public MvccAckRequestTx(long futId, long txCntr) {
        this.futId = futId;
        this.txCntr = txCntr;
    }

    public long queryCounter() {
        return 0L;
    }

    public long queryTrackerId() {
        return -1L;
    }

    @Override
    public boolean waitForCoordinatorInit() {
        return false;
    }

    @Override
    public boolean processedFromNioThread() {
        return true;
    }

    public long futureId() {
        return this.futId;
    }

    public boolean skipResponse() {
        return (this.flags & 1) != 0;
    }

    public void skipResponse(boolean val) {
        this.flags = val ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public long txCounter() {
        return this.txCntr;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("txCntr", this.txCntr)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.txCntr = reader.readLong("txCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(MvccAckRequestTx.class);
    }

    @Override
    public short directType() {
        return 137;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(MvccAckRequestTx.class, this);
    }
}

