/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class MvccQueryTrackerImpl
implements MvccQueryTracker {
    @GridToStringExclude
    private final GridCacheContext cctx;
    @GridToStringExclude
    private final IgniteLogger log;
    private long crdVer;
    private final long id;
    private Object state;
    private volatile AffinityTopologyVersion topVer;
    private boolean done;

    public MvccQueryTrackerImpl(GridCacheContext cctx) {
        this.cctx = cctx;
        this.id = ID_CNTR.incrementAndGet();
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public long id() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MvccSnapshot snapshot() {
        Object state0;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            state0 = this.state;
        }
        return this.snapshot(state0);
    }

    private MvccSnapshot snapshot(Object state) {
        if (state != null && state.getClass() == SnapshotFuture.class) {
            return (MvccSnapshot)((SnapshotFuture)state).result();
        }
        return (MvccSnapshot)state;
    }

    @Override
    public GridCacheContext context() {
        return this.cctx;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot() {
        SnapshotFuture fut;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            if (this.state != null) {
                if (this.state.getClass() == SnapshotFuture.class) {
                    return (IgniteInternalFuture)this.state;
                }
                return new GridFinishedFuture<MvccSnapshot>((MvccSnapshot)this.state);
            }
            fut = new SnapshotFuture();
            this.state = fut;
        }
        this.requestSnapshot0(this.cctx.shared().exchange().readyAffinityVersion(), fut);
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDone() {
        Object state0;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            if (this.done) {
                return;
            }
            state0 = this.state;
            this.done = true;
        }
        this.cctx.shared().coordinators().removeQueryTracker(this.id);
        if (state0 != null && state0.getClass() == SnapshotFuture.class) {
            ((SnapshotFuture)state0).cancel();
        } else {
            this.ackQueryDone((MvccSnapshot)state0);
        }
    }

    @Override
    public synchronized long onMvccCoordinatorChange(@NotNull MvccCoordinator newCrd) {
        if (this.snapshot(this.state) != null) {
            assert (this.crdVer != 0L) : this;
            if (this.crdVer != newCrd.version()) {
                this.crdVer = newCrd.version();
                return this.id;
            }
            return -1L;
        }
        if (this.crdVer != 0L) {
            this.crdVer = 0L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSnapshot0(@NotNull AffinityTopologyVersion topVer, @NotNull MvccSnapshotResponseListener lsnr) {
        MvccCoordinator crd = this.coordinator();
        AffinityTopologyVersion crdTopVer = crd.topologyVersion();
        if (!crdTopVer.initialized()) {
            lsnr.onError(MvccUtils.noCoordinatorError());
        } else if (crdTopVer.compareTo(topVer) <= 0) {
            MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
            synchronized (mvccQueryTrackerImpl) {
                if (this.done) {
                    return;
                }
                this.crdVer = crd.version();
            }
            this.topVer = topVer;
            this.cctx.shared().coordinators().addQueryTracker(this);
            this.cctx.shared().coordinators().requestReadSnapshotAsync(crd, lsnr);
        } else {
            this.remap(crdTopVer, lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onResponse0(@NotNull MvccSnapshot res, @NotNull MvccSnapshotResponseListener lsnr) {
        boolean ackQueryDone = false;
        boolean needRemap = false;
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            assert (this.snapshot(this.state) == null) : "[this=" + this + ", rcvdVer=" + res + "]";
            if (!this.done && this.crdVer != 0L) {
                this.state = res;
                return true;
            }
            if (this.crdVer != 0L) {
                ackQueryDone = true;
            } else if (!this.done) {
                needRemap = true;
            }
        }
        if (needRemap) {
            this.tryRemap(this.coordinator().topologyVersion(), lsnr);
        } else if (ackQueryDone) {
            this.ackQueryDone(res);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onError0(IgniteCheckedException e, @NotNull MvccSnapshotResponseListener lsnr) {
        MvccQueryTrackerImpl mvccQueryTrackerImpl = this;
        synchronized (mvccQueryTrackerImpl) {
            if (this.done) {
                return false;
            }
        }
        if (e instanceof ClusterTopologyCheckedException && !(e instanceof ClusterTopologyServerNotFoundException)) {
            this.tryRemap(this.coordinator().topologyVersion(), lsnr);
            return false;
        }
        this.cctx.shared().coordinators().removeQueryTracker(this.id);
        return true;
    }

    private void tryRemap(@NotNull AffinityTopologyVersion mapVer, @NotNull MvccSnapshotResponseListener lsnr) {
        if (!mapVer.initialized()) {
            lsnr.onError(MvccUtils.noCoordinatorError());
        } else {
            this.remap(mapVer, lsnr);
        }
    }

    private void remap(@NotNull AffinityTopologyVersion mapVer, @NotNull MvccSnapshotResponseListener lsnr) {
        AffinityTopologyVersion topVer0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Mvcc coordinator failed or reassigned, need remap.");
        }
        if ((topVer0 = this.topVer) != null && topVer0.compareTo(mapVer) >= 0) {
            mapVer = topVer0.nextMinorVersion();
        }
        assert (topVer0 == null || mapVer.compareTo(topVer0) > 0) : "topVer=" + topVer0 + ", nextTopVer=" + mapVer;
        IgniteInternalFuture<AffinityTopologyVersion> readyFut = this.cctx.shared().exchange().affinityReadyFuture(mapVer);
        assert (readyFut != null);
        if (readyFut.isDone()) {
            this.onAffinityReady(readyFut, lsnr);
        } else {
            readyFut.listen(() -> this.onAffinityReady(readyFut, lsnr));
        }
    }

    private void onAffinityReady(@NotNull IgniteInternalFuture<AffinityTopologyVersion> readyFut, @NotNull MvccSnapshotResponseListener lsnr) {
        try {
            AffinityTopologyVersion mapVer = readyFut.get();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Remap on new topology: " + mapVer);
            }
            this.requestSnapshot0(mapVer, lsnr);
        }
        catch (IgniteCheckedException e) {
            lsnr.onError(e);
        }
    }

    private void ackQueryDone(MvccSnapshot snapshot) {
        if (snapshot != null) {
            this.cctx.shared().coordinators().ackQueryDone(snapshot, this.id);
        }
    }

    @NotNull
    private MvccCoordinator coordinator() {
        return this.cctx.shared().coordinators().currentCoordinator();
    }

    public String toString() {
        return S.toString(MvccQueryTrackerImpl.class, this);
    }

    private final class SnapshotFuture
    extends MvccSnapshotFuture {
        private SnapshotFuture() {
        }

        @Override
        public void onResponse(MvccSnapshot res) {
            if (MvccQueryTrackerImpl.this.onResponse0(res, this)) {
                super.onResponse(res);
            }
        }

        @Override
        public void onError(IgniteCheckedException e) {
            if (MvccQueryTrackerImpl.this.onError0(e, this)) {
                super.onError(e);
            }
        }

        @Override
        public boolean cancel() {
            return this.onCancelled();
        }
    }
}

