/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnConfigurationView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class StatisticsColumnConfigurationViewWalker
implements SystemViewRowAttributeWalker<StatisticsColumnConfigurationView> {
    public static final String SCHEMA_FILTER = "schema";
    public static final String TYPE_FILTER = "type";
    public static final String NAME_FILTER = "name";
    public static final String COLUMN_FILTER = "column";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(new String[]{"schema", "type", "name", "column"}));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class);
        v.accept(1, TYPE_FILTER, String.class);
        v.accept(2, NAME_FILTER, String.class);
        v.accept(3, COLUMN_FILTER, String.class);
        v.accept(4, "maxPartitionObsolescencePercent", Byte.TYPE);
        v.accept(5, "manualNulls", Long.class);
        v.accept(6, "manualDistinct", Long.class);
        v.accept(7, "manualTotal", Long.class);
        v.accept(8, "manualSize", Integer.class);
        v.accept(9, "version", Long.TYPE);
    }

    @Override
    public void visitAll(StatisticsColumnConfigurationView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class, row.schema());
        v.accept(1, TYPE_FILTER, String.class, row.type());
        v.accept(2, NAME_FILTER, String.class, row.name());
        v.accept(3, COLUMN_FILTER, String.class, row.column());
        v.acceptByte(4, "maxPartitionObsolescencePercent", row.maxPartitionObsolescencePercent());
        v.accept(5, "manualNulls", Long.class, row.manualNulls());
        v.accept(6, "manualDistinct", Long.class, row.manualDistinct());
        v.accept(7, "manualTotal", Long.class, row.manualTotal());
        v.accept(8, "manualSize", Integer.class, row.manualSize());
        v.acceptLong(9, "version", row.version());
    }

    @Override
    public int count() {
        return 10;
    }
}

