/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.ui.EditableHeader;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableColumnModel;

public class EditableHeaderUI
extends BasicTableHeaderUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler((EditableHeader)this.header);
    }

    public class MouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        private Component dispatchComponent;
        protected EditableHeader header;

        public MouseInputHandler(EditableHeader header) {
            super(EditableHeaderUI.this);
            this.header = header;
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = this.header.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(this.header, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(this.header, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            super.mousePressed(e);
            if (this.header.getResizingColumn() == null) {
                Point p = e.getPoint();
                TableColumnModel columnModel = this.header.getColumnModel();
                int index = columnModel.getColumnIndexAtX(p.x);
                if (index != -1 && this.header.editCellAt(index, e)) {
                    this.setDispatchComponent(e);
                    this.repostEvent(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.repostEvent(e);
            this.dispatchComponent = null;
        }
    }
}

