/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.font.ttf.CMap;
import com.sun.pdfview.font.ttf.CMapFormat0;
import com.sun.pdfview.font.ttf.CMapFormat4;
import com.sun.pdfview.font.ttf.CmapTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.NameTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TTFTest {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: ");
            System.out.println("    TTFTest <input file> <output file>");
            System.exit(-1);
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(args[0], "r");
            int size = (int)raf.length();
            byte[] data = new byte[size];
            raf.readFully(data);
            TrueTypeFont ttf = TrueTypeFont.parseFont(data);
            MaxpTable maxp = (MaxpTable)ttf.getTable("maxp");
            int nglyphs = maxp.getNumGlyphs();
            if (ttf.getTable("cmap") == null) {
                byte[] map = new byte[256];
                for (int i = 0; i < map.length; ++i) {
                    map[i] = i < nglyphs ? (byte)i : (byte)0;
                }
                CMapFormat0 newMap = (CMapFormat0)CMap.createMap((short)0, (short)0);
                newMap.setMap(map);
                CMapFormat4 newMap4 = (CMapFormat4)CMap.createMap((short)4, (short)0);
                newMap4.addSegment((short)1, (short)(nglyphs + 0), (short)0);
                CmapTable cmap = (CmapTable)TrueTypeTable.createTable(ttf, "cmap");
                cmap.addCMap((short)1, (short)0, newMap);
                cmap.addCMap((short)3, (short)1, newMap4);
                ttf.addTable("cmap", cmap);
            }
            if (ttf.getTable("name") == null) {
                NameTable name = (NameTable)TrueTypeTable.createTable(ttf, "name");
                short platID = 1;
                short encID = 0;
                short langID = 0;
                platID = 3;
                encID = 1;
                langID = 1033;
                name.addRecord(platID, encID, langID, (short)0, "Copyright (c) 2000 Bigelow & Holmes Inc. Pat. Des 289,421.");
                name.addRecord(platID, encID, langID, (short)1, "Lucida Bright");
                name.addRecord(platID, encID, langID, (short)2, "Regular");
                name.addRecord(platID, encID, langID, (short)3, "Lucida Bright Regular: B&H:2000");
                name.addRecord(platID, encID, langID, (short)4, "Lucida Bright Regular");
                name.addRecord(platID, encID, langID, (short)5, "January 28, 2000; 1.10 (JAVA)");
                name.addRecord(platID, encID, langID, (short)6, "LucidaBright");
                name.addRecord(platID, encID, langID, (short)7, "Lucida is a registered trademark of Bigelow & Holmes Inc.");
                ttf.addTable("name", name);
            }
            ttf.getTable("head");
            ttf.getTable("hhea");
            System.out.println(ttf);
            if (args.length == 2) {
                FileOutputStream fis = new FileOutputStream(args[1]);
                fis.write(ttf.writeFont());
                fis.close();
            }
            ByteArrayInputStream fontStream = new ByteArrayInputStream(ttf.writeFont());
            Font f = Font.createFont(0, fontStream);
            System.out.println("Attributes of font " + f.getFontName() + "(" + f.getNumGlyphs() + "):");
            Map<TextAttribute, ?> m = f.getAttributes();
            for (TextAttribute key : m.keySet()) {
                Object value = m.get(key);
                System.out.println(key + " = " + value);
            }
            System.out.println();
            Font f2 = f.deriveFont(18.0f);
            JFrame jf = new JFrame();
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(1);
                }
            });
            JPanel thePanel = new JPanel();
            thePanel.setLayout(new GridLayout(0, 32));
            for (int i = 0; i < nglyphs; ++i) {
                JLabel lbl = new JLabel(Integer.toHexString(i) + ": ");
                JLabel val = new JLabel(String.valueOf((char)i));
                val.setFont(f2);
                thePanel.add(lbl);
                thePanel.add(val);
            }
            JScrollPane jsp = new JScrollPane(thePanel);
            jf.getContentPane().add(jsp);
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

