/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.common;

import cl.mc3d.as4p.common.Definition;
import cl.mc3d.as4p.common.DefinitionOptionsBase;
import cl.mc3d.as4p.common.DefinitionOptionsUse;
import cl.mc3d.as4p.common.Restriction;
import cl.mc3d.as4p.common.Structure;
import cl.mc3d.as4p.common.XPathXSD;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Utility {
    private String letras = new String();
    private final String[] Letras = new String[]{"UNO", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE", "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE", "VEINTE", "TREINTA", "CUARENTA", "CINCUENTA", "SESENTA", "SETENTA", "OCHENTA", "NOVENTA", "CIENTO", "DOSCIENTOS", "TRESCIENTOS", "CUATROCIENTOS", "QUINIENTOS", "SEISCIENTOS", "SETECIENTOS", "OCHOCIENTOS", "NOVECIENTOS"};
    private final Integer[] Valores = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900};

    public String restarFechas(long primero, long ultimo) {
        long lTotal = ultimo - primero;
        long horas = lTotal / 1000L / 60L / 60L;
        long minutos = (lTotal -= horas * 60L * 60L * 1000L) / 1000L / 60L;
        long segundos = (lTotal -= minutos * 60L * 1000L) / 1000L;
        return "" + horas + ":" + minutos + ":" + segundos + "." + (lTotal -= segundos * 1000L);
    }

    public List<XPathXSD> getXPathXSD(String url, boolean debug) {
        ArrayList<XPathXSD> listado = new ArrayList<XPathXSD>();
        try {
            File esquema = new File(url);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Ubicacion del xsd:" + url);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "cargado el xsd:" + esquema.toURI());
            FileReader fr = new FileReader(esquema);
            BufferedReader br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            String linea = "";
            while ((linea = br.readLine()) != null) {
                if (debug) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, linea);
                }
                sb.append(linea);
            }
            String prefijo = "xsd:";
            sb.delete(0, sb.indexOf("<" + prefijo + "element"));
            sb.delete(sb.lastIndexOf("</" + prefijo + "element") + (10 + prefijo.length()), sb.length());
            while (sb.indexOf("> ") != -1) {
                sb.deleteCharAt(sb.indexOf("> ") + 1);
            }
            while (sb.indexOf("<" + prefijo + "complexType>") != -1) {
                sb.delete(sb.indexOf("<" + prefijo + "complexType>"), sb.indexOf("<" + prefijo + "complexType>") + (13 + prefijo.length()));
            }
            while (sb.indexOf("</" + prefijo + "complexType>") != -1) {
                sb.delete(sb.indexOf("</" + prefijo + "complexType>"), sb.indexOf("</" + prefijo + "complexType>") + (14 + prefijo.length()));
            }
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String def = "<?xml version=\"1.0\"  encoding=\"UTF-8\" ?>";
            sb.insert(0, def);
            Document doc = db.parse(new ByteArrayInputStream(sb.toString().getBytes()));
            doc.setXmlStandalone(true);
            this.generateXPathXSD(prefijo, "", doc.getChildNodes(), listado);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.toString());
        }
        return listado;
    }

    private List<XPathXSD> generateXPathXSD(String prefijo, String ruta, NodeList nl, List<XPathXSD> listado) {
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(prefijo + "element")) continue;
            String elemento = ruta + prefijo + nl.item(i).getAttributes().getNamedItem("name").getNodeValue();
            XPathXSD elementoXP = new XPathXSD();
            elementoXP.setPath("/" + elemento);
            listado.add(elementoXP);
            NodeList hijos = nl.item(i).getChildNodes();
            for (int k = 0; k < hijos.getLength(); ++k) {
                if (hijos.item(k).getNodeName().equals(prefijo + "attribute")) {
                    String fixed;
                    String tipo;
                    String atributo = hijos.item(k).getAttributes().getNamedItem("name").getNodeValue();
                    atributo = elemento + "@" + atributo;
                    XPathXSD atributoXP = new XPathXSD();
                    atributoXP.setPath("/" + atributo);
                    String uso = "" + hijos.item(k).getAttributes().getNamedItem("use");
                    if (uso.equals("null")) {
                        uso = "use=\"optional\"";
                    }
                    if ((tipo = "" + hijos.item(k).getAttributes().getNamedItem("type")).equals("null")) {
                        uso = "type=\"" + prefijo + "anySimpleType\"";
                    }
                    if ((fixed = "" + hijos.item(k).getAttributes().getNamedItem("fixed")).equals("null")) {
                        fixed = "fixed=\"\"";
                    }
                    String bind = "bind=\"\"";
                    if (fixed.contains("bind")) {
                        bind = "" + fixed.substring(fixed.indexOf("bind[") + 5, fixed.indexOf("]"));
                        bind = "bind=\"" + bind + "\"";
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "***** Bind:" + bind);
                    }
                    String maxInclusive = "maxInclusive=\"";
                    String minInclusive = "minInclusive=\"";
                    String maxExclusive = "maxExclusive=\"";
                    String minExclusive = "minExclusive=\"";
                    String length = "length=\"";
                    String maxLength = "maxLength=\"";
                    String minLength = "minLength=\"";
                    String pattern = "pattern=\"";
                    String totalDigits = "totalDigits=\"";
                    String enumeracion = "enumeration=\"";
                    if (hijos.item(k).hasChildNodes()) {
                        NodeList nl1 = hijos.item(k).getChildNodes().item(0).getChildNodes().item(0).getChildNodes();
                        for (int m = 0; m < nl1.getLength(); ++m) {
                            NamedNodeMap nnm1 = nl1.item(m).getAttributes();
                            Element element = (Element)nl1.item(m);
                            if (element.getTagName().equals(prefijo + "enumeration")) {
                                if (m > 0) {
                                    enumeracion = enumeracion + ",";
                                }
                                enumeracion = enumeracion + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "maxInclusive")) {
                                maxInclusive = maxInclusive + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "minInclusive")) {
                                minInclusive = minInclusive + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "maxExclusive")) {
                                maxExclusive = maxExclusive + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "minExclusive")) {
                                minExclusive = minExclusive + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "length")) {
                                length = length + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "maxLength")) {
                                maxLength = maxLength + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "minLength")) {
                                minLength = minLength + nnm1.item(0).getNodeValue();
                            }
                            if (element.getTagName().equals(prefijo + "pattern")) {
                                pattern = pattern + nnm1.item(0).getNodeValue();
                            }
                            if (!element.getTagName().equals(prefijo + "totalDigits")) continue;
                            totalDigits = totalDigits + nnm1.item(0).getNodeValue();
                        }
                    }
                    maxInclusive = maxInclusive + "\"";
                    minInclusive = minInclusive + "\"";
                    maxExclusive = maxExclusive + "\"";
                    minExclusive = minExclusive + "\"";
                    length = length + "\"";
                    maxLength = maxLength + "\"";
                    minLength = minLength + "\"";
                    pattern = pattern + "\"";
                    totalDigits = totalDigits + "\"";
                    enumeracion = enumeracion + "\"";
                    atributoXP.setAttributes(tipo + "," + uso + "," + fixed + "," + maxInclusive + "," + minInclusive + "," + maxExclusive + "," + minExclusive + "," + length + "," + maxLength + "," + minLength + "," + pattern + "," + totalDigits + "," + bind + "," + enumeracion);
                    listado.add(atributoXP);
                }
                if (!hijos.item(k).getNodeName().equals(prefijo + "sequence")) continue;
                this.generateXPathXSD(prefijo, ruta + elemento + "/", hijos.item(k).getChildNodes(), listado);
            }
        }
        return listado;
    }

    public Structure generateStructure(List<XPathXSD> xPathXSD) {
        Structure structure = new Structure();
        for (XPathXSD xPathXSD1 : xPathXSD) {
            String sRestriction;
            if (!xPathXSD1.getPath().contains("@")) continue;
            Definition definition = new Definition();
            definition.setText(xPathXSD1.getPath());
            definition.setBase(DefinitionOptionsBase.STRING);
            if (xPathXSD1.getAttributes().contains("bind=")) {
                String bind = xPathXSD1.getAttributes();
                bind = bind.substring(bind.indexOf("bind=") + 6, bind.length());
                if (!(bind = bind.substring(0, bind.indexOf("\""))).isEmpty()) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "***** Encontre BIND:" + bind);
                    definition.setBind(bind);
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "***** Encontre BIND:" + xPathXSD1.getAttributes());
                }
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:int")) {
                definition.setBase(DefinitionOptionsBase.INT);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:boolean")) {
                definition.setBase(DefinitionOptionsBase.BOOLEAN);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:integer")) {
                definition.setBase(DefinitionOptionsBase.INT);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:long")) {
                definition.setBase(DefinitionOptionsBase.LONG);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:double")) {
                definition.setBase(DefinitionOptionsBase.DOUBLE);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:decimal")) {
                definition.setBase(DefinitionOptionsBase.DECIMAL);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:token")) {
                definition.setBase(DefinitionOptionsBase.TOKEN);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:date")) {
                definition.setBase(DefinitionOptionsBase.DATE);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:time")) {
                definition.setBase(DefinitionOptionsBase.TIME);
            }
            if (xPathXSD1.getAttributes().contains("type=\"xsd:IDREF")) {
                definition.setBase(DefinitionOptionsBase.BUTTON);
            }
            definition.setUse(DefinitionOptionsUse.OPTIONAL);
            if (xPathXSD1.getAttributes().contains("use=\"required")) {
                definition.setUse(DefinitionOptionsUse.REQUIRED);
            }
            if (xPathXSD1.getAttributes().contains("use=\"prohibited")) {
                definition.setUse(DefinitionOptionsUse.PROHIBITED);
            }
            if (xPathXSD1.getAttributes().contains("fixed=\"")) {
                String sFixed = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("fixed=\"") + 7, xPathXSD1.getAttributes().length());
                sFixed = sFixed.substring(0, sFixed.indexOf("\""));
                definition.setFixed(sFixed);
            }
            Restriction restriction = new Restriction();
            restriction.setMaxInclusive(-1.0);
            if (xPathXSD1.getAttributes().contains("maxInclusive=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("maxInclusive=") + 14, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMaxInclusive(Double.parseDouble(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setMinInclusive(-1.0);
            if (xPathXSD1.getAttributes().contains("minInclusive=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("minInclusive=") + 14, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMinInclusive(Double.parseDouble(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setMaxExclusive(-1.0);
            if (xPathXSD1.getAttributes().contains("maxExclusive=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("maxExclusive=") + 14, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMaxExclusive(Double.parseDouble(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setMinExclusive(-1.0);
            if (xPathXSD1.getAttributes().contains("minExclusive=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("minExclusive=") + 14, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMinExclusive(Double.parseDouble(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setLength(-1L);
            if (xPathXSD1.getAttributes().contains("length=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("length=") + 8, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setLength(Long.parseLong(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setMaxLength(-1L);
            if (xPathXSD1.getAttributes().contains("maxLength=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("maxLength=") + 11, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMaxLength(Long.parseLong(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setMinLength(-1L);
            if (xPathXSD1.getAttributes().contains("minLength=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("minLength=") + 11, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setMinLength(Long.parseLong(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            restriction.setPattern(null);
            if (xPathXSD1.getAttributes().contains("pattern=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("pattern=") + 9, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    restriction.setPattern(sRestriction);
                }
            }
            restriction.setTotalDigits(-1L);
            if (xPathXSD1.getAttributes().contains("totalDigits=\"")) {
                sRestriction = xPathXSD1.getAttributes().substring(xPathXSD1.getAttributes().indexOf("totalDigits=") + 13, xPathXSD1.getAttributes().length());
                if (!(sRestriction = sRestriction.substring(0, sRestriction.indexOf(",") - 1)).isEmpty()) {
                    try {
                        restriction.setTotalDigits(Long.parseLong(sRestriction));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Utilidades:" + e.toString());
                    }
                }
            }
            if (xPathXSD1.getAttributes().contains("enumeration=\"")) {
                String sEnumeration = xPathXSD1.getAttributes();
                sEnumeration = sEnumeration.substring(sEnumeration.indexOf("enumeration=\"") + 13, sEnumeration.length() - 1);
                StringTokenizer st = new StringTokenizer(sEnumeration, ",");
                while (st.hasMoreElements()) {
                    restriction.getEnumeration().add(st.nextElement().toString());
                }
                definition.setRestriction(restriction);
            }
            structure.getDefinitionList().add(definition);
        }
        return structure;
    }

    public String NumerosLetras(BigInteger numeros) {
        StringBuffer bf = new StringBuffer(String.valueOf(numeros)).reverse();
        char[] n = String.valueOf(bf.toString()).toCharArray();
        if (n.length > 9) {
            this.letras = "ERROR: Solo cantidades menores a 10 digitos soportadas";
        } else if (numeros.intValue() == 0) {
            this.letras = "CERO";
        } else if (numeros.intValue() == 10) {
            this.letras = "DIECI";
        } else if (numeros.intValue() == 100) {
            this.letras = "CIEN";
        } else if (numeros.intValue() == 1000) {
            this.letras = "MIL";
        } else if (numeros.intValue() == 100000) {
            this.letras = "CIEN MIL";
        } else if (numeros.intValue() == 1000000) {
            this.letras = "UN MILLON";
        } else if (numeros.intValue() == 100000000) {
            this.letras = "CIEN MILLONES";
        } else {
            StringBuffer bf1;
            String val;
            if (n.length > 6) {
                val = String.valueOf(n[6]);
                if (n.length > 7) {
                    val = val + String.valueOf(n[7]);
                }
                if (n.length > 8) {
                    val = val + String.valueOf(n[8]);
                }
                bf1 = new StringBuffer(val).reverse();
                val = bf1.toString();
                this.letras = this.letras + this.getVal(Integer.valueOf(val));
                this.letras = n.length == 7 && String.valueOf(n[6]).equals("1") ? this.letras + " MILLON " : this.letras + " MILLONES ";
            }
            if (n.length > 3) {
                val = String.valueOf(n[3]);
                if (n.length > 4) {
                    val = val + String.valueOf(n[4]);
                }
                if (n.length > 5) {
                    val = val + String.valueOf(n[5]);
                }
                if (Integer.valueOf(val = (bf1 = new StringBuffer(val).reverse()).toString()) != 0) {
                    this.letras = this.letras + this.getVal(Integer.valueOf(val)) + " MIL ";
                }
            }
            if (n.length > 0) {
                val = String.valueOf(n[0]);
                if (n.length > 1) {
                    val = val + String.valueOf(n[1]);
                }
                if (n.length > 2) {
                    val = val + String.valueOf(n[2]);
                }
                bf1 = new StringBuffer(val).reverse();
                val = bf1.toString();
                this.letras = this.letras + this.getVal(Integer.valueOf(val));
            }
        }
        if (this.letras.startsWith("UNO MIL")) {
            this.letras = this.letras.replaceAll("UNO MIL", "MIL");
        }
        if (this.letras.contains("UNO MIL")) {
            this.letras = this.letras.replaceAll("UNO MIL", "UN MIL");
        }
        if (this.letras.contains("DIEZ Y UNO")) {
            this.letras = this.letras.replaceAll("DIEZ Y UNO", "ONCE");
        }
        if (this.letras.contains("DIEZ Y DOS")) {
            this.letras = this.letras.replaceAll("DIEZ Y DOS", "DOCE");
        }
        if (this.letras.contains("DIEZ Y TRES")) {
            this.letras = this.letras.replaceAll("DIEZ Y TRES", "TRECE");
        }
        if (this.letras.contains("DIEZ Y CUATRO")) {
            this.letras = this.letras.replaceAll("DIEZ Y CUATRO", "CATORCE");
        }
        if (this.letras.contains("DIEZ Y CINCO")) {
            this.letras = this.letras.replaceAll("DIEZ Y CINCO", "QUINCE");
        }
        if (this.letras.contains("DIEZ Y SEIS")) {
            this.letras = this.letras.replaceAll("DIEZ Y SEIS", "DIECISEIS");
        }
        if (this.letras.contains("DIEZ Y SIETE")) {
            this.letras = this.letras.replaceAll("DIEZ Y SIETE", "DIECISIETE");
        }
        if (this.letras.contains("DIEZ Y OCHO")) {
            this.letras = this.letras.replaceAll("DIEZ Y OCHO", "DIECIOCHO");
        }
        if (this.letras.contains("DIEZ Y NUEVE")) {
            this.letras = this.letras.replaceAll("DIEZ Y NUEVE", "DIECINUEVE");
        }
        if (this.letras.contains("VENTI UNO") && !this.letras.endsWith("VENTI UNO")) {
            this.letras = this.letras.replaceAll("VENTI UNO", "VENTIUN");
        }
        if (this.letras.contains("VENTI DOS")) {
            this.letras = this.letras.replaceAll("VENTI DOS", "VENTIDOS");
        }
        if (this.letras.contains("VENTI TRES")) {
            this.letras = this.letras.replaceAll("VENTI TRES", "VENTITRES");
        }
        if (this.letras.contains("VENTI CUATRO")) {
            this.letras = this.letras.replaceAll("VENTI CUATRO", "VENTICUATRO");
        }
        if (this.letras.contains("VENTI CINCO")) {
            this.letras = this.letras.replaceAll("VENTI CINCO", "VENTICINCO");
        }
        if (this.letras.contains("VENTI SEIS")) {
            this.letras = this.letras.replaceAll("VENTI SEIS", "VENTISEIS");
        }
        if (this.letras.contains("VENTI SIETE")) {
            this.letras = this.letras.replaceAll("VENTI SIETE", "VENTISIETE");
        }
        if (this.letras.contains("VENTI OCHO")) {
            this.letras = this.letras.replaceAll("VENTI OCHO", "VENTIOCHO");
        }
        if (this.letras.contains("VENTI NUEVE")) {
            this.letras = this.letras.replaceAll("VENTI NUEVE", "VENTINUEVE");
        }
        if (this.letras.endsWith(" Y ")) {
            this.letras = this.letras.replaceAll(" Y ", "");
        }
        return this.letras;
    }

    private String getVal(int numeros) {
        int i;
        if (numeros == 0) {
            return "";
        }
        String val = new String();
        char[] n = String.valueOf(numeros).toCharArray();
        for (i = 0; i < this.Valores.length; ++i) {
            if (this.Valores[i] != numeros) continue;
            return this.Letras[i];
        }
        if (n.length == 2) {
            if (String.valueOf(n[0]).equals("2")) {
                val = "VENTI ";
            } else {
                String nn = String.valueOf(n[0]) + "0";
                int mm = Integer.valueOf(nn);
                for (int i2 = 0; i2 < this.Valores.length; ++i2) {
                    if (mm != this.Valores[i2]) continue;
                    val = this.Letras[i2] + " Y ";
                    break;
                }
            }
            for (i = 0; i < 10; ++i) {
                if (Integer.valueOf(String.valueOf(n[1])) != this.Valores[i]) continue;
                val = val + this.Letras[i];
                break;
            }
        } else {
            int i3;
            String nn = String.valueOf(n[0]) + "00";
            int mm = Integer.valueOf(nn);
            for (int i4 = 0; i4 < this.Valores.length; ++i4) {
                if (mm != this.Valores[i4]) continue;
                val = this.Letras[i4] + " ";
                break;
            }
            String nnn = String.valueOf(n[1]) + "0";
            int mmm = Integer.valueOf(nnn);
            for (i3 = 0; i3 < this.Valores.length; ++i3) {
                if (mmm != this.Valores[i3]) continue;
                val = val + this.Letras[i3] + " Y ";
                break;
            }
            for (i3 = 0; i3 < 10; ++i3) {
                if (Integer.valueOf(String.valueOf(n[2])) != this.Valores[i3]) continue;
                val = val + this.Letras[i3];
                break;
            }
        }
        return val;
    }
}

