/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.common.DefinitionOptionsBase;
import cl.mc3d.as4p.common.DefinitionOptionsUse;
import com.hexidec.ekit.EkitCore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TextPane
extends JPanel {
    private String id = null;
    private DefinitionOptionsUse use;
    private DefinitionOptionsBase base;
    private String theme = null;
    private EkitCore htmlEditorPane;
    private JTextArea editorPane = new JTextArea();
    private String text = "";
    private boolean plainTextarea = false;

    public TextPane(boolean plainTextarea) {
        this.setLayout(new BorderLayout(5, 5));
        this.plainTextarea = plainTextarea;
        final JPanel jp = new JPanel(new GridLayout(4, 1));
        jp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                jp.setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.add("North", jp);
        if (!plainTextarea) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextPane.this.htmlEditorPane = new EkitCore();
                    if (TextPane.this.use == null) {
                        TextPane.this.setUse(DefinitionOptionsUse.OPTIONAL);
                    }
                    if (TextPane.this.use.equals((Object)DefinitionOptionsUse.PROHIBITED)) {
                        TextPane.this.htmlEditorPane.getTextPane().setEditable(false);
                    } else {
                        jp.setVisible(false);
                        jp.add(TextPane.this.htmlEditorPane.getMenuBar());
                        jp.add(TextPane.this.htmlEditorPane.getToolBarMain(true));
                        jp.add(TextPane.this.htmlEditorPane.getToolBarFormat(true));
                        jp.add(TextPane.this.htmlEditorPane.getToolBarStyles(true));
                    }
                    final Timer t = new Timer(10000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (!TextPane.this.htmlEditorPane.getTextPane().isFocusOwner()) {
                                jp.setVisible(false);
                            }
                        }
                    });
                    TextPane.this.htmlEditorPane.getTextPane().addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            jp.setVisible(true);
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            t.start();
                            t.setRepeats(false);
                        }
                    });
                    TextPane.this.add("Center", (Component)TextPane.this.htmlEditorPane);
                }
            });
        } else {
            this.add("Center", this.editorPane);
        }
    }

    public void setText(String text) {
        if (!this.plainTextarea) {
            if (!text.contains("<p")) {
                text = "<html><head></head><body><p style=\"margin-top: 0\">" + text + "</p></body></html>";
            }
            final String textFinal = text;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextPane.this.htmlEditorPane.setDocumentText(textFinal);
                }
            });
        }
        this.text = text;
    }

    public String getText() {
        if (!this.plainTextarea) {
            return this.htmlEditorPane.getDocumentText();
        }
        return this.editorPane.getText();
    }

    public void setEditable(boolean editable) {
        if (!this.plainTextarea) {
            if (this.htmlEditorPane != null) {
                this.htmlEditorPane.setEnabled(editable);
            }
        } else {
            this.editorPane.setEditable(false);
        }
    }

    public DefinitionOptionsUse getUse() {
        return this.use;
    }

    public void setUse(DefinitionOptionsUse use) {
        this.use = use;
    }

    public DefinitionOptionsBase getBase() {
        return this.base;
    }

    public void setBase(DefinitionOptionsBase base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id.contains(":")) {
            id = id.replaceAll(":", "__");
        }
        this.id = id;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme, boolean header) {
        this.theme = theme;
        if (theme != null) {
            if (header) {
                // empty if block
            }
            if (theme.toLowerCase().equals("eggplant")) {
                this.htmlEditorPane.setForeground(Color.WHITE);
                this.htmlEditorPane.setBackground(new Color(92, 86, 98));
            }
            if (theme.toLowerCase().equals("humanity")) {
                this.htmlEditorPane.setForeground(Color.BLACK);
                if (!header) {
                    this.htmlEditorPane.setBackground(new Color(241, 235, 223));
                }
            }
            if (theme.toLowerCase().equals("le-frog")) {
                this.htmlEditorPane.setForeground(Color.WHITE);
            }
            if (theme.toLowerCase().equals("midnight")) {
                this.htmlEditorPane.setForeground(Color.WHITE);
            }
        }
    }
}

