/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.ui;

import cl.mc3d.as4p.ui.InputText;
import cl.mc3d.as4p.ui.OutputLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DataTableHeaderCellRenderer
extends JPanel
implements TableCellRenderer {
    private final OutputLabel label = new OutputLabel();
    private final InputText field = new InputText();
    private final ConcurrentHashMap<String, String> filter;

    public InputText getField() {
        return this.field;
    }

    public DataTableHeaderCellRenderer(ConcurrentHashMap<String, String> filter, String theme) {
        super(new BorderLayout());
        this.label.setTheme(theme, true);
        this.setOpaque(false);
        this.filter = filter;
        this.add((Component)this.label, "North");
        this.add((Component)this.field, "Center");
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.label.getText().length() == 0) {
            this.label.setText("" + value);
            this.label.setHorizontalTextPosition(0);
        } else if (!this.label.getText().equals("" + value)) {
            this.field.setText("" + value);
            this.field.setText(this.field.getText().trim());
            if (!this.field.getText().equals("")) {
                this.filter.put(this.label.getText(), this.field.getText());
            } else {
                this.filter.remove(this.label.getText());
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.field.toString();
    }
}

