/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.AsyncFutureListener;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class IgniteFutureImpl<V>
implements IgniteFuture<V> {
    protected final IgniteInternalFuture<V> fut;
    protected final Executor defaultExecutor;

    public IgniteFutureImpl(IgniteInternalFuture<V> fut) {
        this(fut, null);
    }

    public IgniteFutureImpl(IgniteInternalFuture<V> fut, @Nullable Executor defaultExecutor) {
        assert (fut != null);
        this.fut = fut;
        this.defaultExecutor = defaultExecutor;
    }

    public IgniteInternalFuture<V> internalFuture() {
        return this.fut;
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public void listen(IgniteInClosure<? super IgniteFuture<V>> lsnr) {
        A.notNull(lsnr, "lsnr");
        if (this.defaultExecutor != null && !this.isDone()) {
            this.fut.listen(new InternalFutureListener(new AsyncFutureListener(lsnr, this.defaultExecutor)));
        } else {
            this.fut.listen(new InternalFutureListener(lsnr));
        }
    }

    @Override
    public void listenAsync(IgniteInClosure<? super IgniteFuture<V>> lsnr, Executor exec) {
        A.notNull(lsnr, "lsnr");
        A.notNull(exec, "exec");
        this.fut.listen(new InternalFutureListener(new AsyncFutureListener(lsnr, exec)));
    }

    @Override
    public <T> IgniteFuture<T> chain(IgniteClosure<? super IgniteFuture<V>, T> doneCb) {
        return new IgniteFutureImpl<T>(this.chainInternal(doneCb, null), this.defaultExecutor);
    }

    @Override
    public <T> IgniteFuture<T> chainAsync(IgniteClosure<? super IgniteFuture<V>, T> doneCb, Executor exec) {
        A.notNull(doneCb, "doneCb");
        A.notNull(exec, "exec");
        return new IgniteFutureImpl<T>(this.chainInternal(doneCb, exec), this.defaultExecutor);
    }

    protected <T> IgniteInternalFuture<T> chainInternal(final IgniteClosure<? super IgniteFuture<V>, T> doneCb, @Nullable Executor exec) {
        C1 clos = new C1<IgniteInternalFuture<V>, T>(){

            @Override
            public T apply(IgniteInternalFuture<V> fut) {
                assert (IgniteFutureImpl.this.fut == fut);
                try {
                    return doneCb.apply(IgniteFutureImpl.this);
                }
                catch (Exception e) {
                    throw new GridClosureException(e);
                }
            }
        };
        if (exec != null) {
            return this.fut.chain(clos, exec);
        }
        if (this.defaultExecutor != null && !this.isDone()) {
            return this.fut.chain(clos, this.defaultExecutor);
        }
        return this.fut.chain(clos);
    }

    @Override
    public boolean cancel() throws IgniteException {
        try {
            return this.fut.cancel();
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get() {
        try {
            return this.fut.get();
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get(long timeout) {
        try {
            return this.fut.get(timeout);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) {
        try {
            return this.fut.get(timeout, unit);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    protected RuntimeException convertException(IgniteCheckedException e) {
        return U.convertException(e);
    }

    public String toString() {
        return "IgniteFuture [orig=" + this.fut + ']';
    }

    private class InternalFutureListener
    implements IgniteInClosure<IgniteInternalFuture<V>> {
        private static final long serialVersionUID = 0L;
        private final IgniteInClosure<? super IgniteFuture<V>> lsnr;

        private InternalFutureListener(IgniteInClosure<? super IgniteFuture<V>> lsnr) {
            assert (lsnr != null);
            this.lsnr = lsnr;
        }

        public int hashCode() {
            return this.lsnr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(InternalFutureListener.class)) {
                return false;
            }
            InternalFutureListener lsnr0 = (InternalFutureListener)obj;
            return this.lsnr.equals(lsnr0.lsnr);
        }

        @Override
        public void apply(IgniteInternalFuture<V> fut) {
            assert (IgniteFutureImpl.this.fut == fut);
            this.lsnr.apply(IgniteFutureImpl.this);
        }

        public String toString() {
            return this.lsnr.toString();
        }
    }
}

