/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheValidateIndexesCommandArg;
import org.apache.ignite.internal.management.cache.ValidateIndexesClosure;
import org.apache.ignite.internal.management.cache.ValidateIndexesJobResult;
import org.apache.ignite.internal.management.cache.ValidateIndexesTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.annotation.InterruptibleVisorTask;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
@InterruptibleVisorTask
public class ValidateIndexesTask
extends VisorMultiNodeTask<CacheValidateIndexesCommandArg, ValidateIndexesTaskResult, ValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected ValidateIndexesTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        ValidateIndexesTaskResult taskResult = new ValidateIndexesTaskResult();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                taskResult.addException(res.getNode(), res.getException());
                continue;
            }
            taskResult.addResult(res.getNode(), (ValidateIndexesJobResult)res.getData());
        }
        return taskResult;
    }

    @Override
    protected VisorJob<CacheValidateIndexesCommandArg, ValidateIndexesJobResult> job(CacheValidateIndexesCommandArg arg) {
        return new ValidateIndexesJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<CacheValidateIndexesCommandArg> arg) {
        HashSet<UUID> nodeIds;
        Collection<ClusterNode> srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        CacheValidateIndexesCommandArg taskArg = arg.getArgument();
        HashSet<UUID> hashSet = nodeIds = taskArg.nodeIds() != null ? new HashSet<UUID>(Arrays.asList(taskArg.nodeIds())) : null;
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.id())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    private static class ValidateIndexesJob
    extends VisorJob<CacheValidateIndexesCommandArg, ValidateIndexesJobResult> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        private IgniteLogger log;

        protected ValidateIndexesJob(@Nullable CacheValidateIndexesCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ValidateIndexesJobResult run(CacheValidateIndexesCommandArg arg) throws IgniteException {
            A.notNull(arg, "arg");
            try {
                ValidateIndexesClosure clo = new ValidateIndexesClosure(this::isCancelled, arg.caches() == null ? null : new HashSet<String>(Arrays.asList(arg.caches())), arg.checkFirst(), arg.checkThrough(), arg.checkCrc(), arg.checkSizes());
                this.ignite.context().resource().injectGeneric(clo);
                return clo.call();
            }
            catch (Exception e) {
                this.cancel();
                throw new IgniteException(e);
            }
        }

        @Override
        public void cancel() {
            this.log.warning("Index validation was cancelled.");
            super.cancel();
        }

        public String toString() {
            return S.toString(ValidateIndexesJob.class, this);
        }
    }
}

