/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.reset_lost_partitions;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskResult;
import org.apache.ignite.internal.management.cache.CacheResetLostPartitionsCommandArg;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

public class CacheResetLostPartitionsTask
extends VisorOneNodeTask<CacheResetLostPartitionsCommandArg, CacheResetLostPartitionsTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CacheResetLostPartitionsCommandArg, CacheResetLostPartitionsTaskResult> job(CacheResetLostPartitionsCommandArg arg) {
        return new CacheResetLostPartitionsJob(arg, this.debug);
    }

    private static class CacheResetLostPartitionsJob
    extends VisorJob<CacheResetLostPartitionsCommandArg, CacheResetLostPartitionsTaskResult> {
        private static final long serialVersionUID = 0L;

        public CacheResetLostPartitionsJob(@Nullable CacheResetLostPartitionsCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public CacheResetLostPartitionsTaskResult run(CacheResetLostPartitionsCommandArg arg) throws IgniteException {
            try {
                CacheResetLostPartitionsTaskResult res = new CacheResetLostPartitionsTaskResult();
                res.setMessageMap(new HashMap<String, String>());
                if (F.isEmpty(arg.caches())) {
                    return res;
                }
                for (String groupName : arg.caches()) {
                    int grpId = CU.cacheId(groupName);
                    CacheGroupContext grp = this.ignite.context().cache().cacheGroup(grpId);
                    if (grp != null) {
                        SortedSet cacheNames = grp.caches().stream().map(GridCacheContext::name).collect(Collectors.toCollection(TreeSet::new));
                        if (F.isEmpty(cacheNames)) continue;
                        this.ignite.resetLostPartitions(cacheNames);
                        res.put(groupName, String.format("Reset LOST-partitions performed successfully. Cache group (name = '%s', id = %d), caches (%s).", groupName, grpId, cacheNames));
                        continue;
                    }
                    res.put(groupName, String.format("Cache group (name = '%s', id = %d) not found.", groupName, grpId));
                }
                return res;
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(CacheResetLostPartitionsJob.class, this);
        }
    }
}

