/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.io.Serializable;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;

public final class ClientCacheConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private CacheAtomicityMode atomicityMode = CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE;
    private int backups = 0;
    private CacheMode cacheMode = CacheConfiguration.DFLT_CACHE_MODE;
    private boolean eagerTtl = true;
    private String grpName = null;
    private long dfltLockTimeout = 0L;
    private PartitionLossPolicy partLossPlc = CacheConfiguration.DFLT_PARTITION_LOSS_POLICY;
    private boolean readFromBackup = true;
    private int rebalanceBatchSize = 524288;
    private long rebalanceBatchesPrefetchCnt = 3L;
    private long rebalanceDelay = 0L;
    private CacheRebalanceMode rebalanceMode = CacheConfiguration.DFLT_REBALANCE_MODE;
    private int rebalanceOrder = 0;
    private long rebalanceThrottle = 0L;
    private long rebalanceTimeout = 10000L;
    private CacheWriteSynchronizationMode writeSynchronizationMode = CacheWriteSynchronizationMode.PRIMARY_SYNC;
    private boolean cpOnRead = true;
    private String dataRegionName = null;
    private boolean statisticsEnabled = false;
    private int maxConcurrentAsyncOperations = 500;
    private int maxQryIteratorsCnt = 1024;
    private boolean onheapCacheEnabled = false;
    private int qryDetailMetricsSize = 0;
    private int qryParallelism = 1;
    private boolean sqlEscapeAll = false;
    private int sqlIdxMaxInlineSize = -1;
    private String sqlSchema = null;
    private CacheKeyConfiguration[] keyCfg = null;
    private QueryEntity[] qryEntities = null;
    private ExpiryPolicy expiryPlc;

    public ClientCacheConfiguration() {
    }

    public ClientCacheConfiguration(ClientCacheConfiguration ccfg) {
        this.atomicityMode = ccfg.getAtomicityMode();
        this.backups = ccfg.getBackups();
        this.cacheMode = ccfg.getCacheMode();
        this.cpOnRead = ccfg.isCopyOnRead();
        this.dataRegionName = ccfg.getDataRegionName();
        this.dfltLockTimeout = ccfg.getDefaultLockTimeout();
        this.eagerTtl = ccfg.isEagerTtl();
        this.expiryPlc = ccfg.getExpiryPolicy();
        this.grpName = ccfg.getGroupName();
        this.keyCfg = ccfg.getKeyConfiguration();
        this.maxConcurrentAsyncOperations = ccfg.getMaxConcurrentAsyncOperations();
        this.maxQryIteratorsCnt = ccfg.getMaxQueryIteratorsCount();
        this.name = ccfg.getName();
        this.onheapCacheEnabled = ccfg.isOnheapCacheEnabled();
        this.partLossPlc = ccfg.getPartitionLossPolicy();
        this.qryDetailMetricsSize = ccfg.getQueryDetailMetricsSize();
        this.qryEntities = ccfg.getQueryEntities();
        this.qryParallelism = ccfg.getQueryParallelism();
        this.readFromBackup = ccfg.isReadFromBackup();
        this.rebalanceBatchSize = ccfg.getRebalanceBatchSize();
        this.rebalanceBatchesPrefetchCnt = ccfg.getRebalanceBatchesPrefetchCount();
        this.rebalanceDelay = ccfg.getRebalanceDelay();
        this.rebalanceMode = ccfg.getRebalanceMode();
        this.rebalanceOrder = ccfg.getRebalanceOrder();
        this.rebalanceThrottle = ccfg.getRebalanceThrottle();
        this.rebalanceTimeout = ccfg.getRebalanceTimeout();
        this.sqlEscapeAll = ccfg.isSqlEscapeAll();
        this.sqlIdxMaxInlineSize = ccfg.getSqlIndexMaxInlineSize();
        this.sqlSchema = ccfg.getSqlSchema();
        this.statisticsEnabled = ccfg.isStatisticsEnabled();
        this.writeSynchronizationMode = ccfg.getWriteSynchronizationMode();
    }

    public String getName() {
        return this.name;
    }

    public ClientCacheConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public CacheAtomicityMode getAtomicityMode() {
        return this.atomicityMode;
    }

    public ClientCacheConfiguration setAtomicityMode(CacheAtomicityMode atomicityMode) {
        this.atomicityMode = atomicityMode;
        return this;
    }

    public int getBackups() {
        return this.backups;
    }

    public ClientCacheConfiguration setBackups(int backups) {
        this.backups = backups;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public ClientCacheConfiguration setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public boolean isEagerTtl() {
        return this.eagerTtl;
    }

    public ClientCacheConfiguration setEagerTtl(boolean eagerTtl) {
        this.eagerTtl = eagerTtl;
        return this;
    }

    public String getGroupName() {
        return this.grpName;
    }

    public ClientCacheConfiguration setGroupName(String newVal) {
        this.grpName = newVal;
        return this;
    }

    @Deprecated
    public long getDefaultLockTimeout() {
        return this.dfltLockTimeout;
    }

    @Deprecated
    public ClientCacheConfiguration setDefaultLockTimeout(long dfltLockTimeout) {
        this.dfltLockTimeout = dfltLockTimeout;
        return this;
    }

    public PartitionLossPolicy getPartitionLossPolicy() {
        return this.partLossPlc;
    }

    public ClientCacheConfiguration setPartitionLossPolicy(PartitionLossPolicy newVal) {
        this.partLossPlc = newVal;
        return this;
    }

    public boolean isReadFromBackup() {
        return this.readFromBackup;
    }

    public ClientCacheConfiguration setReadFromBackup(boolean readFromBackup) {
        this.readFromBackup = readFromBackup;
        return this;
    }

    @Deprecated
    public int getRebalanceBatchSize() {
        return this.rebalanceBatchSize;
    }

    @Deprecated
    public ClientCacheConfiguration setRebalanceBatchSize(int rebalanceBatchSize) {
        this.rebalanceBatchSize = rebalanceBatchSize;
        return this;
    }

    @Deprecated
    public long getRebalanceBatchesPrefetchCount() {
        return this.rebalanceBatchesPrefetchCnt;
    }

    @Deprecated
    public ClientCacheConfiguration setRebalanceBatchesPrefetchCount(long rebalanceBatchesPrefetchCnt) {
        this.rebalanceBatchesPrefetchCnt = rebalanceBatchesPrefetchCnt;
        return this;
    }

    @Deprecated
    public long getRebalanceDelay() {
        return this.rebalanceDelay;
    }

    @Deprecated
    public ClientCacheConfiguration setRebalanceDelay(long rebalanceDelay) {
        this.rebalanceDelay = rebalanceDelay;
        return this;
    }

    public CacheRebalanceMode getRebalanceMode() {
        return this.rebalanceMode;
    }

    public ClientCacheConfiguration setRebalanceMode(CacheRebalanceMode rebalanceMode) {
        this.rebalanceMode = rebalanceMode;
        return this;
    }

    public int getRebalanceOrder() {
        return this.rebalanceOrder;
    }

    public ClientCacheConfiguration setRebalanceOrder(int rebalanceOrder) {
        this.rebalanceOrder = rebalanceOrder;
        return this;
    }

    @Deprecated
    public long getRebalanceThrottle() {
        return this.rebalanceThrottle;
    }

    @Deprecated
    public ClientCacheConfiguration setRebalanceThrottle(long newVal) {
        this.rebalanceThrottle = newVal;
        return this;
    }

    @Deprecated
    public long getRebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    @Deprecated
    public ClientCacheConfiguration setRebalanceTimeout(long newVal) {
        this.rebalanceTimeout = newVal;
        return this;
    }

    public CacheWriteSynchronizationMode getWriteSynchronizationMode() {
        return this.writeSynchronizationMode;
    }

    public ClientCacheConfiguration setWriteSynchronizationMode(CacheWriteSynchronizationMode newVal) {
        this.writeSynchronizationMode = newVal;
        return this;
    }

    public boolean isCopyOnRead() {
        return this.cpOnRead;
    }

    public ClientCacheConfiguration setCopyOnRead(boolean newVal) {
        this.cpOnRead = newVal;
        return this;
    }

    public int getMaxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOperations;
    }

    public ClientCacheConfiguration setMaxConcurrentAsyncOperations(int newVal) {
        this.maxConcurrentAsyncOperations = newVal;
        return this;
    }

    public String getDataRegionName() {
        return this.dataRegionName;
    }

    public ClientCacheConfiguration setDataRegionName(String newVal) {
        this.dataRegionName = newVal;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ClientCacheConfiguration setStatisticsEnabled(boolean newVal) {
        this.statisticsEnabled = newVal;
        return this;
    }

    public int getMaxQueryIteratorsCount() {
        return this.maxQryIteratorsCnt;
    }

    public ClientCacheConfiguration setMaxQueryIteratorsCount(int newVal) {
        this.maxQryIteratorsCnt = newVal;
        return this;
    }

    public boolean isOnheapCacheEnabled() {
        return this.onheapCacheEnabled;
    }

    public ClientCacheConfiguration setOnheapCacheEnabled(boolean newVal) {
        this.onheapCacheEnabled = newVal;
        return this;
    }

    public int getQueryDetailMetricsSize() {
        return this.qryDetailMetricsSize;
    }

    public ClientCacheConfiguration setQueryDetailMetricsSize(int newVal) {
        this.qryDetailMetricsSize = newVal;
        return this;
    }

    public int getQueryParallelism() {
        return this.qryParallelism;
    }

    public ClientCacheConfiguration setQueryParallelism(int newVal) {
        this.qryParallelism = newVal;
        return this;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public ClientCacheConfiguration setSqlEscapeAll(boolean newVal) {
        this.sqlEscapeAll = newVal;
        return this;
    }

    public int getSqlIndexMaxInlineSize() {
        return this.sqlIdxMaxInlineSize;
    }

    public ClientCacheConfiguration setSqlIndexMaxInlineSize(int newVal) {
        this.sqlIdxMaxInlineSize = newVal;
        return this;
    }

    public String getSqlSchema() {
        return this.sqlSchema;
    }

    public ClientCacheConfiguration setSqlSchema(String newVal) {
        this.sqlSchema = newVal;
        return this;
    }

    public CacheKeyConfiguration[] getKeyConfiguration() {
        return this.keyCfg;
    }

    public ClientCacheConfiguration setKeyConfiguration(CacheKeyConfiguration ... newVal) {
        this.keyCfg = newVal;
        return this;
    }

    public QueryEntity[] getQueryEntities() {
        return this.qryEntities;
    }

    public ClientCacheConfiguration setQueryEntities(QueryEntity ... newVal) {
        this.qryEntities = newVal;
        return this;
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this.expiryPlc;
    }

    public ClientCacheConfiguration setExpiryPolicy(ExpiryPolicy expiryPlc) {
        this.expiryPlc = expiryPlc;
        return this;
    }

    public String toString() {
        return S.toString(ClientCacheConfiguration.class, this);
    }
}

